/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.wkc.core.utils;

import com.ibm.bi.platform.commons.crypto.JCAMCrypto;
import com.ibm.bi.platform.commons.messages.Message;
import com.ibm.bi.platform.moser.common.exceptions.MoserError;
import com.ibm.bi.platform.moser.common.exceptions.wkc.MissingCatalogConnectionException;
import com.ibm.bi.platform.moser.common.generated.metadata.DataSource;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.provider.ProviderProperties;
import com.ibm.bi.platform.moser.core.cm.Connection;
import com.ibm.bi.platform.moser.core.cm.DBDescriptor;
import com.ibm.bi.platform.moser.core.cm.Signon;
import com.ibm.bi.platform.moser.core.config.MoserConfig;
import com.ibm.bi.platform.moser.core.metadata.provider.jdbc.MoserMacroExpander;
import com.ibm.bi.platform.moser.core.module.IModuleObjectManager;
import com.ibm.bi.platform.moser.core.module.ModuleObjectManagerCM;
import com.ibm.bi.platform.moser.core.provider.jdbc.JDBCProviderProperties;
import com.ibm.bi.platform.moser.core.provider.jdbc.metadata.JDBCMetadataProvider;
import com.ibm.bi.platform.moser.core.provider.jdbc.metadata.MoserJDBCImporter;
import com.ibm.bi.platform.moser.core.rest.RESTClientResponse;
import com.ibm.bi.platform.moser.core.rest.service.RequestEnvironment;
import com.ibm.bi.platform.moser.core.utils.MoserUtil;
import com.ibm.bi.platform.moser.core.utils.Pair;
import com.ibm.bi.platform.wkc.core.rest.service.WatsonKnowledgeCenterService;
import com.ibm.bi.platform.wkc.core.utils.DatabaseTypeProperty;
import com.ibm.bi.platform.wkc.core.utils.WKCDatabaseTypeToXQE;
import com.ibm.bi.platform.wkc.core.utils.WKCTokenManager;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import javax.ws.rs.core.Response;
import org.apache.commons.codec.binary.Base64;

public class WKCUtil {
    public static final String WKC_CAT_ID = "wkcCatalogID";
    public static final String WKC_CAT_NAME = "wkcCatalogName";
    public static final String WKC_CONN_ID = "wkcConnectionID";
    public static final String WKC_CONN_NAME = "wkcConnectionName";
    public static final String WKC = "wkc";
    protected static final String WKC_RESOURCE = "resources";
    protected static final String WKC_META = "metadata";
    protected static final String WKC_ENTITY = "entity";
    protected static final String WKC_ASSET_ID = "asset_id";
    protected static final String WKC_NAME = "name";
    protected static final String WKC_ASSET_TYPE = "asset_type";
    protected static final String WKC_DS_TYPE = "datasource_type";
    protected static final String WKC_DATABASE = "database";
    protected static final String STR_URL = "url";
    protected static final String STR_EMPTY = "";
    protected static final String STR_USER = "user";
    protected static final String STR_PASSWORD = "password";
    protected static final String STR_DATASOURCE = "dataSource";
    protected static final String STR_JDBC_WKC = "jdbc:wkc:";
    protected static final String STR_SLASH = "/";
    public static final String STR_COLON = ":";
    public static final String STR_DOT = ".";
    protected static final String STR_VENDOR = "vendor";
    protected static final String STR_CATALOG = "Catalog";
    protected static final String STR_CONNECTION = "Connection";
    protected static final String STR_CATALOG_SHORT = "CTLG";
    protected static final String STR_CONNECTION_SHORT = "C";
    protected static final String STR_VENDOR_SHORT = "S";
    public static final String WKC_ID = "{\"S\":\"wkc\",\"CTLG\":\"%s\",\"C\":\"%s\"}";
    public static final String JDBC_URL_PATTERN = "URL=%s;DRIVER_NAME=%s;";
    protected static final String STR_CM_DATASOURCE = "cmDataSource";
    protected static final String STR_CM_CONNECTION = "cmConnection";
    protected static final String STR_WKC_CATALOG = "wkcCatalog";
    protected static final String STR_WKC_CONNECTION = "wkcConnection";
    protected static final String STR_CONNECTION_STRING = "connectionString";
    protected static final String STR_CREDENTIAL_STRING = "credentialString";
    protected static final String STR_USERNAME = "userName";
    protected static final String STR_CODE = "code";
    protected static final String STR_LEVEL = "level";
    protected static final String STR_ERR = "error";
    protected static final String STR_MSG = "message";
    protected static final String STR_ERRORS = "errors";
    protected static final String STR_ENCRYT_BEGIN = "<encryptedValue>";
    protected static final String STR_ENCRYT_END = "</encryptedValue>";
    protected static final String STR_CONN_CODE = "connCode";
    protected static final String STR_OK = "success";
    protected static final String STR_MSGS = "messages";
    protected static final String STR_DATA = "data";
    protected static final String STR_JDBC_COLON = "jdbc:";
    protected static final String STR_EXT_CATALOG = "EXTCATALOG";
    protected static final String STR_ENCRYPT_PREFIX = "{CA_enc}";

    public static JDBCProviderProperties getJDBCPropertyCatalogConnection(String cmDSName, String cmConnName, String wkcUser, String wkcPW, String wkcURL, String wkcCatId, String wkcConnId, Long expire, WatsonKnowledgeCenterService service, String[] wkcConnName) throws Exception {
        WKCTokenManager.WKCTokenInfo token = WKCTokenManager.getInstance().getToken(wkcURL, wkcUser, wkcPW, cmDSName, cmConnName, expire, service);
        if (token == null) {
            return null;
        }
        HashSet<String> conns = new HashSet<String>();
        conns.add(wkcConnId);
        CatalogWKC aCat = new CatalogWKC();
        aCat.catalogId = wkcCatId;
        aCat.catalogName = STR_EMPTY;
        List<CatalogConnectionWKC> allConnections = WKCUtil.getAllConnectionsInCatalog(cmDSName, token, wkcURL, aCat, conns, service);
        if (allConnections == null || allConnections.size() != 1) {
            return null;
        }
        if (wkcConnName != null && wkcConnName.length >= 1) {
            wkcConnName[0] = allConnections.get((int)0).connectionName;
        }
        return allConnections.get((int)0).prop;
    }

    public static List<WKCConnection> getAllConnections(String cmDSName, String cmConnName, String wkcUser, String wkcPW, String wkcURL, Long expire, WatsonKnowledgeCenterService service) throws Exception {
        WKCTokenManager.WKCTokenInfo token = WKCTokenManager.getInstance().getToken(wkcURL, wkcUser, wkcPW, cmDSName, cmConnName, expire, service);
        if (token == null) {
            return Collections.emptyList();
        }
        List<CatalogWKC> allCats = WKCUtil.getAllCatalogs(token, wkcURL, service);
        if (allCats.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<WKCConnection> rt = new ArrayList<WKCConnection>();
        for (CatalogWKC aCat : allCats) {
            List<CatalogConnectionWKC> allConnections = WKCUtil.getAllConnectionsInCatalog(cmDSName, token, wkcURL, aCat, null, service);
            for (CatalogConnectionWKC aCatConn : allConnections) {
                HashMap<String, String> mp = new HashMap<String, String>();
                mp.put(WKC_CAT_ID, aCatConn.catalog.catalogId);
                mp.put(WKC_CAT_NAME, aCatConn.catalog.catalogName);
                mp.put(WKC_CONN_ID, aCatConn.connectionId);
                mp.put(WKC_CONN_NAME, aCatConn.connectionName);
                WKCConnection wkcCat = new WKCConnection();
                wkcCat.wkcProp = mp;
                wkcCat.jdbcProp = aCatConn.prop;
                rt.add(wkcCat);
            }
        }
        return rt;
    }

    protected static List<CatalogWKC> getAllCatalogs(WKCTokenManager.WKCTokenInfo token, String wkcURL, WatsonKnowledgeCenterService theWKCService) {
        JSONObject json;
        RESTClientResponse resp;
        WatsonKnowledgeCenterService service = theWKCService;
        if (service == null) {
            service = new WatsonKnowledgeCenterService();
        }
        if ((resp = service.getCatalogs(wkcURL, token.bearerToken)).getResponseCode() == Response.Status.OK.getStatusCode() && (json = resp.getJSONObjectResponse()) != null) {
            return WKCUtil.getAllCatalogIds(json);
        }
        return Collections.emptyList();
    }

    protected static List<CatalogConnectionWKC> getAllConnectionsInCatalog(String cmDSName, WKCTokenManager.WKCTokenInfo token, String wkcURL, CatalogWKC cat, Set<String> connIds, WatsonKnowledgeCenterService theWKCService) {
        JSONObject json;
        RESTClientResponse resp;
        WatsonKnowledgeCenterService service = theWKCService;
        if (service == null) {
            service = new WatsonKnowledgeCenterService();
        }
        if ((resp = service.getConnections(wkcURL, token.bearerToken, cat.catalogId)).getResponseCode() == Response.Status.OK.getStatusCode() && (json = resp.getJSONObjectResponse()) != null) {
            return WKCUtil.retrieveAllConnectionsInCatalog(cmDSName, json, token, cat, connIds);
        }
        return Collections.emptyList();
    }

    protected static List<CatalogWKC> getAllCatalogIds(JSONObject json) {
        if (json == null) {
            return Collections.emptyList();
        }
        JSONArray allCats = (JSONArray)json.get((Object)"catalogs");
        if (allCats == null) {
            return Collections.emptyList();
        }
        ArrayList<CatalogWKC> rt = new ArrayList<CatalogWKC>();
        for (int i = 0; i < allCats.size(); ++i) {
            JSONObject aCat = (JSONObject)allCats.get(i);
            JSONObject meta = (JSONObject)aCat.get((Object)WKC_META);
            JSONObject entity = (JSONObject)aCat.get((Object)WKC_ENTITY);
            if (meta == null || entity == null) continue;
            String catId = (String)meta.get((Object)"guid");
            String catName = (String)entity.get((Object)WKC_NAME);
            if (catId == null || catId.isEmpty() || catName == null) continue;
            CatalogWKC c = new CatalogWKC();
            c.catalogId = catId;
            c.catalogName = catName;
            rt.add(c);
        }
        return rt;
    }

    protected static List<CatalogConnectionWKC> retrieveAllConnectionsInCatalog(String cmDSName, JSONObject json, WKCTokenManager.WKCTokenInfo token, CatalogWKC cat, Set<String> connIds) {
        ArrayList<CatalogConnectionWKC> rt = new ArrayList<CatalogConnectionWKC>();
        JSONArray allConns = (JSONArray)json.get((Object)WKC_RESOURCE);
        if (allConns == null) {
            return rt;
        }
        for (int i = 0; i < allConns.size(); ++i) {
            String dbCredentials;
            String dbServer;
            String dbWarehouse;
            String dbAccountName;
            String dbServiceName;
            JSONObject aConn = (JSONObject)allConns.get(i);
            JSONObject meta = (JSONObject)aConn.get((Object)WKC_META);
            JSONObject entity = (JSONObject)aConn.get((Object)WKC_ENTITY);
            if (meta == null || entity == null) continue;
            String id = (String)meta.get((Object)WKC_ASSET_ID);
            if (connIds != null && !connIds.contains(id)) continue;
            String name = (String)entity.get((Object)WKC_NAME);
            String dsType = (String)entity.get((Object)WKC_DS_TYPE);
            JSONObject connProp = (JSONObject)entity.get((Object)"properties");
            if (id == null || id.isEmpty() || name == null || dsType == null || connProp == null) continue;
            String dbPW = (String)connProp.get((Object)STR_PASSWORD);
            String dbUser = (String)connProp.get((Object)"username");
            TreeMap<DatabaseTypeProperty.URLParam, Object> params = new TreeMap<DatabaseTypeProperty.URLParam, Object>();
            String dbName = (String)connProp.get((Object)WKC_DATABASE);
            String dbHost = (String)connProp.get((Object)DatabaseTypeProperty.URLParam.HOST.getValue());
            if (dbHost != null && !dbHost.isEmpty()) {
                params.put(DatabaseTypeProperty.URLParam.HOST, dbHost);
            }
            Object objPort = connProp.get((Object)DatabaseTypeProperty.URLParam.PORT.getValue());
            Long dbPort = null;
            if (objPort instanceof Long) {
                dbPort = (Long)objPort;
            } else if (objPort instanceof String) {
                dbPort = Long.valueOf((String)objPort);
            }
            if (dbPort != null) {
                params.put(DatabaseTypeProperty.URLParam.PORT, dbPort);
            }
            if (dbName != null && !dbName.isEmpty()) {
                params.put(DatabaseTypeProperty.URLParam.DATABASE, dbName);
            }
            if ((dbServiceName = (String)connProp.get((Object)DatabaseTypeProperty.URLParam.SERVICE_NAME.getValue())) != null && !dbServiceName.isEmpty()) {
                params.put(DatabaseTypeProperty.URLParam.SERVICE_NAME, dbServiceName);
            }
            if ((dbAccountName = (String)connProp.get((Object)DatabaseTypeProperty.URLParam.ACCOUNT_NAME.getValue())) != null && !dbAccountName.isEmpty()) {
                params.put(DatabaseTypeProperty.URLParam.ACCOUNT_NAME, dbAccountName);
            }
            if ((dbWarehouse = (String)connProp.get((Object)DatabaseTypeProperty.URLParam.WAREHOUSE.getValue())) != null && !dbWarehouse.isEmpty()) {
                params.put(DatabaseTypeProperty.URLParam.WAREHOUSE, dbWarehouse);
            }
            if ((dbServer = (String)connProp.get((Object)DatabaseTypeProperty.URLParam.SERVER.getValue())) != null && !dbServer.isEmpty()) {
                params.put(DatabaseTypeProperty.URLParam.SERVER, dbServer);
            }
            if ((dbCredentials = (String)connProp.get((Object)DatabaseTypeProperty.URLParam.CREDENTIALS.getValue())) != null && !dbCredentials.isEmpty()) {
                params.put(DatabaseTypeProperty.URLParam.CREDENTIALS, dbCredentials);
            } else if (dbPW == null || dbPW.isEmpty() || dbUser == null || dbUser.isEmpty()) continue;
            Map<String, DatabaseTypeProperty> dsTypeMap = token.getWKCDSTypeToJDBC();
            DatabaseTypeProperty dbProp = dsTypeMap.get(dsType);
            if (dbProp == null || !dbProp.hasReqiredParams(params)) continue;
            if (params.containsKey((Object)DatabaseTypeProperty.URLParam.CREDENTIALS)) {
                String c = (String)params.get((Object)DatabaseTypeProperty.URLParam.CREDENTIALS);
                String f = WKCDatabaseTypeToXQE.getInstance().getTempFilePath(c, ".json");
                if (f == null) continue;
                params.put(DatabaseTypeProperty.URLParam.CREDENTIALS, f);
            }
            CatalogConnectionWKC catConn = new CatalogConnectionWKC();
            catConn.catalog = cat;
            catConn.connectionId = id;
            catConn.connectionName = name;
            catConn.prop = new JDBCProviderProperties();
            catConn.prop.setDriverClass(dbProp.jdbcProp.getDriverClass());
            String sURL = dbProp.getURL(params);
            catConn.prop.setUrl(sURL);
            Properties properties = new Properties();
            catConn.prop.setProperties(properties);
            if (dbUser != null && !dbUser.isEmpty()) {
                properties.setProperty(STR_USER, dbUser);
            }
            if (dbPW != null && !dbPW.isEmpty()) {
                properties.setProperty(STR_PASSWORD, dbPW);
            }
            properties.setProperty(STR_DATASOURCE, cmDSName);
            catConn.prop.setProperty(STR_DATASOURCE, cmDSName);
            WKCDatabaseTypeToXQE.addExtraProperties(dbProp.xqeDBTypeCode, connProp, properties, catConn.prop);
            rt.add(catConn);
        }
        return rt;
    }

    public static boolean isExternalCatalog(String interfacetType) {
        return STR_EXT_CATALOG.equals(interfacetType);
    }

    public static String[] split(String connectionString, String driverSplitter) {
        String[] tokens = null;
        int idx = connectionString.indexOf(driverSplitter);
        if (idx >= 0) {
            tokens = connectionString.split(driverSplitter);
            if (tokens.length > 1 && tokens[1].endsWith(";")) {
                tokens[1] = tokens[1].substring(0, tokens[1].length() - 1);
            }
        } else {
            tokens = new String[]{connectionString, STR_EMPTY};
            if (tokens[0].endsWith(";")) {
                tokens[0] = tokens[0].substring(0, tokens[0].length() - 1);
            }
        }
        return tokens;
    }

    public static String[] getUrlUserPassword(ProviderProperties props) {
        String[] rt = new String[]{null, null, null};
        String wkcURL = props.getProperty(STR_URL, STR_EMPTY);
        if (wkcURL.startsWith(STR_JDBC_WKC)) {
            wkcURL = wkcURL.substring(STR_JDBC_WKC.length());
        }
        Properties propsInProps = props.getProperties();
        String wkcUser = propsInProps.getProperty(STR_USER, STR_EMPTY);
        String wkcPW = propsInProps.getProperty(STR_PASSWORD, STR_EMPTY);
        if (wkcURL.endsWith(STR_SLASH)) {
            wkcURL = wkcURL.substring(0, wkcURL.length() - 1);
        }
        rt[0] = wkcURL;
        rt[1] = wkcUser;
        rt[2] = wkcPW;
        return rt;
    }

    public static String buildFullName(WKCConnection wkcConn, String catalog, String schema) {
        String wkcName = wkcConn.wkcProp.get(WKC_CAT_NAME) + STR_SLASH + wkcConn.wkcProp.get(WKC_CONN_NAME);
        String id = MoserUtil.buildSchemaDefaultName(STR_EMPTY, catalog, schema);
        id = id.length() == 0 ? wkcName : wkcName + STR_SLASH + id;
        return id;
    }

    public static String buildIdentifier(String databaseName, String connectionName, String catalog, String schema, WKCConnection wkcConn) {
        String wkcId = String.format(WKC_ID, wkcConn.wkcProp.get(WKC_CAT_ID), wkcConn.wkcProp.get(WKC_CONN_ID));
        return databaseName + STR_COLON + connectionName + STR_COLON + catalog + STR_COLON + schema + STR_COLON + Base64.encodeBase64String((byte[])wkcId.getBytes(StandardCharsets.UTF_8));
    }

    public static JSONObject generateSpecification(WKCConnection wkcConn) {
        String catId = wkcConn.wkcProp.get(WKC_CAT_ID);
        String connId = wkcConn.wkcProp.get(WKC_CONN_ID);
        JSONObject specification = new JSONObject();
        JSONObject wkc = new JSONObject();
        specification.put((Object)STR_VENDOR, (Object)wkc);
        wkc.put((Object)WKC_NAME, (Object)WKC);
        wkc.put((Object)STR_CATALOG, (Object)catId);
        wkc.put((Object)STR_CONNECTION, (Object)connId);
        return specification;
    }

    public static boolean isJDBCWKC(Connection conn) {
        if (conn.getConnectionType() != Connection.ConnectionType.JDBC) {
            return false;
        }
        return WKC.equals(conn.getVendorType());
    }

    public static JDBCProviderProperties getJDBCProviderProperties(String cmDSName, String catalog, String schema, String table, Pair<Set<String>, Set<String>> inOrExcludedTables, Map<String, String> vendor, Connection connection, ProviderProperties props, String[] rt) throws Exception {
        String wkcCatId = null;
        String wkcConnId = null;
        if (vendor != null) {
            wkcCatId = vendor.get(STR_CATALOG_SHORT);
            if (wkcCatId == null) {
                wkcCatId = vendor.get(STR_CATALOG);
            }
            if ((wkcConnId = vendor.get(STR_CONNECTION_SHORT)) == null) {
                wkcConnId = vendor.get(STR_CONNECTION);
            }
        }
        if (wkcCatId == null || wkcConnId == null) {
            throw new MissingCatalogConnectionException();
        }
        if (rt != null) {
            if (rt.length >= 1) {
                rt[0] = wkcCatId;
            }
            if (rt.length >= 2) {
                rt[1] = wkcConnId;
            }
        }
        String[] sPprops = WKCUtil.getUrlUserPassword(props);
        String[] wkcConnName = new String[]{null};
        JDBCProviderProperties jdbcProp = WKCUtil.getJDBCPropertyCatalogConnection(cmDSName, connection.getName(), sPprops[1], sPprops[2], sPprops[0], wkcCatId, wkcConnId, null, null, wkcConnName);
        if (jdbcProp == null) {
            throw new MissingCatalogConnectionException();
        }
        jdbcProp.setCatalog(catalog);
        jdbcProp.setSchema(schema);
        jdbcProp.setTable(table);
        MoserJDBCImporter.setInOrExcludedTablesIfExists(jdbcProp, inOrExcludedTables);
        if (rt != null && rt.length >= 3) {
            rt[2] = wkcConnName[0];
        }
        return jdbcProp;
    }

    public static String getContainer(String cmDSName, String connName, String wkcCat, String wkcConn, String catalog, String schema, String sep, boolean bnull) {
        StringBuilder sb = new StringBuilder();
        if (bnull || cmDSName != null) {
            sb.append(cmDSName);
            sb.append(sep);
        }
        if (bnull || connName != null) {
            sb.append(connName);
            sb.append(sep);
        }
        if (bnull || wkcCat != null) {
            sb.append(wkcCat);
            sb.append(sep);
        }
        if (bnull || wkcConn != null) {
            sb.append(wkcConn);
            sb.append(sep);
        }
        if (bnull || catalog != null) {
            sb.append(catalog);
            sb.append(sep);
        }
        if (bnull || schema != null) {
            sb.append(schema);
        }
        return sb.toString();
    }

    public static String buildWKCDatasourceConnectionString(String cmDSName, String connName, String[] wkcCatConn) {
        JSONObject rt = new JSONObject();
        rt.put((Object)STR_VENDOR, (Object)WKC);
        rt.put((Object)STR_CM_DATASOURCE, (Object)cmDSName);
        rt.put((Object)STR_CM_CONNECTION, (Object)connName);
        if (wkcCatConn != null) {
            if (wkcCatConn.length >= 1) {
                rt.put((Object)STR_WKC_CATALOG, (Object)wkcCatConn[0]);
            }
            if (wkcCatConn.length >= 2) {
                rt.put((Object)STR_WKC_CONNECTION, (Object)wkcCatConn[1]);
            }
            if (wkcCatConn.length >= 3) {
                rt.put((Object)WKC_CONN_NAME, (Object)wkcCatConn[2]);
            }
        }
        return rt.toString();
    }

    public static String injectVendorObject(String connectionSpec, Object jVendor) {
        if (!(jVendor instanceof JSONObject)) {
            return connectionSpec;
        }
        try {
            JSONObject jConnSpec = JSONObject.parse((String)connectionSpec);
            if (jConnSpec == null) {
                return connectionSpec;
            }
            jConnSpec.put((Object)STR_VENDOR, jVendor);
            return jConnSpec.toString();
        }
        catch (Exception e) {
            return connectionSpec;
        }
    }

    public static String injectVendorString(String connectionSpec, String v) {
        if (v == null || v.isEmpty()) {
            return connectionSpec;
        }
        String value = new String(Base64.decodeBase64((String)v));
        try {
            JSONObject jVendor = JSONObject.parse((String)value);
            if (jVendor == null) {
                return connectionSpec;
            }
            return WKCUtil.injectVendorObject(connectionSpec, jVendor);
        }
        catch (Exception e) {
            return connectionSpec;
        }
    }

    public static boolean testConnection(Connection connection, String u, String p) {
        String wkcURL = connection.getURL();
        if (wkcURL.startsWith(STR_JDBC_WKC)) {
            wkcURL = wkcURL.substring(STR_JDBC_WKC.length());
        }
        try {
            return WKCTokenManager.getInstance().getToken(wkcURL, u, p, "ds", "conn", null, null) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Object testWithCredential(JSONObject definition, RequestEnvironment env) {
        Locale lc = env.getProductLocale();
        try {
            String[] parts = new String[]{null, null, null};
            JSONObject response = new JSONObject();
            if (WKCUtil.getRequiredParams(definition, parts, response, lc)) {
                Connection c = new Connection(new MoserMacroExpander(env));
                c.setName("test");
                c.initializeConnectionString(parts[0]);
                if (STR_EXT_CATALOG.equals(c.getInterfaceType()) && c.getConnectionType() == Connection.ConnectionType.JDBC && WKC.equals(c.getVendorType())) {
                    if (WKCUtil.testConnection(c, parts[1], parts[2])) {
                        WKCUtil.buildTestConnnectionResponse(response, Boolean.TRUE, new Message(MoserError.MSR_WKC_VALID_CONNECTION_STRING), lc);
                        return MoserUtil.getResponse(Response.Status.OK, (Object)response);
                    }
                    WKCUtil.buildTestConnnectionResponse(response, Boolean.FALSE, new Message(MoserError.MSR_WKC_INVALID_CONNECTION_STRING), lc);
                } else {
                    WKCUtil.buildTestConnnectionResponse(response, Boolean.FALSE, new Message(MoserError.MSR_WKC_UNKNOWN_CONNECTION_TYPE), lc);
                }
            }
            return MoserUtil.getResponse(Response.Status.BAD_REQUEST, (Object)response);
        }
        catch (Exception e) {
            JSONObject response = new JSONObject();
            WKCUtil.buildTestConnnectionResponse(response, Boolean.FALSE, new Message(MoserError.GENERAL_ERROR, (Object)e.getLocalizedMessage()), lc);
            return MoserUtil.getResponse(Response.Status.INTERNAL_SERVER_ERROR, (Object)response);
        }
    }

    protected static void buildTestConnnectionResponse(JSONObject response, Boolean bOK, Message msg, Locale lc) {
        JSONArray data = new JSONArray();
        JSONObject a = new JSONObject();
        a.put((Object)STR_CONN_CODE, (Object)WKC);
        a.put((Object)STR_OK, (Object)bOK);
        JSONArray m = new JSONArray();
        m.add((Object)msg.getLocalizedMessage(lc));
        a.put((Object)STR_MSGS, (Object)m);
        data.add((Object)a);
        response.put((Object)STR_DATA, (Object)data);
    }

    protected static boolean getRequiredParams(JSONObject definition, String[] parts, JSONObject response, Locale lc) {
        Object connStr = definition.get((Object)STR_CONNECTION_STRING);
        Object credential = definition.get((Object)STR_CREDENTIAL_STRING);
        Object user = definition.get((Object)STR_USERNAME);
        Object pw = definition.get((Object)STR_PASSWORD);
        if (!(connStr instanceof String)) {
            WKCUtil.buildErrors(response, new Message(MoserError.MSR_WKC_MISSING_CONNECTION_STRING), lc);
            return false;
        }
        if (credential instanceof String) {
            return WKCUtil.getRequiredParamsFromCredential((String)connStr, (String)credential, parts, response, lc);
        }
        if (user instanceof String && pw instanceof String) {
            parts[0] = (String)connStr;
            parts[1] = (String)user;
            parts[2] = (String)pw;
            return true;
        }
        WKCUtil.buildErrors(response, new Message(MoserError.MSR_WKC_MISSING_USERNAME_PASSWORD), lc);
        return false;
    }

    protected static boolean getRequiredParamsFromCredential(String connStr, String credential, String[] parts, JSONObject response, Locale lc) {
        int idx = credential.indexOf(STR_ENCRYT_BEGIN);
        if (idx < 0) {
            WKCUtil.buildErrors(response, new Message(MoserError.MSR_WKC_INVALID_CREDENTIAL), lc);
            return false;
        }
        try {
            String sCredential = credential.substring(idx + STR_ENCRYT_BEGIN.length());
            idx = sCredential.indexOf(STR_ENCRYT_END);
            if (idx < 0) {
                WKCUtil.buildErrors(response, new Message(MoserError.MSR_WKC_INVALID_CREDENTIAL), lc);
                return false;
            }
            if ((sCredential = sCredential.substring(0, idx)).isEmpty()) {
                WKCUtil.buildErrors(response, new Message(MoserError.MSR_WKC_INVALID_CREDENTIAL), lc);
                return false;
            }
            Signon s = new Signon();
            String str = s.decrypt(sCredential);
            if (!s.parseCredentials(str)) {
                WKCUtil.buildErrors(response, new Message(MoserError.MSR_WKC_INVALID_CREDENTIAL), lc);
                return false;
            }
            String u = s.getUser();
            String p = s.getPassword();
            if (u != null && !u.isEmpty() && p != null && !p.isEmpty()) {
                parts[0] = connStr;
                parts[1] = u;
                parts[2] = p;
                return true;
            }
            WKCUtil.buildErrors(response, new Message(MoserError.MSR_WKC_MISSING_USERNAME_PASSWORD), lc);
            return false;
        }
        catch (Exception e) {
            WKCUtil.buildErrors(response, new Message(MoserError.MSR_WKC_INVALID_CREDENTIAL), lc);
            return false;
        }
    }

    protected static void buildErrors(JSONObject response, Message msg, Locale lc) {
        JSONArray errs = new JSONArray();
        JSONObject err = new JSONObject();
        err.put((Object)STR_CODE, (Object)msg.getMessageKey().getErrorCode());
        err.put((Object)STR_LEVEL, (Object)STR_ERR);
        err.put((Object)STR_MSG, (Object)msg.getLocalizedMessage(lc));
        errs.add((Object)err);
        response.put((Object)STR_ERRORS, (Object)errs);
    }

    public static JSONArray trimSpecification(JSONArray schemas) {
        for (int i = 0; i < schemas.size(); ++i) {
            JSONObject aS = (JSONObject)schemas.get(i);
            JSONObject spec = (JSONObject)aS.get((Object)"specification");
            if (spec == null) continue;
            JSONObject ven = (JSONObject)spec.get((Object)STR_VENDOR);
            if (ven == null) {
                aS.remove((Object)"specification");
                continue;
            }
            JSONObject newSpec = new JSONObject();
            newSpec.put((Object)STR_VENDOR, (Object)ven);
            aS.put((Object)"specification", (Object)newSpec);
        }
        return schemas;
    }

    public static void updateJDBCConnection(IModuleObjectManager mm, Module physicalModule) {
        if (!(mm instanceof ModuleObjectManagerCM)) {
            return;
        }
        ModuleObjectManagerCM cm = (ModuleObjectManagerCM)mm;
        List dss = physicalModule.basicGetDataSource();
        if (dss == null || dss.isEmpty()) {
            return;
        }
        DataSource ds = (DataSource)dss.get(0);
        String dbType = ds.getDatabaseType();
        if (!WKC.equals(dbType)) {
            return;
        }
        String catalog = ds.getCatalog();
        String schema = ds.getSchema();
        String connStr = ds.getConnectionString();
        try {
            JSONObject json = JSONObject.parse((String)connStr);
            String cmDS = (String)json.get((Object)STR_CM_DATASOURCE);
            String cmConn = (String)json.get((Object)STR_CM_CONNECTION);
            String wkcCat = (String)json.get((Object)STR_WKC_CATALOG);
            String wkcConn = (String)json.get((Object)STR_WKC_CONNECTION);
            DBDescriptor dbDesc = new DBDescriptor(cmDS, cmConn, null, null, cm.getReqEnvironment());
            dbDesc.init();
            String[] rt = new String[]{null, null};
            HashMap<String, String> vendor = new HashMap<String, String>();
            vendor.put(STR_CATALOG, wkcCat);
            vendor.put(STR_CONNECTION, wkcConn);
            JDBCProviderProperties jdbcprop = WKCUtil.getJDBCProviderProperties(cmDS, catalog, schema, JDBCMetadataProvider.buildTableFilter(MoserConfig.getDBTableFilters()), null, vendor, dbDesc.getConnection(), dbDesc.getProviderProperties(), rt);
            String[] dbTypeInURL = new String[]{null};
            ds.setConnectionString(WKCUtil.buildJDBCConnectionString(jdbcprop.getUrl(), jdbcprop.getDriverClass(), dbTypeInURL, jdbcprop));
            Properties props = jdbcprop.getProperties();
            ds.setUser(props.getProperty(STR_USER));
            ds.setPassword(WKCUtil.encryptValue(props.getProperty(STR_PASSWORD)));
            ds.setDatabaseType(dbTypeInURL[0]);
            ds.setCmDataSource(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static String encryptValue(String plainValue) {
        if (plainValue == null || plainValue.isEmpty()) {
            return plainValue;
        }
        try {
            byte[] result = JCAMCrypto.createEncryptingSession().encryptData(plainValue.getBytes(StandardCharsets.UTF_8));
            return STR_ENCRYPT_PREFIX + Base64.encodeBase64String((byte[])result);
        }
        catch (Exception exception) {
            return plainValue;
        }
    }

    protected static String buildJDBCConnectionString(String url, String driver, String[] rt, JDBCProviderProperties jdbcprop) {
        String s;
        String dbTypeCode = STR_EMPTY;
        int idx = url.indexOf(STR_JDBC_COLON);
        if (idx >= 0 && (idx = (s = url.substring(STR_JDBC_COLON.length())).indexOf(STR_COLON)) >= 0) {
            rt[0] = s.substring(0, idx);
            rt[0] = WKCDatabaseTypeToXQE.getInstance().getXQEDatabaseCode(rt[0]);
            dbTypeCode = rt[0];
        }
        String connString = String.format(JDBC_URL_PATTERN, url, driver);
        return WKCDatabaseTypeToXQE.addExtraPropertiesToConnectionString(connString, dbTypeCode, jdbcprop);
    }

    public static String buildSchemaName(String dataSourceName, JSONObject schema) {
        JSONObject spec = (JSONObject)schema.get((Object)"specification");
        if (spec == null) {
            return MoserUtil.buildSchemaDefaultName(dataSourceName, (String)schema.get((Object)"catalog"), (String)schema.get((Object)"schema"));
        }
        JSONObject ven = (JSONObject)spec.get((Object)STR_VENDOR);
        if (ven == null) {
            return MoserUtil.buildSchemaDefaultName(dataSourceName, (String)schema.get((Object)"catalog"), (String)schema.get((Object)"schema"));
        }
        String name = (String)ven.get((Object)WKC_NAME);
        if (WKC.equals(name)) {
            return WKCUtil.getSchemaDefaultName(ven, schema);
        }
        return MoserUtil.buildSchemaDefaultName(dataSourceName, (String)schema.get((Object)"catalog"), (String)schema.get((Object)"schema"));
    }

    public static String getSchemaDefaultName(JSONObject ven, JSONObject schema) {
        String wkcName = (String)ven.get((Object)STR_CATALOG) + STR_SLASH + (String)ven.get((Object)STR_CONNECTION);
        String id = MoserUtil.buildSchemaDefaultName(STR_EMPTY, (String)schema.get((Object)"catalog"), (String)schema.get((Object)"schema"));
        id = id.length() == 0 ? wkcName : wkcName + STR_SLASH + id;
        return id;
    }

    private static final class CatalogConnectionWKC {
        protected CatalogWKC catalog;
        protected String connectionId;
        protected String connectionName;
        protected JDBCProviderProperties prop;

        private CatalogConnectionWKC() {
        }
    }

    private static final class CatalogWKC {
        protected String catalogId;
        protected String catalogName;

        private CatalogWKC() {
        }
    }

    public static final class WKCConnection {
        protected JDBCProviderProperties jdbcProp;
        protected Map<String, String> wkcProp;

        public Map<String, String> getWKCProp() {
            return this.wkcProp;
        }

        public JDBCProviderProperties getJDBCProp() {
            return this.jdbcProp;
        }
    }
}

