/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.cognos.adaptor;

import com.ibm.cognos.jdbc.adaptor.AbstractAdaptor;
import com.ibm.cognos.jdbc.adaptor.AdaptorFactory;
import com.ibm.cognos.jdbc.adaptor.AdaptorMethodOverride;
import com.ibm.cognos.jdbc.adaptor.BaseConnectionAdaptor;
import com.ibm.cognos.jdbc.adaptor.IWrapper;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import oracle.jdbc.driver.cognos.adaptor.OracleDriverOracleAdaptorFactory;

public class OracleConnectionAdaptor
extends BaseConnectionAdaptor {
    public OracleConnectionAdaptor(Connection connection, AdaptorFactory factory) {
        super(connection, factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AdaptorMethodOverride(checkForSqlOverride=false)
    public String getQueryPlan(String query) throws SQLException {
        Statement stmt = null;
        ResultSet result = null;
        String plan = null;
        try {
            stmt = this.getConnection().createStatement();
            stmt.execute("EXPLAIN PLAN FOR " + query);
            result = stmt.executeQuery("SELECT XMLSERIALIZE(DOCUMENT DBMS_XPLAN.BUILD_PLAN_XML) FROM DUAL");
            if (result.next()) {
                plan = result.getString(1);
            }
        }
        finally {
            if (result != null) {
                result.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        return plan;
    }

    @AdaptorMethodOverride(checkForSqlOverride=false)
    public void switchUser(Boolean isSessionStart, String userID, String passWD, String registry) throws SQLException {
        if (isSessionStart.booleanValue()) {
            Properties properties = new Properties();
            properties.put("PROXY_USER_NAME", userID);
            if (passWD != null && 0 != passWD.trim().length()) {
                properties.put("PROXY_USER_PASSWORD", passWD);
            }
            if (((OracleDriverOracleAdaptorFactory)this.factory).isProxySession()) {
                ((OracleDriverOracleAdaptorFactory)this.factory).closeProxySession();
            }
            ((OracleDriverOracleAdaptorFactory)this.factory).openProxySession(properties);
        } else if (((OracleDriverOracleAdaptorFactory)this.factory).isProxySession()) {
            ((OracleDriverOracleAdaptorFactory)this.factory).closeProxySession();
        }
    }

    public static class Wrapper
    implements IWrapper {
        public AbstractAdaptor wrap(Object toWrap, AdaptorFactory factory) {
            return new OracleConnectionAdaptor((Connection)toWrap, factory);
        }
    }
}

