/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.cognos.adaptor;

import com.ibm.cognos.jdbc.adaptor.AbstractPropertyLoader;
import com.ibm.cognos.jdbc.adaptor.AdaptorFactory;
import com.ibm.cognos.jdbc.adaptor.ReflectionHelper;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import java.util.TimeZone;
import oracle.jdbc.driver.cognos.adaptor.OracleConnectionAdaptor;
import oracle.jdbc.driver.cognos.adaptor.OracleDatabaseMetadataAdaptor;
import oracle.jdbc.driver.cognos.adaptor.OracleMetadataMapper;
import oracle.jdbc.driver.cognos.adaptor.OracleResultSetAdaptor;

public class OracleDriverOracleAdaptorFactory
extends AdaptorFactory {
    private static volatile AbstractPropertyLoader propertyLoader;
    protected static String ORACLECONNECTIONCLASS;
    private static final int ENUM_PROXYTYPE_USER_NAME = 1;
    private static final int ENUM_PROXY_SESSION = 1;
    private OracleConnectionHelper oracleConnectionHelper;

    protected void setPropertyLoader(AbstractPropertyLoader loader) {
        propertyLoader = loader;
    }

    public AbstractPropertyLoader getPropertyLoader() {
        return propertyLoader;
    }

    protected void registerWrappers() {
        this.setConnectionWrapper(new OracleConnectionAdaptor.Wrapper());
        this.setResultSetWrapper(new OracleResultSetAdaptor.Wrapper());
        this.setMetadataMapper(new OracleMetadataMapper(this));
        this.setDatabaseMetadataWrapper(new OracleDatabaseMetadataAdaptor.Wrapper());
    }

    public Connection connect(Driver driver, String url, Properties driverProperties, Properties ibmCognosProperties) throws SQLException {
        Connection connection = driver.connect(url, driverProperties);
        this.oracleConnectionHelper = new OracleConnectionHelper(connection);
        this.oracleConnectionHelper.setSessionTimeZone(TimeZone.getDefault().getID());
        if (ibmCognosProperties != null && ibmCognosProperties.getProperty("ibmcognos.decfloat") != null) {
            boolean decfloat = "true".compareToIgnoreCase(ibmCognosProperties.getProperty("ibmcognos.decfloat")) == 0;
            ((OracleMetadataMapper)this.getMetadataMapper()).setDecfloat(decfloat);
        }
        return connection;
    }

    public void openProxySession(Properties prop) throws SQLException {
        this.oracleConnectionHelper.openProxySession(prop);
    }

    public void closeProxySession() throws SQLException {
        this.oracleConnectionHelper.closeProxySession();
    }

    public boolean isProxySession() throws SQLException {
        return this.oracleConnectionHelper.isProxySession();
    }

    static {
        ORACLECONNECTIONCLASS = "oracle.jdbc.driver.OracleConnection";
    }

    private class OracleConnectionHelper {
        private final ReflectionHelper rh = new ReflectionHelper(ORACLECONNECTIONCLASS);
        private final Object o;

        public OracleConnectionHelper(Object object) {
            this.o = object;
            Class[] typesForSetSessionTimeZone = new Class[]{String.class};
            this.rh.registerMethod("setSessionTimeZone", typesForSetSessionTimeZone);
            Class[] typesForOpenProxySessionMethod = new Class[]{Integer.TYPE, Properties.class};
            this.rh.registerMethod("openProxySession", typesForOpenProxySessionMethod);
            Class[] typesForCloseMethod = new Class[]{Integer.TYPE};
            this.rh.registerMethod("close", typesForCloseMethod);
            this.rh.registerMethod("isProxySession", null);
            this.rh.registerField("PROXYTYPE_USER_NAME");
            this.rh.registerField("PROXY_SESSION");
        }

        public void setSessionTimeZone(String timezoneID) throws SQLException {
            this.rh.invokeJDBCMethod(this.o, "setSessionTimeZone", new Object[]{timezoneID});
        }

        public void openProxySession(Properties prop) throws SQLException {
            this.rh.invokeJDBCMethod(this.o, "openProxySession", new Object[]{this.rh.getField(this.o, "PROXYTYPE_USER_NAME", (Object)1), prop});
        }

        public void closeProxySession() throws SQLException {
            this.rh.invokeJDBCMethod(this.o, "close", new Object[]{this.rh.getField(this.o, "PROXY_SESSION", (Object)1)});
        }

        public boolean isProxySession() throws SQLException {
            return (Boolean)this.rh.invokeJDBCMethod(this.o, "isProxySession", new Object[0]);
        }
    }
}

