/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.cognos.adaptor;

import com.ibm.cognos.jdbc.adaptor.AbstractAdaptor;
import com.ibm.cognos.jdbc.adaptor.AdaptorFactory;
import com.ibm.cognos.jdbc.adaptor.AdaptorMethodOverride;
import com.ibm.cognos.jdbc.adaptor.BaseResultSetAdaptor;
import com.ibm.cognos.jdbc.adaptor.IWrapper;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.TimeZone;

public class OracleResultSetAdaptor
extends BaseResultSetAdaptor {
    private static final int TIMESTAMP_PARTS = 7;
    private static final String TIMESTAMP_TZ_SPLITTER = "[ ]|[:]|[\\.]";
    private static final String TIMESTAMP_TZ_FORMATER = "%1$s %2$s:%3$s:%4$s.%5$s%6$s:%7$s";
    private static final int MILLISECONDS_PER_SECOND = 1000;
    private static final int SECONDS_PER_HOUR = 3600;
    private static final int MINUTES_PER_HOUR = 60;
    static final int TZMINUTE_INDEX = 6;
    static final int TZHOUR_INDEX = 5;
    static final String PLUS_SIGN = "+";
    static final String MINUS_SIGN = "-";

    public OracleResultSetAdaptor(ResultSet rs, AdaptorFactory factory) {
        super(rs, factory);
    }

    @AdaptorMethodOverride
    public String getExtendedData(int type, int column) throws SQLException {
        if (type != -1001) {
            return super.getExtendedData(type, column);
        }
        String value = this.getResultSet().getString(column);
        if (value == null) {
            return value;
        }
        String[] stringParts = value.split(TIMESTAMP_TZ_SPLITTER);
        if (stringParts.length < 7) {
            int offset = TimeZone.getTimeZone(stringParts[stringParts.length - 1]).getRawOffset() / 1000;
            String[] tzOffset = new String[]{String.format("%03d", offset / 3600), String.format("%02d", offset % 3600 / 60)};
            String[] strParts = new String[7];
            System.arraycopy(stringParts, 0, strParts, 0, stringParts.length - 1);
            System.arraycopy(tzOffset, 0, strParts, stringParts.length - 1, tzOffset.length);
            value = String.format(TIMESTAMP_TZ_FORMATER, strParts);
        } else {
            if (stringParts[6].contains(MINUS_SIGN) || stringParts[6].contains(PLUS_SIGN)) {
                while (stringParts[6].startsWith("0") || stringParts[6].startsWith(PLUS_SIGN) || stringParts[6].startsWith(MINUS_SIGN) || stringParts[6].startsWith(" ")) {
                    stringParts[6] = stringParts[6].substring(1);
                }
            }
            if (!stringParts[5].contains(MINUS_SIGN) && !stringParts[5].contains(PLUS_SIGN)) {
                StringBuilder buffer = new StringBuilder();
                buffer.append(PLUS_SIGN);
                buffer.append(stringParts[5]);
                stringParts[5] = buffer.toString();
            }
            value = String.format(TIMESTAMP_TZ_FORMATER, stringParts);
        }
        return value;
    }

    private ResultSet getResultSet() {
        return this.rs;
    }

    public static class Wrapper
    implements IWrapper {
        public AbstractAdaptor wrap(Object toWrap, AdaptorFactory factory) {
            return new OracleResultSetAdaptor((ResultSet)toWrap, factory);
        }
    }
}

