/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.security.nodel;

import com.ibm.neo.persist.ESortOrder;
import com.ibm.neo.persist.IDocumentDatabase;
import com.ibm.neo.persist.PersistenceException;
import com.ibm.neo.persist.PersistenceService;
import com.ibm.neo.persist.nobject.NobjectCollection;
import com.ibm.neo.security.nodel.Account;
import com.ibm.neo.security.nodel.Capability;
import com.ibm.neo.security.nodel.Group;
import com.ibm.neo.security.nodel.Role;
import com.ibm.neo.security.nodel.Tenant;
import com.ibm.neo.security.nodel.User;

public class ACSPersistence {
    public static final String ACCESS_CONTROL_DB = "access-control";
    private static final String ACCOUNTS_COL = "accounts";
    private static final String TENANTS_COL = "tenants";
    public static final String USERS_COL = "users";
    private static final String GROUPS_COL = "groups";
    public static final String CAPABILITIES_COL = "capabilities";
    public static final String ROLES_COL = "roles";
    public static final String ACCESS_VERSION_COL = "access-version";

    public static NobjectCollection<Account> getAccountsCollection(PersistenceService ps) throws PersistenceException {
        IDocumentDatabase db = ps.getDatabase(ACCESS_CONTROL_DB);
        NobjectCollection accountCol = db.getNobjectCollection(ACCOUNTS_COL, Account.class);
        accountCol.getDocumentCollection().ensureSortedIndex(new String[]{"name"}, new ESortOrder[]{ESortOrder.ASCENDING}, true, false);
        return accountCol;
    }

    public static NobjectCollection<Account> getAccountsCollection() throws PersistenceException {
        return ACSPersistence.getAccountsCollection(PersistenceService.getInstance());
    }

    public static NobjectCollection<Tenant> getTenantsCollection(PersistenceService ps) throws PersistenceException {
        IDocumentDatabase db = ps.getDatabase(ACCESS_CONTROL_DB);
        NobjectCollection tenantCol = db.getNobjectCollection(TENANTS_COL, Tenant.class);
        tenantCol.getDocumentCollection().ensureSortedIndex(new String[]{"account-id", "name"}, new ESortOrder[]{ESortOrder.ASCENDING, ESortOrder.ASCENDING}, true, false);
        return tenantCol;
    }

    public static NobjectCollection<Tenant> getTenantsCollection() throws PersistenceException {
        return ACSPersistence.getTenantsCollection(PersistenceService.getInstance());
    }

    public static NobjectCollection<User> getUsersCollection(PersistenceService ps) throws PersistenceException {
        IDocumentDatabase db = ps.getDatabase(ACCESS_CONTROL_DB);
        NobjectCollection userCol = db.getNobjectCollection(USERS_COL, User.class);
        userCol.getDocumentCollection().ensureSortedIndex(new String[]{"tenant-id"}, new ESortOrder[]{ESortOrder.ASCENDING}, false, false);
        userCol.getDocumentCollection().ensureSortedIndex(new String[]{"external-user-id"}, new ESortOrder[]{ESortOrder.ASCENDING}, true, false);
        return userCol;
    }

    public static NobjectCollection<User> getUsersCollection() throws PersistenceException {
        return ACSPersistence.getUsersCollection(PersistenceService.getInstance());
    }

    public static NobjectCollection<Group> getGroupsCollection(PersistenceService ps) throws PersistenceException {
        IDocumentDatabase db = ps.getDatabase(ACCESS_CONTROL_DB);
        NobjectCollection groupCol = db.getNobjectCollection(GROUPS_COL, Group.class);
        groupCol.getDocumentCollection().ensureSortedIndex(new String[]{"tenant-id", "name"}, new ESortOrder[]{ESortOrder.ASCENDING, ESortOrder.ASCENDING}, true, false);
        groupCol.getDocumentCollection().ensureSortedIndex(new String[]{"members"}, new ESortOrder[]{ESortOrder.ASCENDING}, false, false);
        return groupCol;
    }

    public static NobjectCollection<Group> getGroupsCollection() throws PersistenceException {
        return ACSPersistence.getGroupsCollection(PersistenceService.getInstance());
    }

    public static NobjectCollection<Capability> getCapabilitiesCollection(PersistenceService ps) throws PersistenceException {
        IDocumentDatabase db = ps.getDatabase(ACCESS_CONTROL_DB);
        NobjectCollection capabilityCol = db.getNobjectCollection(CAPABILITIES_COL, Capability.class);
        capabilityCol.getDocumentCollection().ensureSortedIndex(new String[]{"name", "type"}, new ESortOrder[]{ESortOrder.ASCENDING, ESortOrder.ASCENDING}, true, false);
        return capabilityCol;
    }

    public static NobjectCollection<Capability> getCapabilitiesCollection() throws PersistenceException {
        return ACSPersistence.getCapabilitiesCollection(PersistenceService.getInstance());
    }

    public static NobjectCollection<Role> getRolesCollection(PersistenceService ps) throws PersistenceException {
        IDocumentDatabase db = ps.getDatabase(ACCESS_CONTROL_DB);
        NobjectCollection roleCol = db.getNobjectCollection(ROLES_COL, Role.class);
        roleCol.getDocumentCollection().ensureSortedIndex(new String[]{"tenant-id", "name"}, new ESortOrder[]{ESortOrder.ASCENDING, ESortOrder.ASCENDING}, true, false);
        return roleCol;
    }

    public static NobjectCollection<Role> getRolesCollection() throws PersistenceException {
        return ACSPersistence.getRolesCollection(PersistenceService.getInstance());
    }
}

