/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.security.nodel;

import com.ibm.neo.persist.ETenantContentModel;
import com.ibm.neo.persist.ion.IONObject;
import com.ibm.neo.persist.ion.IONObjectId;
import com.ibm.neo.persist.nobject.Nobject;
import java.util.Date;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class Tenant
extends Nobject {
    public static final String KEY_NAME = "name";
    public static final String KEY_ACCOUNT_ID = "account-id";
    public static final String KEY_CREATION_DATE = "creation-date";
    public static final String KEY_CONTENT_VERSION = "content-version";
    public static final String KEY_LAST_CONTENT_VERSION = "last-content-version";
    public static final String KEY_CONTENT_MODEL = "content-model";
    public static final String KEY_ALLOW_UPGRADES = "allow-upgrades";
    public static final String KEY_TERMS_OF_USE_ACCEPTOR = "terms-of-use-acceptor";
    public static final String KEY_TERMS_OF_USE_DATE = "terms-of-use-date-accepted";
    public static final String KEY_TERMS_OF_USE_VERSION = "terms-of-use-version-accepted";
    public static final String KEY_DATABASE_POOL = "database-pool";
    public static final String EXT_KEY_DISK_SPACE_QUOTA = "DiskSpaceQuota";
    public static final String EXT_KEY_DISK_SPACE_WARNING_QUOTA = "DiskSpaceWarningQuota";
    public static final String EXT_KEY_MAX_FILE_UPLOAD_SIZE = "MaxFileUploadSize";
    public static final String EXT_KEY_MAX_DATASOURCE_FIELDS_NO = "MaxDatasourceFieldsNo";
    public static final String EXT_KEY_MAX_DATASOURCE_RECS_NO = "MaxDatasourceRecsNo";
    public static final String EXT_KEY_MAX_NUMBER_OF_SEATS = "MaxNumberOfSeats";
    public static final String EXT_KEY_SMA_LEVEL = "SmaLevel";
    private String mName;
    private IONObjectId mAccountId;
    private Date mCreationDate;
    private Integer mContentVersion;
    private Integer mLastContentVersion;
    private ETenantContentModel mContentModel;
    private boolean mAllowUpgrades;
    private String mTermsOfUseAcceptor;
    private Date mTermsOfUseDateAccepted;
    private String mTermsOfUseVersionAccepted;
    private String mDatabasePool;

    public Tenant() {
        this.mAllowUpgrades = true;
        this.mContentModel = ETenantContentModel.SHARED;
    }

    public Tenant(Tenant tenant) {
        super((Nobject)tenant);
        this.mAccountId = tenant.mAccountId;
        this.mAllowUpgrades = tenant.mAllowUpgrades;
        this.mContentModel = tenant.mContentModel;
        this.mContentVersion = tenant.mContentVersion;
        this.mLastContentVersion = tenant.mLastContentVersion;
        this.mCreationDate = tenant.mCreationDate;
        this.mName = tenant.mName;
        this.mTermsOfUseAcceptor = tenant.mTermsOfUseAcceptor;
        this.mTermsOfUseDateAccepted = tenant.mTermsOfUseDateAccepted;
        this.mTermsOfUseVersionAccepted = tenant.mTermsOfUseVersionAccepted;
        this.mDatabasePool = tenant.mDatabasePool;
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public IONObjectId getAccountId() {
        return this.mAccountId;
    }

    public void setAccountId(IONObjectId accountId) {
        this.mAccountId = accountId;
    }

    public Date getCreationDate() {
        return this.mCreationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.mCreationDate = creationDate;
    }

    public Integer getContentVersion() {
        return this.mContentVersion;
    }

    public void setContentVersion(Integer contentVersion) {
        this.mContentVersion = contentVersion;
    }

    public void setLastContentVersion(Integer contentVersion) {
        this.mLastContentVersion = contentVersion;
    }

    public Integer getLastContentVersion() {
        return this.mLastContentVersion;
    }

    public ETenantContentModel getContentModel() {
        return this.mContentModel;
    }

    public void setContentModel(ETenantContentModel contentModel) {
        this.mContentModel = contentModel;
    }

    public boolean getAllowUpgrades() {
        return this.mAllowUpgrades;
    }

    public void setAllowUpgrades(boolean allowUpgrades) {
        this.mAllowUpgrades = allowUpgrades;
    }

    public String getTermsOfUserAcceptor() {
        return this.mTermsOfUseAcceptor;
    }

    public void setTermsOfUserAcceptor(String termsOfUseAcceptor) {
        this.mTermsOfUseAcceptor = termsOfUseAcceptor;
    }

    public Date getTermsOfUserDateAccepted() {
        return this.mTermsOfUseDateAccepted;
    }

    public void setTermsOfUserDateAccepted(Date termsOfUseDateAccepted) {
        this.mTermsOfUseDateAccepted = termsOfUseDateAccepted;
    }

    public String getTermsOfUserVersionAccepted() {
        return this.mTermsOfUseVersionAccepted;
    }

    public void setTermsOfUserVersionAccepted(String termsOfUseVersionAccepted) {
        this.mTermsOfUseVersionAccepted = termsOfUseVersionAccepted;
    }

    public String getDatabasePool() {
        return this.mDatabasePool;
    }

    public void setDatabasePool(String databasePool) {
        this.mDatabasePool = databasePool;
    }

    public void encodeION(IONObject ionObj) {
        super.encodeION(ionObj);
        ionObj.put((Object)KEY_NAME, (Object)this.mName);
        ionObj.put((Object)KEY_ACCOUNT_ID, (Object)this.mAccountId);
        ionObj.put((Object)KEY_CREATION_DATE, (Object)this.mCreationDate);
        if (this.mContentVersion != null) {
            ionObj.put((Object)KEY_CONTENT_VERSION, (Object)this.mContentVersion);
        }
        if (this.mLastContentVersion != null) {
            ionObj.put((Object)KEY_LAST_CONTENT_VERSION, (Object)this.mLastContentVersion);
        }
        ionObj.setEnum(KEY_CONTENT_MODEL, (Enum)this.mContentModel);
        ionObj.put((Object)KEY_ALLOW_UPGRADES, (Object)this.mAllowUpgrades);
        ionObj.put((Object)KEY_TERMS_OF_USE_ACCEPTOR, (Object)this.mTermsOfUseAcceptor);
        ionObj.put((Object)KEY_TERMS_OF_USE_DATE, (Object)this.mTermsOfUseDateAccepted);
        ionObj.put((Object)KEY_TERMS_OF_USE_VERSION, (Object)this.mTermsOfUseVersionAccepted);
        ionObj.put((Object)KEY_DATABASE_POOL, (Object)this.mDatabasePool);
    }

    public void decodeION(IONObject ionObj) {
        super.decodeION(ionObj);
        this.mName = ionObj.getString(KEY_NAME);
        this.mAccountId = ionObj.getIONObjectId(KEY_ACCOUNT_ID);
        this.mCreationDate = ionObj.getDate(KEY_CREATION_DATE);
        this.mContentVersion = ionObj.getInt(KEY_CONTENT_VERSION, 0);
        Number lastVersion = ionObj.getNumber(KEY_LAST_CONTENT_VERSION);
        if (lastVersion != null) {
            this.mLastContentVersion = lastVersion.intValue();
        }
        this.mContentModel = (ETenantContentModel)ionObj.getEnum(KEY_CONTENT_MODEL, ETenantContentModel.class, (Enum)ETenantContentModel.PRIVATE);
        this.mAllowUpgrades = ionObj.getBoolean(KEY_ALLOW_UPGRADES, true);
        this.mTermsOfUseAcceptor = ionObj.getString(KEY_TERMS_OF_USE_ACCEPTOR);
        this.mTermsOfUseDateAccepted = ionObj.getDate(KEY_TERMS_OF_USE_DATE);
        this.mTermsOfUseVersionAccepted = ionObj.getString(KEY_TERMS_OF_USE_VERSION);
        this.mDatabasePool = ionObj.getString(KEY_DATABASE_POOL);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Tenant)) {
            return false;
        }
        Tenant other = (Tenant)((Object)o);
        return new EqualsBuilder().appendSuper(super.equals((Object)other)).append((Object)this.mName, (Object)other.mName).append((Object)this.mAccountId, (Object)other.mAccountId).append((Object)this.mCreationDate, (Object)other.mCreationDate).append((Object)this.mContentVersion, (Object)other.mContentVersion).append((Object)this.mLastContentVersion, (Object)other.mLastContentVersion).append((Object)this.mContentModel, (Object)other.mContentModel).append(this.mAllowUpgrades, other.mAllowUpgrades).append((Object)this.mTermsOfUseAcceptor, (Object)other.mTermsOfUseAcceptor).append((Object)this.mTermsOfUseDateAccepted, (Object)other.mTermsOfUseDateAccepted).append((Object)this.mTermsOfUseVersionAccepted, (Object)other.mTermsOfUseVersionAccepted).append((Object)this.mDatabasePool, (Object)other.mDatabasePool).isEquals();
    }

    public boolean matches(Tenant other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        return new EqualsBuilder().append((Object)this.getId(), (Object)other.getId()).append((Object)this.mName, (Object)other.mName).append((Object)this.mAccountId, (Object)other.mAccountId).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.mName).append((Object)this.mAccountId).append((Object)this.mCreationDate).append((Object)this.mContentVersion).append((Object)this.mLastContentVersion).append((Object)this.mContentModel).append(this.mAllowUpgrades).append((Object)this.mTermsOfUseAcceptor).append((Object)this.mTermsOfUseDateAccepted).append((Object)this.mTermsOfUseVersionAccepted).append((Object)this.mDatabasePool).toHashCode();
    }
}

