/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.security.nodel;

import com.ibm.neo.persist.ion.IONArray;
import com.ibm.neo.persist.ion.IONHelper;
import com.ibm.neo.persist.ion.IONObject;
import com.ibm.neo.security.nodel.UserOrGroup;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class User
extends UserOrGroup {
    public static final String KEY_EXTERNAL_USER_ID = "external-user-id";
    public static final String KEY_FULL_NAME = "full-name";
    public static final String KEY_EMAIL = "email";
    public static final String KEY_REGISTERED_DATE = "registered-date";
    public static final String KEY_LAST_LOGON_DATES = "last-logon-dates";
    public static final String KEY_LAST_LOGON_DATE = "last-logon-date";
    public static final int KEY_EXTERNAL_USER_ID_INDEX = 0;
    public static final int KEY_FULL_NAME_INDEX = 1;
    public static final int KEY_EMAIL_INDEX = 2;
    public static final int KEY_REGISTERED_DATE_INDEX = 3;
    public static final int KEY_LAST_LOGON_DATES_INDEX = 4;
    private boolean[] m_setFields = new boolean[5];
    private String m_externalUserId;
    private String m_fullName;
    private String m_email;
    private Date m_registeredDate;
    private Collection<Date> m_lastLogonDates = new ArrayList<Date>();

    public User() {
        Arrays.fill(this.m_setFields, true);
    }

    public User(User user) {
        super(user);
        this.m_email = user.m_email;
        this.m_externalUserId = user.m_externalUserId;
        this.m_fullName = user.m_fullName;
        this.m_lastLogonDates = user.m_lastLogonDates;
        this.m_registeredDate = user.m_registeredDate;
        this.m_setFields = user.m_setFields;
    }

    public User(boolean _trackSetFields) {
        super(_trackSetFields);
        Arrays.fill(this.m_setFields, !_trackSetFields);
    }

    public String getExternalUserId() {
        return this.m_externalUserId;
    }

    public void setExternalUserId(String _externalUserId) {
        this.m_externalUserId = _externalUserId;
        this.m_setFields[0] = true;
    }

    public String getFullName() {
        return this.m_fullName;
    }

    public void setFullName(String _fullName) {
        this.m_fullName = _fullName;
        this.m_setFields[1] = true;
    }

    public String getEmail() {
        return this.m_email;
    }

    public void setEmail(String _email) {
        this.m_email = _email;
        this.m_setFields[2] = true;
    }

    public Date getRegisteredDate() {
        return this.m_registeredDate;
    }

    public void setRegisteredDate(Date _registeredDate) {
        this.m_registeredDate = _registeredDate;
        this.m_setFields[3] = true;
    }

    public Date getCurrentLogonDate() {
        return this.m_lastLogonDates != null && this.m_lastLogonDates.size() > 0 ? this.m_lastLogonDates.toArray(new Date[0])[0] : null;
    }

    public Date getLastLogonDate() {
        return this.m_lastLogonDates != null && this.m_lastLogonDates.size() > 1 ? this.m_lastLogonDates.toArray(new Date[0])[1] : null;
    }

    @Override
    public void encodeION(IONObject ionObj) {
        super.encodeION(ionObj);
        if (this.m_setFields[0]) {
            ionObj.put((Object)KEY_EXTERNAL_USER_ID, (Object)this.m_externalUserId);
        }
        if (this.m_setFields[1]) {
            ionObj.put((Object)KEY_FULL_NAME, (Object)this.m_fullName);
        }
        if (this.m_setFields[2]) {
            ionObj.put((Object)KEY_EMAIL, (Object)this.m_email);
        }
        if (this.m_setFields[3]) {
            ionObj.put((Object)KEY_REGISTERED_DATE, (Object)this.m_registeredDate);
        }
        if (this.m_setFields[4]) {
            ionObj.put((Object)KEY_LAST_LOGON_DATES, IONHelper.toION(this.m_lastLogonDates));
        }
    }

    @Override
    public void decodeION(IONObject ionObj) {
        super.decodeION(ionObj);
        this.m_externalUserId = ionObj.getString(KEY_EXTERNAL_USER_ID);
        this.m_fullName = ionObj.getString(KEY_FULL_NAME);
        this.m_email = ionObj.getString(KEY_EMAIL);
        this.m_registeredDate = ionObj.getDate(KEY_REGISTERED_DATE);
        IONHelper.toCollection((IONArray)ionObj.getIONArray(KEY_LAST_LOGON_DATES), this.m_lastLogonDates, Date.class);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof User)) {
            return false;
        }
        User other = (User)((Object)o);
        return new EqualsBuilder().appendSuper(super.equals((Object)other)).append((Object)this.m_externalUserId, (Object)other.m_externalUserId).append((Object)this.m_fullName, (Object)other.m_fullName).append((Object)this.m_email, (Object)other.m_email).append((Object)this.m_registeredDate, (Object)other.m_registeredDate).append(this.m_lastLogonDates, other.m_lastLogonDates).isEquals();
    }

    public boolean matches(User other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        return new EqualsBuilder().append((Object)this.getId(), (Object)other.getId()).append((Object)this.m_externalUserId, (Object)other.m_externalUserId).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.m_externalUserId).append((Object)this.m_fullName).append((Object)this.m_email).append((Object)this.m_registeredDate).append(this.m_lastLogonDates).toHashCode();
    }
}

