/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.commons.crypto.internal.utils;

import com.ibm.bi.platform.commons.crypto.CAMCryptoException;
import com.ibm.bi.platform.commons.crypto.internal.keystore.CAMCskKs;
import com.ibm.bi.platform.commons.crypto.internal.utils.JcaFactory;
import java.security.InvalidKeyException;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.SecretKey;

public class MacWithCskPool {
    private static MacWithCskPool instance;
    private Map<String, Mac> macPool = new HashMap<String, Mac>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MacWithCskPool getInstance() {
        if (instance != null) return instance;
        Class<MacWithCskPool> clazz = MacWithCskPool.class;
        synchronized (MacWithCskPool.class) {
            if (instance != null) return instance;
            instance = new MacWithCskPool();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private MacWithCskPool() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mac getMacGivenCSKDigest(byte[] cskDigest, String hmacAlg) throws JcaFactory.CouldNotGetInstanceException, CAMCryptoException, InvalidKeyException {
        Mac mac = null;
        String digestStr = new String(cskDigest) + hmacAlg;
        Map<String, Mac> map = this.macPool;
        synchronized (map) {
            mac = this.macPool.get(digestStr);
            if (mac == null) {
                mac = JcaFactory.getInstance(Mac.class, hmacAlg);
                SecretKey csk = CAMCskKs.getInstance().getCSK(cskDigest);
                mac.init(csk);
                this.macPool.put(digestStr, mac);
            }
        }
        return mac;
    }
}

