/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.soap.services;

import com.ibm.bi.soap.schema.Method;
import com.ibm.bi.soap.schema.Schema;
import com.ibm.bi.soap.schema.Type;
import com.ibm.bi.soap.schema.TypeLibrary;
import com.ibm.bi.soap.services.BibusSoapAction;
import com.ibm.bi.soap.xml.DefaultNamespace;
import com.ibm.bi.soap.xml.XmlStreamUtils;
import java.io.InputStream;
import java.util.HashMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class ServiceLoader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, Method> load(TypeLibrary typeLib, InputStream is) throws XMLStreamException {
        XMLStreamReader reader = XmlStreamUtils.getInputFactory().createXMLStreamReader(is, "utf-8");
        try {
            HashMap<String, Method> hashMap = this.load(typeLib, reader);
            return hashMap;
        }
        finally {
            XmlStreamUtils.closeReader(reader);
        }
    }

    private HashMap<String, Method> load(TypeLibrary typeLib, XMLStreamReader reader) throws XMLStreamException {
        HashMap<String, Method> methods = new HashMap<String, Method>();
        reader.nextTag();
        while (reader.nextTag() != 2) {
            String name = reader.getAttributeValue(null, "name");
            String prefix = reader.getAttributeValue(null, "namespace");
            DefaultNamespace ns = new DefaultNamespace(reader.getNamespaceURI(prefix), prefix);
            String saction = reader.getAttributeValue(null, "soapAction");
            BibusSoapAction action = new BibusSoapAction(saction);
            action.setVersion(typeLib.getVersion());
            Method m = new Method(name, ns, action.toString());
            methods.put(name, m);
            while (reader.nextTag() != 2) {
                String tag = reader.getLocalName();
                if (tag.equals("param")) {
                    this.parseParam(typeLib, reader, m);
                    continue;
                }
                if (!tag.equals("returns")) continue;
                this.parseReturn(typeLib, reader, m);
            }
        }
        return methods;
    }

    private void parseParam(TypeLibrary typeLib, XMLStreamReader reader, Method m) throws XMLStreamException {
        String name = reader.getAttributeValue(null, "name");
        Type t = this.parseType(typeLib, reader);
        boolean required = "true".equals(reader.getAttributeValue(null, "required"));
        m.addParameter(name, t, required);
        if (reader.nextTag() != 2) {
            throw new XMLStreamException("END_ELEMENT expected");
        }
    }

    private void parseReturn(TypeLibrary typeLib, XMLStreamReader reader, Method m) throws XMLStreamException {
        Type t = this.parseType(typeLib, reader);
        m.setReturnType(t);
        if (reader.nextTag() != 2) {
            throw new XMLStreamException("END_ELEMENT expected");
        }
    }

    private Type parseType(TypeLibrary typeLib, XMLStreamReader reader) {
        String[] type = reader.getAttributeValue(null, "type").split(":");
        String uri = reader.getNamespaceURI(type[0]);
        Schema sch = typeLib.getSchemaByNamespace(uri);
        return sch.getType(type[1]);
    }
}

