/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.metadata.util;

import com.ibm.bi.platform.moser.common.generated.metadata.FolderItemType;
import com.ibm.bi.platform.moser.common.generated.metadata.FolderType;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.ObjectType;
import com.ibm.bi.platform.moser.common.generated.metadata.PropertyType;
import com.ibm.bi.platform.moser.common.utils.MoserObjectUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CommonResolverUtil {
    private CommonResolverUtil() {
    }

    public static FolderType getFMPlaceHolderInMDTV(Module m, String moduleAlias) {
        if (m == null) {
            return null;
        }
        return CommonResolverUtil.getPlaceHolder(m.basicGetMetadataTreeView(), moduleAlias);
    }

    protected static FolderType getPlaceHolder(List<FolderType> lst, String moduleAlias) {
        if (lst == null || lst.isEmpty()) {
            return null;
        }
        ArrayList<FolderType> subList = new ArrayList<FolderType>();
        for (FolderType f : lst) {
            if (moduleAlias.equals(f.getIdentifier()) || f.getIdentifier() == null && f.basicGetPropertyOverride() != null && f.basicGetPropertyOverride().contains(moduleAlias)) {
                return f;
            }
            List fItems = MoserObjectUtils.getList((List)f.basicGetFolderItem());
            for (FolderItemType itm : fItems) {
                FolderType c = itm.getFolder();
                if (c == null) continue;
                subList.add(c);
            }
        }
        return CommonResolverUtil.getPlaceHolder(subList, moduleAlias);
    }

    public static PropertyType setProperty(ObjectType object, String name, String value) {
        PropertyType previous = CommonResolverUtil.removeProperty(object, name);
        PropertyType property = new PropertyType();
        property.setName(name);
        property.setValue(value);
        object.addProperty(property);
        return previous;
    }

    public static PropertyType removeProperty(ObjectType object, String name) {
        List props = MoserObjectUtils.getList((List)object.basicGetProperty());
        Iterator iter = props.iterator();
        while (iter.hasNext()) {
            PropertyType p = (PropertyType)iter.next();
            if (!p.getName().equals(name)) continue;
            iter.remove();
            return p;
        }
        return null;
    }

    public static String getProperty(ObjectType object, String name) {
        List props = MoserObjectUtils.getList((List)object.basicGetProperty());
        for (PropertyType p : props) {
            if (!p.getName().equals(name)) continue;
            return p.getValue();
        }
        return null;
    }
}

