/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.module.util;

import com.ibm.bi.platform.moser.common.generated.metadata.BaseQueryItemType;
import com.ibm.bi.platform.moser.common.generated.metadata.CalculatedMemberType;
import com.ibm.bi.platform.moser.common.generated.metadata.Calculation;
import com.ibm.bi.platform.moser.common.generated.metadata.Filter;
import com.ibm.bi.platform.moser.common.generated.metadata.FolderItemType;
import com.ibm.bi.platform.moser.common.generated.metadata.FolderType;
import com.ibm.bi.platform.moser.common.generated.metadata.InstanceType;
import com.ibm.bi.platform.moser.common.generated.metadata.ItemHierarchy;
import com.ibm.bi.platform.moser.common.generated.metadata.ItemType;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.NamedSet;
import com.ibm.bi.platform.moser.common.generated.metadata.ObjectType;
import com.ibm.bi.platform.moser.common.generated.metadata.PropertyType;
import com.ibm.bi.platform.moser.common.generated.metadata.QueryItem;
import com.ibm.bi.platform.moser.common.generated.metadata.QuerySubject;
import com.ibm.bi.platform.moser.common.generated.metadata.Relationship;
import com.ibm.bi.platform.moser.common.generated.metadata.SplitType;
import com.ibm.bi.platform.moser.common.generated.metadata.UseSpecType;
import com.ibm.bi.platform.moser.common.utils.MoserObjectUtils;
import com.ibm.bi.platform.moser.common.utils.ReferenceResolver;
import com.ibm.bi.platform.moser.core.metadata.util.CommonResolverUtil;
import java.util.ArrayList;
import java.util.List;

public class DataModuleExtractor {
    private DataModuleExtractor() {
    }

    private static void removeSplitDefinitionMetadata(QueryItem parentQI, List<SplitType> splitDefinition) {
        if (splitDefinition == null) {
            return;
        }
        for (SplitType split : splitDefinition) {
            DataModuleExtractor.removeSplitDefinitionMetadata(parentQI, split);
        }
    }

    private static void removeSplitDefinitionMetadata(QueryItem parentQI, SplitType split) {
        if (InstanceType.REFERENCE.equals((Object)split.getInstanceType())) {
            List items = parentQI.basicGetItem();
            DataModuleExtractor.clearList(items);
        }
        List splitItems = MoserObjectUtils.getList((List)split.basicGetItem());
        for (ItemType item : splitItems) {
            QueryItem qi = item.getQueryItem();
            if (qi == null) continue;
            if (InstanceType.MISSING.equals((Object)qi.getInstanceType())) {
                qi.setInstanceType(InstanceType.REFERENCE);
                continue;
            }
            DataModuleExtractor.removeUnoverridenQueryItemProperties(qi, false);
            DataModuleExtractor.removeGeneratedQueryItemProperties(qi);
            qi.setFacetDefinition(null);
            qi.setSourceCategory(null);
        }
    }

    private static Module.UseSpec getReferencedModuleUseSpec(String qsRef, List<Module.UseSpec> useSpecList) {
        if (useSpecList == null) {
            return null;
        }
        String referencedModuleAlias = ReferenceResolver.getFirstPart((String)qsRef);
        for (Module.UseSpec useSpec : useSpecList) {
            if (!useSpec.getIdentifier().equals(referencedModuleAlias)) continue;
            return useSpec;
        }
        return null;
    }

    private static void removeUnoverridenQuerySubjectFilters(QuerySubject qs) {
        List filters = MoserObjectUtils.getList((List)qs.basicGetFilter());
        for (int i = filters.size() - 1; i >= 0; --i) {
            Filter filter = (Filter)filters.get(i);
            List propertyOverride = filter.basicGetPropertyOverride();
            if (propertyOverride == null || !propertyOverride.contains("NEW")) {
                filters.remove(i);
            }
            List propOverrides = filter.basicGetPropertyOverride();
            DataModuleExtractor.clearList(propOverrides);
        }
    }

    private static void removeUnoverridenObjectTypeProperties(ObjectType obj) {
        List propertyOverride = obj.basicGetPropertyOverride();
        if (propertyOverride == null || !propertyOverride.contains("label")) {
            obj.setLabel(null);
        }
        if (propertyOverride == null || !propertyOverride.contains("comment")) {
            obj.setComment(null);
        }
        if (propertyOverride == null || !propertyOverride.contains("description")) {
            obj.setDescription(null);
        }
        if (propertyOverride == null || !propertyOverride.contains("screenTip")) {
            obj.setScreenTip(null);
        }
        if (propertyOverride == null || !propertyOverride.contains("hidden")) {
            obj.setHidden(null);
        }
        DataModuleExtractor.removeUnoverridenProperty(obj.basicGetProperty(), obj.basicGetPropertyOverride());
    }

    public static boolean propertyOverrideContains(List<String> propertyOverride, String propName) {
        return propertyOverride != null && propertyOverride.contains(propName);
    }

    private static void removeUnoverridenQueryItemProperties(QueryItem queryItem, boolean keepPropOverride) {
        List propertyOverride = queryItem.basicGetPropertyOverride();
        if (propertyOverride != null && propertyOverride.contains("NEW")) {
            DataModuleExtractor.removeSplitDefinitionMetadata(queryItem, queryItem.basicGetSplitDefinition());
        } else {
            DataModuleExtractor.removeUnoverridenBaseQueryItemTypeProperties((BaseQueryItemType)queryItem);
            DataModuleExtractor.clearList(queryItem.basicGetConcepts());
            queryItem.setMinimumValue(null);
            queryItem.setMaximumValue(null);
            queryItem.setNumberOfDistinctValues(null);
            queryItem.setNumberOfNullValues(null);
            DataModuleExtractor.removeUnoverridenCalculatedMember(queryItem.basicGetCalculatedMember());
        }
        DataModuleExtractor.removeUnoverridenPropertyOverride((ObjectType)queryItem, keepPropOverride);
    }

    private static void removeUnoverridenCalculationProperties(Calculation calc, boolean keepPropOverride) {
        DataModuleExtractor.removeUnoverridenBaseQueryItemTypeProperties((BaseQueryItemType)calc);
        DataModuleExtractor.removeUnoverridenPropertyOverride((ObjectType)calc, keepPropOverride);
    }

    private static void removeUnoverridenBaseQueryItemTypeProperties(BaseQueryItemType baseQueryItemType) {
        List propertyOverride = baseQueryItemType.basicGetPropertyOverride();
        if (propertyOverride == null || !propertyOverride.contains("NEW")) {
            DataModuleExtractor.removeUnoverridenObjectTypeProperties((ObjectType)baseQueryItemType);
            if (propertyOverride == null || !propertyOverride.contains("usage")) {
                baseQueryItemType.setUsage(null);
            }
            if (propertyOverride == null || !propertyOverride.contains("regularAggregate")) {
                baseQueryItemType.setRegularAggregate(null);
            }
            if (propertyOverride == null || !propertyOverride.contains("facetDefinition")) {
                baseQueryItemType.setFacetDefinition(null);
            }
            if (propertyOverride == null || !propertyOverride.contains("format")) {
                baseQueryItemType.setFormat(null);
            }
            if (!DataModuleExtractor.propertyOverrideContains(propertyOverride, "taxonomy")) {
                DataModuleExtractor.clearList(baseQueryItemType.basicGetTaxonomy());
            }
            baseQueryItemType.setDatatype(null);
            baseQueryItemType.setNullable(null);
            baseQueryItemType.setExpression(null);
            DataModuleExtractor.clearList(baseQueryItemType.basicGetSplitDefinition());
        }
    }

    private static void removeUnoverridenFilterProperties(Filter flt, boolean keepPropOverride) {
        List propertyOverride = flt.basicGetPropertyOverride();
        if (propertyOverride == null || !propertyOverride.contains("NEW")) {
            DataModuleExtractor.removeUnoverridenObjectTypeProperties((ObjectType)flt);
            flt.setExpression(null);
            flt.setPostAutoAggregation(null);
        }
        DataModuleExtractor.removeUnoverridenPropertyOverride((ObjectType)flt, keepPropOverride);
    }

    private static void removeUnoverridenFolderProperties(ItemType.Folder folder, boolean keepPropOverride) {
        List propertyOverride = folder.basicGetPropertyOverride();
        if (propertyOverride == null || !propertyOverride.contains("NEW")) {
            DataModuleExtractor.removeUnoverridenObjectTypeProperties((ObjectType)folder);
        }
        DataModuleExtractor.removeUnoverridenPropertyOverride((ObjectType)folder, keepPropOverride);
    }

    private static void removeUnoverridenNamedSetProperties(NamedSet ns, boolean keepPropOverride) {
        DataModuleExtractor.removeUnoverridenBaseQueryItemTypeProperties((BaseQueryItemType)ns);
        DataModuleExtractor.removeUnoverridenPropertyOverride((ObjectType)ns, keepPropOverride);
    }

    private static void removeUnoverridenPropertyOverride(ObjectType obj, boolean keepPropOverride) {
        List propertyOverride = obj.basicGetPropertyOverride();
        if (propertyOverride == null) {
            return;
        }
        if (!keepPropOverride) {
            propertyOverride.clear();
        } else {
            ArrayList ls = new ArrayList();
            ls.addAll(propertyOverride);
            propertyOverride.clear();
            for (String s : ls) {
                if (propertyOverride.contains(s)) continue;
                propertyOverride.add(s);
            }
        }
    }

    private static void removeGeneratedCalculationProperties(Calculation calc) {
        calc.setIdForExpression(null);
    }

    private static void removeGeneratedItemHierarchyProperties(ItemHierarchy ih) {
        ih.setIdForExpression(null);
    }

    private static void removeGeneratedFilterProperties(Filter flt) {
        flt.setIdForExpression(null);
    }

    private static void removeGeneratedNamedSetProperties(NamedSet ns) {
        ns.setIdForExpression(null);
    }

    private static void removeGeneratedQueryItemProperties(QueryItem qi) {
        qi.setIdForExpression(null);
        qi.setHighlevelDatatype(null);
        qi.setDatatypeCategory(null);
    }

    private static void removeUnoverridenCalculatedMember(List<CalculatedMemberType> cmList) {
        if (cmList == null) {
            return;
        }
        for (CalculatedMemberType calMember : cmList) {
            List propertyOverride = calMember.basicGetPropertyOverride();
            if (propertyOverride == null || !propertyOverride.contains("NEW")) {
                DataModuleExtractor.removeUnoverridenObjectTypeProperties((ObjectType)calMember);
            }
            DataModuleExtractor.clearList(propertyOverride);
        }
    }

    private static void removeUnoverridenItemHierarchyProperties(ItemHierarchy ih, boolean keepPropOverride) {
        List propertyOverride = ih.basicGetPropertyOverride();
        if (propertyOverride == null || !propertyOverride.contains("NEW")) {
            DataModuleExtractor.removeUnoverridenObjectTypeProperties((ObjectType)ih);
            if (propertyOverride == null || !propertyOverride.contains("localRef")) {
                DataModuleExtractor.clearList(ih.basicGetLocalRef());
            }
            DataModuleExtractor.removeUnoverridenCalculatedMember(ih.basicGetCalculatedMember());
        }
        DataModuleExtractor.removeUnoverridenPropertyOverride((ObjectType)ih, keepPropOverride);
    }

    private static void clearList(List<?> list) {
        if (list != null) {
            list.clear();
        }
    }

    private static boolean emptyList(List<?> list) {
        return list == null || list.isEmpty();
    }

    public static boolean notEmptyList(List<?> list) {
        return list != null && !list.isEmpty();
    }

    private static void removeUnoverridenQuerySubjectProperties(QuerySubject qs) {
        DataModuleExtractor.removeUnoverridenObjectTypeProperties((ObjectType)qs);
        DataModuleExtractor.removeUnoverridenQuerySubjectFilters(qs);
        DataModuleExtractor.clearList(qs.basicGetPropertyOverride());
        DataModuleExtractor.clearList(qs.basicGetProperty());
        qs.setNumberOfRows(null);
        qs.setItemNormalization(null);
    }

    private static void removeUnoverridenRelationshipProperties(Relationship relship) {
        DataModuleExtractor.removeUnoverridenObjectTypeProperties((ObjectType)relship);
        DataModuleExtractor.clearList(relship.basicGetPropertyOverride());
    }

    private static void removeFilterListGeneratedMetadata(List<Filter> filters) {
        if (filters == null) {
            return;
        }
        for (Filter f : filters) {
            DataModuleExtractor.removeGeneratedFilterProperties(f);
        }
    }

    private static boolean isImported(ObjectType obj) {
        List propOverride = obj.basicGetPropertyOverride();
        return propOverride != null && propOverride.contains("Imported");
    }

    private static void removeQuerySubjectMetadata(boolean embed, Module module, List<String> packageModules, boolean isEmbeddedModule) {
        List qsList = MoserObjectUtils.getList((List)module.basicGetQuerySubject());
        for (int qsIndex = qsList.size() - 1; qsIndex >= 0; --qsIndex) {
            QuerySubject qs = (QuerySubject)qsList.get(qsIndex);
            if (InstanceType.REFERENCE.equals((Object)qs.getInstanceType())) {
                List originalRef = qs.basicGetOriginalRef();
                if (DataModuleExtractor.notEmptyList(originalRef)) {
                    List ref = qs.getRef();
                    ref.clear();
                    ref.addAll(originalRef);
                    originalRef.clear();
                }
                int originalOverrideSize = 0;
                List originalOverride = qs.basicGetPropertyOverride();
                if (originalOverride != null) {
                    originalOverrideSize = originalOverride.size();
                }
                boolean isImported = DataModuleExtractor.isImported((ObjectType)qs);
                DataModuleExtractor.removeUnoverridenItems(qs.basicGetItem(), new ArrayList<String>(), embed);
                DataModuleExtractor.removeUnoverridenQuerySubjectProperties(qs);
                DataModuleExtractor.removeFilterListGeneratedMetadata(qs.basicGetFilter());
                if (isImported && originalOverrideSize == 1 && DataModuleExtractor.emptyList(qs.basicGetItem()) && DataModuleExtractor.emptyList(qs.basicGetFilter())) {
                    qsList.remove(qsIndex);
                    continue;
                }
                qs.setIdForExpression(null);
                continue;
            }
            if (InstanceType.MISSING.equals((Object)qs.getInstanceType())) {
                List propertyOverride;
                qs.setInstanceType(null);
                List qsRefs = MoserObjectUtils.getList((List)qs.basicGetRef());
                for (String ref : qsRefs) {
                    Module.UseSpec useSpec = DataModuleExtractor.getReferencedModuleUseSpec(ref, module.basicGetUseSpec());
                    if (useSpec == null || !UseSpecType.MODULE.equals((Object)useSpec.getType())) continue;
                    qs.setInstanceType(InstanceType.REFERENCE);
                    break;
                }
                if ((propertyOverride = qs.basicGetPropertyOverride()) != null && propertyOverride.contains("-label")) {
                    qs.setLabel(null);
                }
                if (DataModuleExtractor.isImported((ObjectType)qs)) {
                    qsList.remove(qsIndex);
                } else {
                    qs.setIdForExpression(null);
                }
                DataModuleExtractor.clearList(propertyOverride);
                continue;
            }
            if (isEmbeddedModule || packageModules.contains(ReferenceResolver.getFirstPart((String)qs.getIdentifier()))) {
                qsList.remove(qsIndex);
                continue;
            }
            List items = qs.basicGetItem();
            DataModuleExtractor.removeItemMetadata(items);
            DataModuleExtractor.removeFilterListGeneratedMetadata(qs.basicGetFilter());
            qs.setIdForExpression(null);
        }
    }

    private static void removeUnoverridenItems(List<ItemType> items, ArrayList<String> path, boolean embed) {
        if (DataModuleExtractor.emptyList(items)) {
            return;
        }
        for (int i = items.size() - 1; i >= 0; --i) {
            List nestedItems;
            path.add("" + i);
            String p = DataModuleExtractor.getPath(path);
            ItemType item = items.get(i);
            if (item.getQueryItem() != null) {
                QueryItem qi = item.getQueryItem();
                DataModuleExtractor.clearList(qi.basicGetMembers());
                nestedItems = qi.basicGetItem();
                DataModuleExtractor.removeUnoverridenItems(nestedItems, path, embed);
                if (DataModuleExtractor.emptyList(nestedItems) && DataModuleExtractor.emptyList(qi.basicGetPropertyOverride()) && !DataModuleExtractor.isCalculatedMemberTypeChanged(qi.basicGetCalculatedMember())) {
                    items.remove(i);
                } else {
                    DataModuleExtractor.removeUnoverridenQueryItemProperties(qi, embed);
                    DataModuleExtractor.removeGeneratedQueryItemProperties(qi);
                    if (embed) {
                        DataModuleExtractor.setPathProperty((ObjectType)qi, p, false);
                    }
                }
            } else if (item.getNamedSet() != null) {
                NamedSet ns = item.getNamedSet();
                nestedItems = ns.basicGetItem();
                DataModuleExtractor.removeUnoverridenItems(nestedItems, path, embed);
                if (DataModuleExtractor.emptyList(nestedItems) && DataModuleExtractor.emptyList(ns.basicGetPropertyOverride())) {
                    items.remove(i);
                } else {
                    DataModuleExtractor.removeUnoverridenNamedSetProperties(ns, embed);
                    DataModuleExtractor.removeGeneratedNamedSetProperties(ns);
                    if (embed) {
                        DataModuleExtractor.setPathProperty((ObjectType)ns, p, false);
                    }
                }
            } else if (item.getFilter() != null) {
                Filter flt = item.getFilter();
                if (DataModuleExtractor.emptyList(flt.basicGetPropertyOverride())) {
                    items.remove(i);
                } else {
                    DataModuleExtractor.removeUnoverridenFilterProperties(flt, embed);
                    DataModuleExtractor.removeGeneratedFilterProperties(flt);
                    if (embed) {
                        DataModuleExtractor.setPathProperty((ObjectType)flt, p, false);
                    }
                }
            } else if (item.getFolder() != null) {
                ItemType.Folder folder = item.getFolder();
                nestedItems = folder.basicGetItem();
                DataModuleExtractor.removeUnoverridenItems(nestedItems, path, embed);
                if (DataModuleExtractor.emptyList(nestedItems) && DataModuleExtractor.emptyList(folder.basicGetPropertyOverride())) {
                    items.remove(i);
                } else {
                    DataModuleExtractor.removeUnoverridenFolderProperties(folder, embed);
                    if (embed) {
                        DataModuleExtractor.setPathProperty((ObjectType)folder, p, false);
                    }
                }
            } else if (item.getItemHierarchy() != null) {
                ItemHierarchy ih = item.getItemHierarchy();
                if (DataModuleExtractor.emptyList(ih.basicGetPropertyOverride()) && !DataModuleExtractor.isCalculatedMemberTypeChanged(ih.basicGetCalculatedMember())) {
                    items.remove(i);
                } else {
                    DataModuleExtractor.removeUnoverridenItemHierarchyProperties(ih, embed);
                    DataModuleExtractor.removeGeneratedItemHierarchyProperties(ih);
                    if (embed) {
                        DataModuleExtractor.setPathProperty((ObjectType)ih, p, false);
                    }
                }
            } else if (item.getCalculation() != null) {
                Calculation calc = item.getCalculation();
                nestedItems = calc.basicGetItem();
                DataModuleExtractor.removeUnoverridenItems(nestedItems, path, embed);
                if (DataModuleExtractor.emptyList(nestedItems) && DataModuleExtractor.emptyList(calc.basicGetPropertyOverride())) {
                    items.remove(i);
                } else {
                    DataModuleExtractor.removeUnoverridenCalculationProperties(calc, embed);
                    DataModuleExtractor.removeGeneratedCalculationProperties(calc);
                    if (embed) {
                        DataModuleExtractor.setPathProperty((ObjectType)calc, p, false);
                    }
                }
            }
            path.remove(path.size() - 1);
        }
    }

    private static String getPath(List<String> path) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < path.size(); ++i) {
            if (i > 0) {
                sb.append(".");
            }
            sb.append(path.get(i));
        }
        return sb.toString();
    }

    private static void setPathProperty(ObjectType obj, String p, boolean append) {
        PropertyType prop = null;
        List propList = obj.getProperty();
        for (PropertyType pp : propList) {
            if (!"_path".equals(pp.getName())) continue;
            prop = pp;
            break;
        }
        if (prop == null) {
            prop = new PropertyType();
            prop.setName("_path");
            propList.add(prop);
        }
        if (!append) {
            prop.setValue(p);
        } else {
            String old = prop.getValue();
            if (old == null) {
                prop.setValue(p);
            } else {
                prop.setValue(old + ";" + p);
            }
        }
    }

    private static void removeItemMetadata(List<ItemType> items) {
        if (items == null) {
            return;
        }
        for (ItemType item : items) {
            ItemType.Folder folder;
            Filter flt;
            QueryItem qi = item.getQueryItem();
            if (qi != null) {
                DataModuleExtractor.removeGeneratedQueryItemProperties(qi);
                DataModuleExtractor.removeSplitDefinitionMetadata(qi, qi.basicGetSplitDefinition());
                DataModuleExtractor.removeMembers(qi);
                if (qi.basicGetItem() != null) {
                    DataModuleExtractor.removeItemMetadata(qi.basicGetItem());
                }
            }
            if ((flt = item.getFilter()) != null) {
                flt.setIdForExpression(null);
                DataModuleExtractor.clearList(flt.basicGetPropertyOverride());
            }
            if ((folder = item.getFolder()) == null) continue;
            DataModuleExtractor.removeItemMetadata(folder.basicGetItem());
        }
    }

    private static void removeMembers(QueryItem qi) {
        DataModuleExtractor.clearList(qi.basicGetMembers());
        List items = MoserObjectUtils.getList((List)qi.basicGetItem());
        for (ItemType item : items) {
            QueryItem qi2 = item.getQueryItem();
            if (qi2 == null) continue;
            DataModuleExtractor.removeMembers(qi2);
        }
    }

    private static boolean isCalculatedMemberTypeChanged(List<CalculatedMemberType> calcMembList) {
        if (DataModuleExtractor.notEmptyList(calcMembList)) {
            for (CalculatedMemberType calcMember : calcMembList) {
                if (!DataModuleExtractor.notEmptyList(calcMember.basicGetPropertyOverride())) continue;
                return true;
            }
        }
        return false;
    }

    private static void removeCalculationMetadata(List<Calculation> calcList, List<String> packageModules) {
        if (calcList == null) {
            return;
        }
        for (int i = calcList.size() - 1; i >= 0; --i) {
            Calculation calc = calcList.get(i);
            if (DataModuleExtractor.isImported((ObjectType)calc) || packageModules.contains(ReferenceResolver.getFirstPart((String)calc.getIdentifier()))) {
                calcList.remove(i);
                continue;
            }
            DataModuleExtractor.removeGeneratedCalculationProperties(calc);
        }
    }

    private static void removeRelationshipMetadata(List<Relationship> relList) {
        if (relList == null) {
            return;
        }
        for (int i = relList.size() - 1; i >= 0; --i) {
            Relationship relship = relList.get(i);
            if (InstanceType.REFERENCE.equals((Object)relship.getInstanceType()) || InstanceType.MISSING.equals((Object)relship.getInstanceType())) {
                if (DataModuleExtractor.isImported((ObjectType)relship) && DataModuleExtractor.notEmptyList(relship.basicGetPropertyOverride()) && relship.getPropertyOverride().size() == 1) {
                    relList.remove(i);
                    continue;
                }
                DataModuleExtractor.removeUnoverridenRelationshipProperties(relship);
                relship.setLeft(null);
                relship.setRight(null);
                DataModuleExtractor.clearList(relship.basicGetLink());
                if (!InstanceType.MISSING.equals((Object)relship.getInstanceType())) continue;
                relship.setInstanceType(InstanceType.REFERENCE);
                continue;
            }
            if (!DataModuleExtractor.isImported((ObjectType)relship)) continue;
            relList.remove(i);
        }
    }

    private static void removeGlobalFilterMetadata(List<Filter> filterList, List<String> packageModules) {
        if (filterList == null) {
            return;
        }
        for (int i = filterList.size() - 1; i >= 0; --i) {
            Filter filter = filterList.get(i);
            if (!DataModuleExtractor.isImported((ObjectType)filter) && !packageModules.contains(ReferenceResolver.getFirstPart((String)filter.getIdentifier()))) continue;
            filterList.remove(i);
        }
    }

    private static void removeListMetadata(List<? extends ObjectType> list, List<String> packageModules) {
        if (list == null) {
            return;
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            ObjectType obj = list.get(i);
            if (!DataModuleExtractor.isImported(obj) && !packageModules.contains(ReferenceResolver.getFirstPart((String)obj.getIdentifier()))) continue;
            list.remove(i);
        }
    }

    private static void removeMDTV(Module module, List<String> packageModules) {
        if (packageModules == null) {
            return;
        }
        for (String moduleAlias : packageModules) {
            FolderType placeHolder = CommonResolverUtil.getFMPlaceHolderInMDTV(module, moduleAlias);
            if (placeHolder == null) continue;
            placeHolder.setLabel(null);
            DataModuleExtractor.clearList(placeHolder.basicGetFolderItem());
            List propertyOverride = placeHolder.basicGetPropertyOverride();
            if (propertyOverride != null && DataModuleExtractor.isImported((ObjectType)placeHolder) && propertyOverride.contains("Imported")) {
                for (int i = propertyOverride.size() - 1; i >= 0; --i) {
                    String prop = (String)propertyOverride.get(i);
                    if (!"Imported".equals(prop)) continue;
                    propertyOverride.remove(i);
                }
            }
            if (placeHolder.getIdentifier() != null || propertyOverride == null || !propertyOverride.contains(moduleAlias)) continue;
            placeHolder.setIdentifier(moduleAlias);
            propertyOverride.clear();
        }
    }

    private static void removeImportedMDTV(Module module, List<String> packageModules) {
        List mdtv = module.basicGetMetadataTreeView();
        if (DataModuleExtractor.notEmptyList(mdtv)) {
            FolderType dummyFolderForNewFolderItems = new FolderType();
            List fiList = MoserObjectUtils.getList((List)((FolderType)mdtv.get(0)).basicGetFolderItem());
            for (int i = fiList.size() - 1; i >= 0; --i) {
                FolderItemType fi = (FolderItemType)fiList.get(i);
                FolderType folder = fi.getFolder();
                if (folder != null && DataModuleExtractor.isImported((ObjectType)folder)) {
                    fiList.remove(i);
                    ArrayList<String> path = new ArrayList<String>();
                    path.add("" + i);
                    DataModuleExtractor.collectNewFolderItems(dummyFolderForNewFolderItems, folder, path, module);
                    continue;
                }
                String ref = fi.getRef();
                if (ref != null) {
                    ObjectType obj = ReferenceResolver.findRefById((String)ref, (Module)module);
                    if (obj != null && !DataModuleExtractor.isImported(obj)) continue;
                    fiList.remove(i);
                    continue;
                }
                FolderType f = fi.getFolder();
                String id = f.getIdentifier();
                if (id == null || id.indexOf("M") != 0 || !packageModules.contains(id)) continue;
                fiList.remove(i);
            }
            if (fiList.isEmpty() && dummyFolderForNewFolderItems.basicGetFolderItem() == null) {
                module.getMetadataTreeView().remove(0);
            }
            if (dummyFolderForNewFolderItems.basicGetFolderItem() != null) {
                FolderItemType dummyFolderItem = new FolderItemType();
                dummyFolderItem.setFolder(dummyFolderForNewFolderItems);
                fiList.add(dummyFolderItem);
            }
        }
    }

    private static void collectNewFolderItems(FolderType dummyFolderForNewFolderItems, FolderType folder, ArrayList<String> path, Module module) {
        List fiList = folder.basicGetFolderItem();
        if (fiList == null) {
            return;
        }
        for (int i = 0; i < fiList.size(); ++i) {
            path.add("" + i);
            FolderItemType fi = (FolderItemType)fiList.get(i);
            FolderType subFolder = fi.getFolder();
            if (subFolder != null && DataModuleExtractor.isImported((ObjectType)subFolder)) {
                DataModuleExtractor.collectNewFolderItems(dummyFolderForNewFolderItems, subFolder, path, module);
            } else {
                ObjectType obj;
                String ref = fi.getRef();
                if (ref != null && (obj = ReferenceResolver.findRefById((String)ref, (Module)module)) != null && !DataModuleExtractor.isImported(obj)) {
                    dummyFolderForNewFolderItems.getFolderItem().add(fi);
                    String idOfParentFolder = folder.getIdentifier();
                    String p = null;
                    p = idOfParentFolder != null && !idOfParentFolder.isEmpty() ? idOfParentFolder + "." + i : DataModuleExtractor.getPath(path);
                    DataModuleExtractor.setPathProperty((ObjectType)dummyFolderForNewFolderItems, p, true);
                }
            }
            path.remove(path.size() - 1);
        }
    }

    private static boolean isResolvedUseSpec(Module.UseSpec useSpec) {
        return 0 == useSpec.getIdentifier().indexOf("__Base");
    }

    private static void removeResolvedUseSpec(Module module, List<Module.UseSpec> useSpecList, boolean isEmbeddedModule) {
        if (useSpecList == null) {
            return;
        }
        for (int i = useSpecList.size() - 1; i >= 0; --i) {
            Module.UseSpec useSpec = useSpecList.get(i);
            if (!DataModuleExtractor.isResolvedUseSpec(useSpec) && (!isEmbeddedModule || "*".equals(useSpec.getImports()) || DataModuleExtractor.isReferencedUseSpec(useSpec, module))) continue;
            useSpecList.remove(i);
        }
    }

    private static boolean isReferencedUseSpec(Module.UseSpec useSpec, Module module) {
        List filters;
        List calculations;
        List relationships;
        List querySubjects = module.basicGetQuerySubject();
        if (querySubjects != null && !querySubjects.isEmpty()) {
            for (QuerySubject qs : querySubjects) {
                Module.UseSpec u = DataModuleExtractor.getUseSpec((ObjectType)qs, module, true);
                if (useSpec != u) continue;
                return true;
            }
        }
        if ((relationships = module.basicGetRelationship()) != null && !relationships.isEmpty()) {
            for (Relationship rel : relationships) {
                Module.UseSpec u = DataModuleExtractor.getUseSpec((ObjectType)rel, module, true);
                if (useSpec != u) continue;
                return true;
            }
        }
        if ((calculations = module.basicGetCalculation()) != null && !calculations.isEmpty()) {
            for (Calculation calc : calculations) {
                Module.UseSpec u = DataModuleExtractor.getUseSpec((ObjectType)calc, module, true);
                if (useSpec != u) continue;
                return true;
            }
        }
        if ((filters = module.basicGetFilter()) != null && !filters.isEmpty()) {
            for (Filter filter : filters) {
                Module.UseSpec u = DataModuleExtractor.getUseSpec((ObjectType)filter, module, true);
                if (useSpec != u) continue;
                return true;
            }
        }
        return false;
    }

    public static List<ObjectType> getUseSpecRefs(Module.UseSpec useSpec, Module module) {
        List filters;
        List calculations;
        List relationships;
        ArrayList<ObjectType> result = new ArrayList<ObjectType>();
        List querySubjects = module.basicGetQuerySubject();
        if (querySubjects != null && !querySubjects.isEmpty()) {
            for (QuerySubject qs : querySubjects) {
                Module.UseSpec u = DataModuleExtractor.getUseSpec((ObjectType)qs, module, true);
                if (useSpec != u) continue;
                result.add((ObjectType)qs);
            }
        }
        if ((relationships = module.basicGetRelationship()) != null && !relationships.isEmpty()) {
            for (Relationship rel : relationships) {
                Module.UseSpec u = DataModuleExtractor.getUseSpec((ObjectType)rel, module, true);
                if (useSpec != u) continue;
                result.add((ObjectType)rel);
            }
        }
        if ((calculations = module.basicGetCalculation()) != null && !calculations.isEmpty()) {
            for (Calculation calc : calculations) {
                Module.UseSpec u = DataModuleExtractor.getUseSpec((ObjectType)calc, module, true);
                if (useSpec != u) continue;
                result.add((ObjectType)calc);
            }
        }
        if ((filters = module.basicGetFilter()) != null && !filters.isEmpty()) {
            for (Filter filter : filters) {
                Module.UseSpec u = DataModuleExtractor.getUseSpec((ObjectType)filter, module, true);
                if (useSpec != u) continue;
                result.add((ObjectType)filter);
            }
        }
        return result;
    }

    public static Module.UseSpec getUseSpec(ObjectType obj, Module m, boolean originalRef) {
        if (obj instanceof QuerySubject) {
            return DataModuleExtractor.getQuerySubjectUseSpec((QuerySubject)obj, m, originalRef);
        }
        if (obj instanceof Relationship) {
            return DataModuleExtractor.getUseSpecByRef(m, ((Relationship)obj).getRef(), true);
        }
        if (obj instanceof Filter) {
            return DataModuleExtractor.getUseSpecByRef(m, obj.getIdentifier(), true);
        }
        if (obj instanceof Calculation) {
            Module.UseSpec spec = DataModuleExtractor.getUseSpecByRef(m, obj.getIdentifier(), true);
            if (spec == null) {
                boolean embedded;
                boolean bl = embedded = !m.getUseSpec().isEmpty() && "*".equals(((Module.UseSpec)m.getUseSpec().get(0)).getImports());
                if (embedded && obj.isImported()) {
                    return (Module.UseSpec)m.getUseSpec().get(0);
                }
            }
            return spec;
        }
        return null;
    }

    private static Module.UseSpec getUseSpecByRefs(Module module, List<String> refs, boolean canBePackage) {
        if (refs != null && !refs.isEmpty()) {
            return DataModuleExtractor.getUseSpecByRef(module, refs.get(0), canBePackage);
        }
        return null;
    }

    private static Module.UseSpec getQuerySubjectUseSpec(QuerySubject qs, Module module, boolean originalRef) {
        Module.UseSpec useSpec;
        if (originalRef && (useSpec = DataModuleExtractor.getUseSpecByRefs(module, qs.basicGetOriginalRef(), true)) != null) {
            return useSpec;
        }
        useSpec = DataModuleExtractor.getUseSpecByRefs(module, qs.basicGetRef(), false);
        if (useSpec != null) {
            return useSpec;
        }
        if (!originalRef && (useSpec = DataModuleExtractor.getUseSpecByRefs(module, qs.basicGetOriginalRef(), true)) != null) {
            return useSpec;
        }
        return DataModuleExtractor.getUseSpecByRef(module, qs.getIdentifier(), true);
    }

    public static Module.UseSpec getUseSpecByRef(Module module, String ref, boolean canBePackage) {
        String moduleAlias = ReferenceResolver.getFirstPart((String)ref);
        if (moduleAlias != null && !moduleAlias.isEmpty()) {
            Module.UseSpec useSpec = DataModuleExtractor.getUseSpecById(module, moduleAlias);
            if (!canBePackage && useSpec != null && UseSpecType.PACKAGE.equals((Object)useSpec.getType())) {
                return null;
            }
            return useSpec;
        }
        return null;
    }

    public static Module.UseSpec getUseSpecById(Module module, String useSpecId) {
        List uSpecs = MoserObjectUtils.getList((List)module.basicGetUseSpec());
        for (Module.UseSpec useSpec : uSpecs) {
            if (!useSpecId.equals(useSpec.getIdentifier())) continue;
            return useSpec;
        }
        return null;
    }

    private static void removeUnoverridenProperty(List<PropertyType> propertyList, List<String> propertyOverride) {
        if (propertyList == null) {
            return;
        }
        for (int i = propertyList.size() - 1; i >= 0; --i) {
            PropertyType property = propertyList.get(i);
            if (propertyOverride != null && propertyOverride.contains("property." + property.getName())) continue;
            propertyList.remove(i);
        }
    }

    public static void removeModuleMetadata(Module module) {
        boolean overrideMode = module.isOverrideMode();
        module.setOverrideMode(false);
        DataModuleExtractor.clearList(module.basicGetUse());
        DataModuleExtractor.clearList(module.basicGetDataSource());
        List useSpecList = MoserObjectUtils.getList((List)module.basicGetUseSpec());
        ArrayList<String> packageModules = new ArrayList<String>();
        boolean isEmbeddedModule = DataModuleExtractor.isEmbeddedModule(useSpecList);
        for (Module.UseSpec useSpec : useSpecList) {
            if (!UseSpecType.PACKAGE.equals((Object)useSpec.getType()) && !UseSpecType.LW_OLAP.equals((Object)useSpec.getType()) && !UseSpecType.REPORT.equals((Object)useSpec.getType())) continue;
            packageModules.add(useSpec.getIdentifier());
        }
        DataModuleExtractor.removeMDTV(module, packageModules);
        if (isEmbeddedModule) {
            DataModuleExtractor.removeImportedMDTV(module, packageModules);
        }
        DataModuleExtractor.removeQuerySubjectMetadata(isEmbeddedModule, module, packageModules, DataModuleExtractor.isEmbeddedModuleForPackage(module.basicGetUseSpec()));
        DataModuleExtractor.removeCalculationMetadata(module.basicGetCalculation(), packageModules);
        DataModuleExtractor.removeGlobalFilterMetadata(module.basicGetFilter(), packageModules);
        DataModuleExtractor.removeRelationshipMetadata(module.basicGetRelationship());
        DataModuleExtractor.removeListMetadata(module.basicGetDrillGroup(), packageModules);
        DataModuleExtractor.removeListMetadata(module.basicGetParameterMap(), packageModules);
        DataModuleExtractor.removeResolvedUseSpec(module, useSpecList, isEmbeddedModule);
        DataModuleExtractor.removeNamedSetMetadata(module);
        if (isEmbeddedModule) {
            List propertyOverride = module.basicGetPropertyOverride();
            DataModuleExtractor.removeUnoverridenProperty(module.basicGetProperty(), propertyOverride);
        }
        module.setOverrideMode(overrideMode);
    }

    public static void removeMembersFromQS(QuerySubject qs) {
        List items = qs.basicGetItem();
        if (items != null) {
            for (ItemType item : items) {
                QueryItem qi = item.getQueryItem();
                if (qi == null) continue;
                DataModuleExtractor.removeMembers(qi);
            }
        }
    }

    private static void removeNamedSetMetadata(Module module) {
        DataModuleExtractor.clearList(module.basicGetNamedSet());
    }

    public static boolean isEmbeddedModule(List<Module.UseSpec> useSpecs) {
        return DataModuleExtractor.notEmptyList(useSpecs) && "*".equals(useSpecs.get(0).getImports());
    }

    public static boolean isEmbeddedModuleForPackage(List<Module.UseSpec> useSpecs) {
        return DataModuleExtractor.isEmbeddedModule(useSpecs) && (UseSpecType.PACKAGE.equals((Object)useSpecs.get(0).getType()) || UseSpecType.REPORT.equals((Object)useSpecs.get(0).getType()));
    }
}

