/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.wrangler.api;

import com.ibm.neo.probekit.IEvent;
import com.ibm.neo.probekit.IProbe;
import com.ibm.neo.probekit.ProbeFactory;
import com.ibm.neo.probekit.ProbeSchema;
import com.ibm.neo.probekit.ProbeUtils;
import java.util.Date;
import org.apache.commons.lang.exception.ExceptionUtils;

public class DLockProbe {
    private static final long DEFAULT_MIN_ACQUIRE_TIME = 1000L;
    private static final String PROP_MIN_ACQUIRE_TIME = "min-acquire-time";
    private static final long DEFAULT_MIN_HELD_TIME = 30000L;
    private static final String PROP_MIN_HELD_TIME = "min-held-time";
    private static final DLockAcquireSchema ACQUIRE_SCHEMA = new DLockAcquireSchema();
    private static final DLockHeldSchema HELD_SCHEMA = new DLockHeldSchema();
    private static final IProbe ACQUIRE_PROBE = ProbeFactory.create((ProbeSchema)ACQUIRE_SCHEMA, (boolean)false);
    private static final IProbe HELD_PROBE = ProbeFactory.create((ProbeSchema)HELD_SCHEMA, (boolean)false);

    public static IEvent startAcquire(String lockName) {
        if (!ACQUIRE_PROBE.isEnabled()) {
            return null;
        }
        IEvent event = ACQUIRE_PROBE.createEvent();
        event.setField(DLockProbe.ACQUIRE_SCHEMA.lockName, (Object)lockName);
        event.setField(DLockProbe.ACQUIRE_SCHEMA.failed, (Object)false);
        return event;
    }

    public static void endAcquire(IEvent event, boolean acquired, Throwable error) {
        if (null == event) {
            return;
        }
        if (acquired) {
            long acquireTime = System.currentTimeMillis() - ((Date)event.getField(DLockProbe.ACQUIRE_SCHEMA.startTime)).getTime();
            if (acquireTime < DLockProbe.getMinAcquireTime()) {
                return;
            }
            event.setField(DLockProbe.ACQUIRE_SCHEMA.acquired, (Object)true);
        } else {
            event.setField(DLockProbe.ACQUIRE_SCHEMA.acquired, (Object)false);
            if (null != error) {
                event.setField(DLockProbe.ACQUIRE_SCHEMA.failed, (Object)true);
                event.setField(DLockProbe.ACQUIRE_SCHEMA.error, (Object)ExceptionUtils.getFullStackTrace((Throwable)error));
                event.setField(DLockProbe.ACQUIRE_SCHEMA.exceptionId, (Object)ProbeUtils.object2Id((Object)error));
            }
        }
        event.commit();
    }

    public static IEvent startHeld(String lockName) {
        if (!HELD_PROBE.isEnabled()) {
            return null;
        }
        IEvent event = HELD_PROBE.createEvent();
        event.setField(DLockProbe.HELD_SCHEMA.lockName, (Object)lockName);
        event.setField(DLockProbe.HELD_SCHEMA.leaked, (Object)false);
        event.setField(DLockProbe.HELD_SCHEMA.failed, (Object)false);
        return event;
    }

    public static void setLeaked(IEvent event) {
        if (null == event) {
            return;
        }
        event.setField(DLockProbe.HELD_SCHEMA.leaked, (Object)true);
    }

    public static void endHeld(IEvent event, Throwable error) {
        long heldTime;
        if (null == event) {
            return;
        }
        if (null != error) {
            event.setField(DLockProbe.HELD_SCHEMA.failed, (Object)true);
            event.setField(DLockProbe.HELD_SCHEMA.error, (Object)ExceptionUtils.getFullStackTrace((Throwable)error));
            event.setField(DLockProbe.HELD_SCHEMA.exceptionId, (Object)ProbeUtils.object2Id((Object)error));
        } else if (!((Boolean)event.getField(DLockProbe.HELD_SCHEMA.leaked)).booleanValue() && (heldTime = System.currentTimeMillis() - ((Date)event.getField(DLockProbe.HELD_SCHEMA.startTime)).getTime()) < DLockProbe.getMinHeldTime()) {
            return;
        }
        event.commit();
    }

    private static long getMinAcquireTime() {
        return ACQUIRE_PROBE.getConfig().getChildLongValue(PROP_MIN_ACQUIRE_TIME, Long.valueOf(1000L));
    }

    private static long getMinHeldTime() {
        return HELD_PROBE.getConfig().getChildLongValue(PROP_MIN_HELD_TIME, Long.valueOf(30000L));
    }

    static final class DLockHeldSchema
    extends ProbeSchema {
        final ProbeSchema.Field<Date> startTime = new ProbeSchema.StartTimeField((ProbeSchema)this);
        final ProbeSchema.Field<Date> endTime = new ProbeSchema.EndTimeField((ProbeSchema)this);
        final ProbeSchema.Field<Long> duration = new ProbeSchema.DurationTimeField((ProbeSchema)this, this.startTime, this.endTime);
        final ProbeSchema.Field<String> host = new ProbeSchema.HostField((ProbeSchema)this);
        final ProbeSchema.Field<String> hostAddress = new ProbeSchema.HostAddressField((ProbeSchema)this);
        final ProbeSchema.Field<String> thread = new ProbeSchema.StartThreadField((ProbeSchema)this);
        final ProbeSchema.Field<String> startStack = new ProbeSchema.StartStackField((ProbeSchema)this, 50);
        final ProbeSchema.Field<String> lockName = new ProbeSchema.StringField((ProbeSchema)this, "LockName");
        final ProbeSchema.Field<Boolean> leaked = new ProbeSchema.BooleanField((ProbeSchema)this, "Leaked");
        final ProbeSchema.Field<Boolean> failed = new ProbeSchema.BooleanField((ProbeSchema)this, "Failed");
        final ProbeSchema.Field<String> error = new ProbeSchema.StringField((ProbeSchema)this, "Error");
        final ProbeSchema.Field<String> exceptionId = new ProbeSchema.StringField((ProbeSchema)this, "ExceptionId");

        DLockHeldSchema() {
            super("DLockHeld");
        }
    }

    static final class DLockAcquireSchema
    extends ProbeSchema {
        final ProbeSchema.Field<Date> startTime = new ProbeSchema.StartTimeField((ProbeSchema)this);
        final ProbeSchema.Field<Date> endTime = new ProbeSchema.EndTimeField((ProbeSchema)this);
        final ProbeSchema.Field<Long> duration = new ProbeSchema.DurationTimeField((ProbeSchema)this, this.startTime, this.endTime);
        final ProbeSchema.Field<String> host = new ProbeSchema.HostField((ProbeSchema)this);
        final ProbeSchema.Field<String> hostAddress = new ProbeSchema.HostAddressField((ProbeSchema)this);
        final ProbeSchema.Field<String> thread = new ProbeSchema.StartThreadField((ProbeSchema)this);
        final ProbeSchema.Field<String> startStack = new ProbeSchema.StartStackField((ProbeSchema)this, 50);
        final ProbeSchema.Field<String> lockName = new ProbeSchema.StringField((ProbeSchema)this, "LockName");
        final ProbeSchema.Field<Boolean> acquired = new ProbeSchema.BooleanField((ProbeSchema)this, "Acquired");
        final ProbeSchema.Field<Boolean> failed = new ProbeSchema.BooleanField((ProbeSchema)this, "Failed");
        final ProbeSchema.Field<String> error = new ProbeSchema.StringField((ProbeSchema)this, "Error");
        final ProbeSchema.Field<String> exceptionId = new ProbeSchema.StringField((ProbeSchema)this, "ExceptionId");

        DLockAcquireSchema() {
            super("DLockAcquire");
        }
    }
}

