/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.wrangler.api;

import com.ibm.neo.wrangler.api.DAtomicInt;
import com.ibm.neo.wrangler.api.DAtomicLong;
import com.ibm.neo.wrangler.api.DGroupMember;
import com.ibm.neo.wrangler.api.DLeaderLatch;
import com.ibm.neo.wrangler.api.DLock;
import com.ibm.neo.wrangler.api.WranglerException;
import com.ibm.neo.wrangler.api.WranglerProvider;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WranglerService {
    public static final String PROP_PROVIDER = "wrangler.provider";
    private static final String DEFAULT_PROVIDER = "com.ibm.neo.wrangler.provider.ps.PSWranglerProvider";
    private static final Logger LOGGER = LoggerFactory.getLogger(WranglerService.class);
    private static WranglerService sInstance = null;
    private final Properties config;
    private final AtomicReference<WranglerProvider> providerRef = new AtomicReference<Object>(null);
    private final Object providerSync = new Object();

    public static boolean isInitialized() {
        return null != sInstance;
    }

    public static void initialize(Properties config) throws WranglerException {
        if (null != sInstance) {
            throw new IllegalStateException("WranglerService was already initialized.");
        }
        LOGGER.info("Initializing WranglerService singleton with config: {}", (Object)config);
        sInstance = new WranglerService(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void terminate() {
        if (null != sInstance) {
            try {
                LOGGER.info("Disposing WranglerService singleton");
                sInstance.dispose();
            }
            catch (WranglerException ex) {
                LOGGER.error("Unexpected error", (Throwable)ex);
            }
            finally {
                sInstance = null;
            }
        }
    }

    public static synchronized WranglerService getInstance() {
        if (null == sInstance) {
            throw new IllegalStateException("WranglerService singleton was not initialized.");
        }
        return sInstance;
    }

    private static WranglerProvider initProvider(Properties config) throws WranglerException {
        WranglerProvider provider;
        String providerName = WranglerService.getProviderName(config);
        try {
            Class<?> providerClass = Class.forName(providerName);
            provider = (WranglerProvider)providerClass.newInstance();
            provider.initialize(config);
        }
        catch (WranglerException ex) {
            LOGGER.error("Failed to initialize WranglerProvider ({})", (Object)providerName, (Object)ex);
            throw ex;
        }
        catch (Exception ex) {
            LOGGER.error("Failed to initialize WranglerProvider ({})", (Object)providerName, (Object)ex);
            throw new WranglerException(ex);
        }
        return provider;
    }

    private static final String getProviderName(Properties config) {
        String providerName = config.getProperty(PROP_PROVIDER);
        if (StringUtils.isEmpty((String)providerName)) {
            providerName = System.getProperty(PROP_PROVIDER);
        }
        if (StringUtils.isEmpty((String)providerName)) {
            providerName = DEFAULT_PROVIDER;
        }
        return providerName;
    }

    protected WranglerService() throws WranglerException {
        this(new Properties());
    }

    public WranglerService(Properties config) throws WranglerException {
        this.config = config;
        try {
            this.getOrCreateProvider();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void dispose() throws WranglerException {
        WranglerProvider provider = this.providerRef.getAndSet(null);
        if (provider != null) {
            provider.terminate();
        }
    }

    public DLock getDLock(String name) throws WranglerException {
        WranglerProvider provider = this.getOrCreateProvider();
        return provider.getDLock(name);
    }

    public DAtomicInt getDAtomicInt(String name) throws WranglerException {
        WranglerProvider provider = this.getOrCreateProvider();
        return provider.getDAtomicInt(name);
    }

    public DAtomicLong getDAtomicLong(String name) throws WranglerException {
        WranglerProvider provider = this.getOrCreateProvider();
        return provider.getDAtomicLong(name);
    }

    public DLeaderLatch getDLeaderLatch(String name) throws WranglerException {
        WranglerProvider provider = this.getOrCreateProvider();
        return provider.getDLeaderLatch(name);
    }

    public DGroupMember getDGroupMember(String group, String thisId, byte[] thisData) throws WranglerException {
        WranglerProvider provider = this.getOrCreateProvider();
        return provider.getDGroupMember(group, thisId, thisData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WranglerProvider getOrCreateProvider() throws WranglerException {
        WranglerProvider provider = this.providerRef.get();
        if (null == provider) {
            Object object = this.providerSync;
            synchronized (object) {
                provider = this.providerRef.get();
                if (null == provider) {
                    provider = WranglerService.initProvider(this.config);
                    this.providerRef.compareAndSet(null, provider);
                }
            }
        }
        return provider;
    }
}

