/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.CAM_AAA.authentication.proxy;

import com.cognos.CAM_AAA.authentication.IBiBusHeader2;
import com.cognos.CAM_AAA.authentication.ITrustedSignonRequest;
import com.cognos.CAM_AAA.authentication.proxy.AdditionalInfo;
import com.cognos.CAM_AAA.authentication.proxy.BiBusHeaderHandler;
import com.cognos.CAM_AAA.authentication.proxy.EscapedWriteTo;
import com.cognos.CAM_AAA.authentication.proxy.SecurityBlob;
import com.cognos.CAM_AAA.authentication.proxy.SetCookieVar;
import com.cognos.CAM_AAA.authentication.proxy.XmlTag;
import java.io.CharArrayReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

class BiBusHeader
implements ITrustedSignonRequest,
IBiBusHeader2 {
    protected String m_action = null;
    protected String m_passportID = null;
    protected AdditionalInfo m_additionalInfo;
    private HashMap m_setCookieVars = new HashMap();
    private HashMap m_cookieVars = new HashMap();
    private HashMap m_environmentVars = new HashMap();
    private HashMap m_formFields = new HashMap();
    private HashMap m_credentials = new HashMap();
    private HashMap m_trustedCredentials = new HashMap();
    private HashMap m_trustedEnvironmentVars = new HashMap();
    private boolean m_isSystemRecoverableAllowed = true;

    public BiBusHeader() {
        this.m_additionalInfo = new AdditionalInfo();
    }

    public void addCredential(String string, String string2) {
        Vector<String> vector = (Vector<String>)this.m_credentials.get(string);
        if (vector == null) {
            vector = new Vector<String>();
            this.m_credentials.put(string, vector);
        }
        vector.add(string2);
    }

    public void addTrustedCredential(String string, String string2) {
        Vector<String> vector = (Vector<String>)this.m_trustedCredentials.get(string);
        if (vector == null) {
            vector = new Vector<String>();
            this.m_trustedCredentials.put(string, vector);
        }
        vector.add(string2);
    }

    public String[] getCredentialValue(String string) {
        Vector vector = (Vector)this.m_credentials.get(string);
        if (vector != null) {
            return vector.toArray(new String[vector.size()]);
        }
        return null;
    }

    public String[] getTrustedCredentialValue(String string) {
        Vector vector = (Vector)this.m_trustedCredentials.get(string);
        if (vector != null) {
            return vector.toArray(new String[vector.size()]);
        }
        return null;
    }

    protected void addFormFieldVar(String string, String string2, String string3) {
        Vector<String> vector = (Vector<String>)this.m_formFields.get(string);
        if (vector == null) {
            vector = new Vector<String>();
            this.m_formFields.put(string, vector);
        }
        vector.add(string2);
        if (string.equals(XmlTag.CAMCheckGateway) && string2 != null) {
            this.m_isSystemRecoverableAllowed = new Boolean(string2) == false;
        }
    }

    public String[] getFormFieldValue(String string) {
        Vector vector = (Vector)this.m_formFields.get(string);
        if (vector != null) {
            return vector.toArray(new String[vector.size()]);
        }
        return null;
    }

    protected void addCookieVar(String string, String string2) {
        Vector<String> vector = (Vector<String>)this.m_cookieVars.get(string);
        if (vector == null) {
            vector = new Vector<String>();
            this.m_cookieVars.put(string, vector);
        }
        vector.add(string2);
    }

    public String[] getCookieValue(String string) {
        Vector vector = (Vector)this.m_cookieVars.get(string);
        if (vector != null) {
            return vector.toArray(new String[vector.size()]);
        }
        return null;
    }

    public void addEnvVar(String string, String string2) {
        Vector<String> vector = (Vector<String>)this.m_environmentVars.get(string);
        if (vector == null) {
            vector = new Vector<String>();
            this.m_environmentVars.put(string, vector);
        }
        vector.add(string2);
    }

    public String[] getEnvVarValue(String string) {
        Vector vector = (Vector)this.m_environmentVars.get(string);
        if (vector != null) {
            return vector.toArray(new String[vector.size()]);
        }
        return null;
    }

    public String[] getTrustedEnvVarValue(String string) {
        Vector vector = (Vector)this.m_trustedEnvironmentVars.get(string);
        if (vector != null) {
            return vector.toArray(new String[vector.size()]);
        }
        if (this.m_isSystemRecoverableAllowed) {
            return null;
        }
        return new String[]{""};
    }

    public void consumeFormField(String string) {
        this.m_formFields.remove(string);
    }

    protected void addSetCookieVar(String string, String string2, String string3, String string4, String string5, String string6) {
        Boolean bl = null;
        if (string6 != null) {
            bl = string6.equalsIgnoreCase(XmlTag.True) ? Boolean.TRUE : Boolean.FALSE;
        }
        int n = 0;
        if (string4 != null) {
            n = new Integer(string4);
        }
        this.setCookie2(string, string2, n, string3, string5, bl);
    }

    private void setCookie2(String string, String string2, int n, String string3, String string4, Boolean bl) {
        Vector<SetCookieVar> vector = (Vector<SetCookieVar>)this.m_setCookieVars.get(string);
        if (vector == null) {
            vector = new Vector<SetCookieVar>();
            this.m_setCookieVars.put(string, vector);
        }
        SetCookieVar setCookieVar = new SetCookieVar(string, string2, n, string3, string4, bl);
        vector.add(setCookieVar);
    }

    public void setCookie(String string, String string2, int n, String string3, String string4, boolean bl) {
        Boolean bl2 = new Boolean(bl);
        this.setCookie2(string, string2, n, string3, string4, bl2);
    }

    public void addTrustedEnvVar(String string, String string2) {
        Vector<String> vector = (Vector<String>)this.m_trustedEnvironmentVars.get(string);
        if (vector == null) {
            vector = new Vector<String>();
            this.m_trustedEnvironmentVars.put(string, vector);
        }
        vector.add(string2);
    }

    public void removeCredential(String string) {
        this.m_credentials.remove(string);
    }

    public void removeTrustedCredential(String string) {
        this.m_trustedCredentials.remove(string);
    }

    public void removeEnvVar(String string) {
        this.m_environmentVars.remove(string);
    }

    public void removeTrustedEnvVar(String string) {
        this.m_trustedEnvironmentVars.remove(string);
    }

    public Locale getProductLocale() {
        return this.m_additionalInfo.m_productLocale;
    }

    public Locale getContentLocale() {
        return this.m_additionalInfo.m_contentLocale;
    }

    public String getAction() {
        return this.m_action;
    }

    public String getPassportID() {
        return this.m_passportID;
    }

    public AdditionalInfo getAdditionalInfo() {
        return this.m_additionalInfo;
    }

    public void setNamespaceID(String string) {
        String[] stringArray = null;
        stringArray = this.getCredentialValue(XmlTag.CAMCredential_Namespace);
        if (stringArray != null) {
            this.removeCredential(XmlTag.CAMCredential_Namespace);
        }
        if ((stringArray = this.getTrustedCredentialValue(XmlTag.CAMCredential_Namespace)) != null) {
            this.removeTrustedCredential(XmlTag.CAMCredential_Namespace);
        }
        if ((stringArray = this.getFormFieldValue(XmlTag.CAMNamespace)) != null) {
            this.consumeFormField(XmlTag.CAMNamespace);
        }
        this.addFormFieldVar(XmlTag.CAMNamespace, string, null);
    }

    public void readFromXML(String string) {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            sAXParserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            sAXParserFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            BiBusHeaderHandler biBusHeaderHandler = new BiBusHeaderHandler();
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            biBusHeaderHandler.setBiBusHeader(this);
            sAXParser.parse(new InputSource(new CharArrayReader(string.toCharArray())), (DefaultHandler)biBusHeaderHandler);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void readFromFile(String string) {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            sAXParserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            sAXParserFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            BiBusHeaderHandler biBusHeaderHandler = new BiBusHeaderHandler();
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            biBusHeaderHandler.setBiBusHeader(this);
            sAXParser.parse(string, (DefaultHandler)biBusHeaderHandler);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected void setSecurityBlob(String string) {
        SecurityBlob securityBlob = new SecurityBlob();
        securityBlob.parseBlob(string);
        if (securityBlob.getBlobType() == 1) {
            securityBlob.parseTrustedEnvironmentBlob(this.m_trustedEnvironmentVars);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<bus:biBusHeader");
        stringBuffer.append(" xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"");
        stringBuffer.append(" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\"");
        stringBuffer.append(" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"");
        stringBuffer.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        stringBuffer.append(" xmlns:bus=\"http://developer.cognos.com/schemas/bibus/3/\">");
        stringBuffer.append("<CAM xsi:type=\"bus:CAM\">");
        if (this.m_passportID != null) {
            stringBuffer.append("<CAMPassport xsi:type=\"bus:CAMPassport\">");
            stringBuffer.append("<id xsi:type=\"xsd:string\" xml:space=\"preserve\">" + EscapedWriteTo.apply(this.m_passportID) + "</id>");
            stringBuffer.append("</CAMPassport>");
        }
        if (this.m_action != null) {
            stringBuffer.append("<action>" + EscapedWriteTo.apply(this.m_action) + "</action>");
        }
        try {
            if (this.m_trustedEnvironmentVars.size() > 0) {
                Iterator iterator = SecurityBlob.createFromTrustedEnvVars(this.m_trustedEnvironmentVars);
                stringBuffer.append("<securityBlob xmlns=\"http://schemas.xmlsoap.org/soap/envelope/\">" + EscapedWriteTo.apply((String)((Object)iterator)) + "</securityBlob>");
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if (this.m_credentials.size() > 0) {
            int n;
            Vector vector;
            String string;
            stringBuffer.append("<credential>");
            for (Map.Entry entry : this.m_credentials.entrySet()) {
                string = (String)entry.getKey();
                vector = (Vector)entry.getValue();
                for (n = 0; n < vector.size(); ++n) {
                    stringBuffer.append("<" + string + ">" + EscapedWriteTo.apply((String)vector.elementAt(n)) + "</" + string + ">");
                }
            }
            for (Map.Entry entry : this.m_trustedCredentials.entrySet()) {
                string = (String)entry.getKey();
                vector = (Vector)entry.getValue();
                for (n = 0; n < vector.size(); ++n) {
                    stringBuffer.append("<" + string + ">" + EscapedWriteTo.apply((String)vector.elementAt(n)) + "</" + string + ">");
                }
            }
            stringBuffer.append("</credential>");
        }
        stringBuffer.append("</CAM>");
        this.toHeaderSessionString(stringBuffer);
        stringBuffer.append("</bus:biBusHeader>");
        return stringBuffer.toString();
    }

    public String toHeaderSessionString(StringBuffer stringBuffer) {
        if (this.m_cookieVars.size() > 0 || this.m_environmentVars.size() > 0 || this.m_formFields.size() > 0 || this.m_setCookieVars.size() > 0) {
            int n;
            Vector vector;
            Object object;
            stringBuffer.append("<bus:hdrSession xsi:type=\"bus:hdrSession\">");
            if (this.m_environmentVars.size() > 0) {
                stringBuffer.append("<bus:environmentVars xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"bus:environmentVar[]\">");
                for (Map.Entry entry : this.m_environmentVars.entrySet()) {
                    object = (String)entry.getKey();
                    vector = (Vector)entry.getValue();
                    for (n = 0; n < vector.size(); ++n) {
                        stringBuffer.append("<item><name>" + EscapedWriteTo.apply((String)object) + "</name><value>" + EscapedWriteTo.apply((String)vector.elementAt(n)) + "</value></item>");
                    }
                }
                stringBuffer.append("</bus:environmentVars>");
            }
            if (this.m_formFields.size() > 0) {
                stringBuffer.append("<bus:formFieldVars xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"bus:formFieldVar[]\">");
                for (Map.Entry entry : this.m_formFields.entrySet()) {
                    object = (String)entry.getKey();
                    vector = (Vector)entry.getValue();
                    for (n = 0; n < vector.size(); ++n) {
                        stringBuffer.append("<item><name>" + EscapedWriteTo.apply((String)object) + "</name><value>" + EscapedWriteTo.apply((String)vector.elementAt(n)) + "</value></item>");
                    }
                }
                stringBuffer.append("</bus:formFieldVars>");
            }
            if (this.m_cookieVars.size() > 0) {
                stringBuffer.append("<bus:cookieVars xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"bus:cookieVar[]\">");
                for (Map.Entry entry : this.m_cookieVars.entrySet()) {
                    object = (String)entry.getKey();
                    vector = (Vector)entry.getValue();
                    for (n = 0; n < vector.size(); ++n) {
                        stringBuffer.append("<item><name>" + EscapedWriteTo.apply((String)object) + "</name><value>" + EscapedWriteTo.apply((String)vector.elementAt(n)) + "</value></item>");
                    }
                }
                stringBuffer.append("</bus:cookieVars>");
            }
            if (this.m_setCookieVars.size() > 0) {
                stringBuffer.append("<bus:setCookieVars xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"bus:setCookieVar[]\">");
                for (Map.Entry entry : this.m_setCookieVars.entrySet()) {
                    object = (Vector)entry.getValue();
                    for (int i = 0; i < ((Vector)object).size(); ++i) {
                        SetCookieVar setCookieVar = (SetCookieVar)((Vector)object).elementAt(i);
                        stringBuffer.append("<item>");
                        stringBuffer.append("<name xsi:type=\"xsd:string\" xml:space=\"preserve\">" + EscapedWriteTo.apply(setCookieVar.getName()) + "</name>");
                        stringBuffer.append("<value xsi:type=\"xsd:string\" xml:space=\"preserve\">" + EscapedWriteTo.apply(setCookieVar.getValue()) + "</value>");
                        if (setCookieVar.getPath() != null && setCookieVar.getPath().length() >= 0) {
                            stringBuffer.append("<path xsi:type=\"xsd:string\" xml:space=\"preserve\">" + EscapedWriteTo.apply(setCookieVar.getPath()) + "</path>");
                        }
                        stringBuffer.append("<maxAge xsi:type=\"xsd:int\">" + setCookieVar.getMaxAge() + "</maxAge>");
                        if (setCookieVar.getDomain() != null && setCookieVar.getDomain().length() > 0) {
                            stringBuffer.append("<domain xsi:type=\"xsd:string\" xml:space=\"preserve\">" + EscapedWriteTo.apply(setCookieVar.getDomain()) + "</domain>");
                        }
                        if (setCookieVar.isSecure() != null) {
                            stringBuffer.append("<secure xsi:type=\"xsd:boolean\">" + setCookieVar.isSecure() + "</secure>");
                        }
                        stringBuffer.append("</item>");
                    }
                }
                stringBuffer.append("</bus:setCookieVars>");
            }
            stringBuffer.append("</bus:hdrSession>");
        }
        return stringBuffer.toString();
    }
}

