/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.CAM_AAA.authentication.proxy;

import com.cognos.CAM_AAA.authentication.ISearchExpression;
import com.cognos.CAM_AAA.authentication.ISearchFilter;
import com.cognos.CAM_AAA.authentication.ISearchStep;
import com.cognos.CAM_AAA.authentication.UnrecoverableException;
import com.cognos.CAM_AAA.authentication.proxy.SearchFilterConditionalExpression;
import com.cognos.CAM_AAA.authentication.proxy.SearchFilterFunctionCall;
import com.cognos.CAM_AAA.authentication.proxy.SearchFilterRelationalExpression;
import com.cognos.CAM_AAA.authentication.proxy.SearchStep;
import com.cognos.CAM_AAA.authentication.proxy.XmlTag;
import com.ibm.cognos.ccl4j.util.CCLXMLChar;
import java.util.Stack;
import java.util.Vector;

class SearchExpression
implements ISearchExpression {
    private String m_namespaceID = null;
    private String m_objectID = null;
    private Stack m_steps = new Stack();

    public SearchExpression(String string) throws UnrecoverableException {
        this.parseExpression(string);
    }

    public String getNamespaceID() {
        return this.m_namespaceID;
    }

    public String getObjectID() {
        return this.m_objectID;
    }

    public ISearchStep[] getSteps() {
        if (this.m_steps.isEmpty()) {
            return null;
        }
        ISearchStep[] iSearchStepArray = new ISearchStep[this.m_steps.size()];
        return this.m_steps.toArray(iSearchStepArray);
    }

    private static int skipWhitespaces(String string, int n) {
        int n2;
        for (n2 = n; n2 < string.length() && string.charAt(n2) == ' '; ++n2) {
        }
        return n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int parseQuotedValue(String string, int n, StringBuffer stringBuffer) throws UnrecoverableException {
        int n2 = n;
        stringBuffer.setLength(0);
        int n3 = SearchExpression.skipWhitespaces(string, n2);
        if (n3 <= 0) throw new UnrecoverableException("Internal Error", "Invalid search filter '" + string + "'. Parsing error near column " + n2);
        n2 = n3;
        if (string.charAt(n2) == '\'') {
            ++n2;
            boolean bl = false;
            do {
                if ((n3 = string.indexOf(39, n2)) <= 0) throw new UnrecoverableException("Internal Error", "Invalid search filter '" + string + "'. Parsing error near column " + n2);
                if (n3 + 1 >= string.length() || string.charAt(n3 + 1) != '\'') {
                    bl = true;
                } else {
                    ++n3;
                }
                stringBuffer.append(string.substring(n2, n3));
                n2 = n3 + 1;
            } while (!bl);
            return n2;
        } else if (string.indexOf("&apos;", n2) == n2) {
            n2 += 6;
            boolean bl = false;
            do {
                if ((n3 = string.indexOf("&apos;", n2)) <= 0) throw new UnrecoverableException("Internal Error", "Invalid search filter '" + string + "'. Parsing error near column " + n2);
                if (n3 + 6 >= string.length() || !string.startsWith("&apos;", n3 + 6)) {
                    bl = true;
                } else {
                    n3 += 6;
                }
                stringBuffer.append(string.substring(n2, n3));
                n2 = n3 + 6;
            } while (!bl);
            return n2;
        } else if (string.charAt(n2) == '\"') {
            ++n2;
            boolean bl = false;
            do {
                if ((n3 = string.indexOf(34, n2)) <= 0) throw new UnrecoverableException("Internal Error", "Invalid search filter '" + string + "'. Parsing error near column " + n2);
                if (n3 + 1 >= string.length() || string.charAt(n3 + 1) != '\"') {
                    bl = true;
                } else {
                    ++n3;
                }
                stringBuffer.append(string.substring(n2, n3));
                n2 = n3 + 1;
            } while (!bl);
            return n2;
        } else {
            if (string.indexOf("&quot;", n2) != n2) throw new UnrecoverableException("Internal Error", "Invalid search filter '" + string + "'. Parsing error near column " + n2);
            n2 += 6;
            boolean bl = false;
            do {
                if ((n3 = string.indexOf("&quot;", n2)) <= 0) throw new UnrecoverableException("Internal Error", "Invalid search filter '" + string + "'. Parsing error near column " + n2);
                if (n3 + 6 >= string.length() || !string.startsWith("&quot;", n3 + 6)) {
                    bl = true;
                } else {
                    n3 += 6;
                }
                stringBuffer.append(string.substring(n2, n3));
                n2 = n3 + 6;
            } while (!bl);
        }
        return n2;
    }

    private static int getEndOfToken(String string, int n) {
        int n2;
        for (n2 = n; n2 < string.length() && !CCLXMLChar.isSpace((int)string.charAt(n2)); ++n2) {
        }
        return n2;
    }

    private static int getEndOfNCName(String string, int n) {
        int n2 = n;
        if (CCLXMLChar.isNCNameStart((int)string.charAt(n2))) {
            ++n2;
            while (n2 < string.length() && !CCLXMLChar.isNCName((int)string.charAt(n2))) {
                ++n2;
            }
        }
        return n2;
    }

    private static int getAttribute(String string, int n) {
        int n2 = n;
        if (string.charAt(n2) == '@' && ++n2 < string.length() && CCLXMLChar.isNameStart((int)string.charAt(n2))) {
            ++n2;
            while (n2 < string.length() && CCLXMLChar.isName((int)string.charAt(n2))) {
                ++n2;
            }
        }
        return n2;
    }

    private static int getRelationalOperator(String string, int n) {
        int n2 = n;
        if (string.startsWith("=", n2)) {
            ++n2;
        } else if (string.startsWith("!=", n2)) {
            n2 += 2;
        } else if (string.startsWith("<=", n2)) {
            n2 += 2;
        } else if (string.startsWith("<", n2)) {
            ++n2;
        } else if (string.startsWith(">=", n2)) {
            n2 += 2;
        } else if (string.startsWith(">", n2)) {
            ++n2;
        }
        return n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseExpression(String string) throws UnrecoverableException {
        int n = SearchExpression.skipWhitespaces(string, 0);
        if (!string.startsWith("CAMID(", n)) throw new UnrecoverableException("Internal Error", "Invalid search filter '" + string + "'. Parsing error near column " + n);
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = SearchExpression.parseQuotedValue(string, n += 6, stringBuffer);
        if (n2 <= 0) throw new UnrecoverableException("Internal Error", "Invalid search filter '" + string + "'. Parsing error near column " + n);
        n = n2;
        if ((n2 = SearchExpression.skipWhitespaces(string, n2)) <= 0) throw new UnrecoverableException("Internal Error", "Invalid search filter '" + string + "'. Parsing error near column " + n);
        n = n2;
        if (string.charAt(n) != ')') throw new UnrecoverableException("Internal Error", "Invalid search filter '" + string + "'. Parsing error near column " + n);
        ++n;
        int n3 = stringBuffer.toString().indexOf(58, 0);
        if (n3 > 0) {
            this.m_namespaceID = stringBuffer.substring(0, n3);
            this.m_objectID = stringBuffer.substring(n3 + 1);
        } else {
            this.m_namespaceID = stringBuffer.toString();
        }
        if (n != string.length()) {
            while (true) {
                n3 = 7;
                Object object = null;
                if (n < string.length()) {
                    int n4;
                    int n5;
                    if (string.charAt(n) == '/') {
                        n5 = 0;
                        if (string.startsWith("..", ++n)) {
                            n3 = 6;
                            n5 = 1;
                            n += 2;
                        } else if (string.startsWith(".", n)) {
                            n3 = 7;
                            n5 = 1;
                            ++n;
                        } else if (string.startsWith("child::", n)) {
                            n3 = 3;
                            n += 7;
                        } else if (string.startsWith("descendant::", n)) {
                            n3 = 4;
                            n += 12;
                        } else if (string.startsWith("/", n)) {
                            n3 = 5;
                            ++n;
                        } else if (string.startsWith("descendant-or-self::", n)) {
                            n3 = 5;
                            n += 20;
                        } else {
                            n3 = 3;
                        }
                        if (n5 == 0) {
                            if (string.charAt(n2 = n++) != '*') {
                                n2 = SearchExpression.getEndOfNCName(string, n);
                                String string2 = string.substring(n, n2);
                                object = new SearchFilterRelationalExpression("=", XmlTag.ObjectClass, string2);
                                n = n2;
                            }
                            n4 = string.indexOf(91, n);
                            while (n4 > 0) {
                                int n6 = this.findEndOfFilter(string, n + 1);
                                if (n6 <= 0) throw new UnrecoverableException("Internal Error", "Invalid search filter '" + string + "'. Parsing error near column " + n);
                                String string3 = string.substring(n4 + 1, n6);
                                n = n6 + 1;
                                if (object == null) {
                                    object = this.parseSearchFilter(string3, 0);
                                } else {
                                    ISearchFilter[] iSearchFilterArray = new ISearchFilter[]{object, this.parseSearchFilter(string3, 0)};
                                    object = new SearchFilterConditionalExpression("and", iSearchFilterArray);
                                }
                                n4 = string.indexOf(91, n);
                            }
                        }
                        this.m_steps.add(new SearchStep(n3, (ISearchFilter)object));
                        continue;
                    }
                    if (string.charAt(n) == '[') {
                        n5 = string.indexOf(91, n);
                        while (n5 > 0) {
                            n4 = this.findEndOfFilter(string, n + 1);
                            if (n4 <= 0) throw new UnrecoverableException("Internal Error", "Invalid search filter '" + string + "'. Parsing error near column " + n);
                            String string4 = string.substring(n5 + 1, n4);
                            n = n4 + 1;
                            if (object == null) {
                                object = this.parseSearchFilter(string4, 0);
                            } else {
                                ISearchFilter[] iSearchFilterArray = new ISearchFilter[]{object, this.parseSearchFilter(string4, 0)};
                                object = new SearchFilterConditionalExpression("and", iSearchFilterArray);
                            }
                            n5 = string.indexOf(91, n);
                        }
                        this.m_steps.add(new SearchStep(n3, (ISearchFilter)object));
                        continue;
                    }
                }
                break;
            }
        } else {
            this.m_steps.add(new SearchStep(7, null));
        }
        if ((n = SearchExpression.skipWhitespaces(string, n)) == string.length()) return;
        throw new UnrecoverableException("Internal Error", "Invalid search filter '" + string + "'. Parsing error near column " + n);
    }

    private int findEndOfFilter(String string, int n) throws UnrecoverableException {
        int n2 = -1;
        boolean bl = false;
        char c = '\u0000';
        for (int i = n; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (c2 == ']' && !bl) {
                n2 = i;
                break;
            }
            if (c2 != '\'' && c2 != '\"') continue;
            if (!bl) {
                c = c2;
                bl = true;
                continue;
            }
            if (string.charAt(i - 1) == '\\' || c != c2) continue;
            bl = false;
        }
        return n2;
    }

    private ISearchFilter parseSearchFilter(String string, int n) throws UnrecoverableException {
        int n2;
        Object object = null;
        if (string != null && string.length() > 0 && (n2 = SearchExpression.skipWhitespaces(string, n)) >= n && n2 < string.length()) {
            if (string.charAt(n2) == '@') {
                String string2 = null;
                String string3 = null;
                StringBuffer stringBuffer = new StringBuffer();
                int n3 = SearchExpression.getAttribute(string, n2);
                string3 = string.substring(n2, n3);
                n2 = SearchExpression.skipWhitespaces(string, n3);
                if (n2 == -1) {
                    throw new UnrecoverableException("Internal Error", "Invalid search filter '" + string + "' : syntax error near pos " + n2);
                }
                n3 = SearchExpression.getRelationalOperator(string, n2);
                if (n3 == -1) {
                    throw new UnrecoverableException("Internal Error", "Invalid search filter '" + string + "' : syntax error near pos " + n2);
                }
                string2 = string.substring(n2, n3);
                n2 = SearchExpression.skipWhitespaces(string, n3);
                if (n2 == -1) {
                    throw new UnrecoverableException("Internal Error", "Invalid search filter '" + string + "' : syntax error near pos " + n2);
                }
                n3 = SearchExpression.parseQuotedValue(string, n2, stringBuffer);
                if (n3 == -1) {
                    throw new UnrecoverableException("Internal Error", "Invalid search filter '" + string + "' : syntax error near pos " + n2);
                }
                n2 = n3;
                object = new SearchFilterRelationalExpression(string2, string3, stringBuffer.toString());
                if ((n2 = SearchExpression.skipWhitespaces(string, n2)) < string.length()) {
                    n3 = SearchExpression.getEndOfToken(string, n2);
                    string2 = string.substring(n2, n3);
                    n2 = n3;
                    ISearchFilter[] iSearchFilterArray = new ISearchFilter[]{object, this.parseSearchFilter(string, n2)};
                    object = new SearchFilterConditionalExpression(string2, iSearchFilterArray);
                }
                return object;
            }
            String string4 = null;
            Vector<Object> vector = null;
            int n4 = string.indexOf(40, n2);
            if (n4 > 0) {
                Object object2;
                string4 = string.substring(n2, n4);
                n2 = n4 + 1;
                int n5 = string.indexOf(41, n2);
                if (n5 < 0) {
                    throw new UnrecoverableException("Internal Error", "Invalid search filter '" + string + "' : syntax error near pos " + n2);
                }
                if (n2 != n5) {
                    vector = new Vector<Object>();
                    while (true) {
                        if (string.charAt(n2 = SearchExpression.skipWhitespaces(string, n2)) == '@') {
                            n4 = SearchExpression.getAttribute(string, n2);
                            object2 = string.substring(n2, n4).trim();
                            vector.add(object2);
                        } else {
                            object2 = new StringBuffer();
                            n4 = SearchExpression.parseQuotedValue(string, n2, (StringBuffer)object2);
                            vector.add(((StringBuffer)object2).toString());
                        }
                        n2 = SearchExpression.skipWhitespaces(string, n4);
                        if (string.charAt(n2) != ',') break;
                        ++n2;
                    }
                }
                if (string.charAt(n2) != ')') {
                    throw new UnrecoverableException("Internal Error", "Invalid search filter '" + string + "' : syntax error near pos " + n2);
                }
                ++n2;
                object2 = null;
                if (vector.size() > 0) {
                    object2 = new String[vector.size()];
                    vector.toArray((T[])object2);
                }
                object = new SearchFilterFunctionCall(string4, (String[])object2);
                if ((n2 = SearchExpression.skipWhitespaces(string, n2)) < string.length()) {
                    int n6 = SearchExpression.getEndOfToken(string, n2);
                    String string5 = string.substring(n2, n6);
                    n2 = n6;
                    ISearchFilter[] iSearchFilterArray = new ISearchFilter[]{object, this.parseSearchFilter(string, n2)};
                    object = new SearchFilterConditionalExpression(string5, iSearchFilterArray);
                }
                return object;
            }
            throw new UnrecoverableException("Internal Error", "Invalid search filter '" + string + "' : syntax error near pos " + n2);
        }
        return object;
    }
}

