/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.archiving;

import com.cognos.cm.archiving.ArchivedDataConfigurationBuilder;
import com.cognos.cm.archiving.ArchivedPropertyFactory;
import com.cognos.cm.archiving.ExternalRepositoryWriter;
import com.cognos.cm.archiving.IArchivedDataConfiguration;
import com.cognos.cm.archiving.IArchivedDataConfigurationBuilder;
import com.cognos.cm.archiving.IArchivedPropertyFactory;
import com.cognos.cm.archiving.IExternalRepositoryWriter;
import com.cognos.cm.backgroundTask.BackgroundTaskErrorReporter;
import com.cognos.cm.backgroundTaskPluginAPI.IBackgroundTaskAction;
import com.cognos.cm.backgroundTaskPluginAPI.IBackgroundTaskExectutionContext;
import com.cognos.cm.backgroundTaskPluginAPI.IBackgroundTaskReporterHandler;
import com.cognos.cm.constants.ArchiveStatus;
import com.cognos.cm.contentTasks.actions.ArchivalTaskActionBuilder;
import com.cognos.cm.contentTasks.actions.IArchivalTaskActionBuilder;
import com.cognos.cm.contentTasks.cleanupTask.ArchivalTaskContext;
import com.cognos.cm.contentTasks.cleanupTask.ArchiveDataDescriptor;
import com.cognos.cm.contentTasks.cleanupTask.ContentObjectSelectionRule;
import com.cognos.cm.contentTasks.cleanupTask.ContentObjectSelectionRuleFactory;
import com.cognos.cm.contentTasks.cleanupTask.DescendantsContentFilter;
import com.cognos.cm.contentTasks.cleanupTask.IContentFilter;
import com.cognos.cm.contentTasks.cleanupTask.IContentObjectSet;
import com.cognos.cm.contentTasks.cleanupTask.IStoreWithLockManager;
import com.cognos.cm.contentTasks.cleanupTask.ITaskContext;
import com.cognos.cm.contentTasks.cleanupTask.ITaskErrorReporter;
import com.cognos.cm.contentTasks.cleanupTask.StoreWithLockManager;
import com.cognos.cm.contentTasks.cleanupTask.TaskSecurityContext;
import com.cognos.cm.dbstore.ArchiveStatusUpdater;
import com.cognos.cm.externalRepository.RepositoryConnectionProvider;
import com.cognos.cm.locking.ICMLockManager;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.properties.IRepositoryRules;
import com.cognos.cm.properties.RepositoryRules;
import com.cognos.cm.repositoryPluginAPI.IDataDescriptor;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.IArchiveStatusUpdater;
import com.cognos.cm.store.path.CMStoreParseException;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.store.path.ICMStorePath;
import com.cognos.cm.util.CMResourceUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;

public class ArchivalTaskAction
implements IBackgroundTaskAction {
    private static final int PERMISSIONS = 33280;
    private final RepositoryConnectionProvider repositoryConnectionProvider;
    private CMStore store;
    private ContentObjectSelectionRuleFactory ruleFactory;
    private ArchivalTaskContext archivalContext;
    private RepositoryRules repositoryRulesHelper;
    private IArchivedDataConfiguration archivedDataConfiguration;
    protected ArrayList<String> outputFormats;
    protected IArchiveStatusUpdater archiveStatusUpdater;

    public ArchivalTaskAction() {
        this(RepositoryConnectionProvider.getInstance());
    }

    ArchivalTaskAction(RepositoryConnectionProvider repositoryConnectionProvider) {
        this.repositoryConnectionProvider = repositoryConnectionProvider;
    }

    public void initialize(IBackgroundTaskExectutionContext context, Element runOptionsElement) throws Exception {
        this.createOutputFormatsFromRunOptionsElement(runOptionsElement);
        this.repositoryRulesHelper = this.createRepositoryRules();
        if (this.archiveStatusUpdater == null) {
            this.archiveStatusUpdater = this.getArchiveStatusUpdater();
        }
        this.archivedDataConfiguration = this.createArchivedDataConfiguration();
    }

    private void createOutputFormatsFromRunOptionsElement(Element runOptionsElement) {
        if (runOptionsElement != null) {
            Element outputFormatsElement = runOptionsElement.element("outputFormats");
            this.outputFormats = this.createOutputFormatsFromElement(outputFormatsElement);
        }
    }

    private ArrayList<String> createOutputFormatsFromElement(Element outputFormatsElment) {
        List outputFormatElements;
        if (outputFormatsElment != null && (outputFormatElements = outputFormatsElment.elements("outputFormat")) != null) {
            ArrayList<String> outputFormatsList = new ArrayList<String>();
            for (Element outputFormatElement : outputFormatElements) {
                outputFormatsList.add(outputFormatElement.getTextTrim());
            }
            return outputFormatsList;
        }
        return null;
    }

    protected IArchivedDataConfiguration createArchivedDataConfiguration() throws CMException {
        return this.createArchivedDataConfigurationBuilder().createConfiguration();
    }

    protected IArchivedDataConfigurationBuilder createArchivedDataConfigurationBuilder() {
        return new ArchivedDataConfigurationBuilder(this.createArchivedPropertyFactory(), CMResourceUtils.getResourceLoader());
    }

    protected IArchivedPropertyFactory createArchivedPropertyFactory() {
        return new ArchivedPropertyFactory();
    }

    protected IArchiveStatusUpdater getArchiveStatusUpdater() {
        return new ArchiveStatusUpdater();
    }

    protected RepositoryRules createRepositoryRules() {
        return new RepositoryRules();
    }

    public void setupExecute(IBackgroundTaskExectutionContext context) throws CMException {
        this.store = context.getCMExecutionContext().getStore();
        this.archivalContext = this.createArchivalTaskContext(context.getReporterHandler());
        this.ruleFactory = this.createContentObjectSelectionRuleFactory(this.store);
        this.repositoryConnectionProvider.cleanConnectionCache();
    }

    public void execute(IBackgroundTaskExectutionContext context, List<?> items) throws Exception {
        throw new UnsupportedOperationException("Batch execution is not supported");
    }

    public void execute(String objectSearchPath, IBackgroundTaskExectutionContext context, Object item) throws Exception {
        block9: {
            CMStoreXPath objectPath = new CMStoreXPath(objectSearchPath);
            CMStoreQueryResults queryResults = null;
            ICMLockManager lockManager = this.store.getLockManager();
            String repositoryConfigurationName = null;
            try {
                lockManager.requestLocks((ICMStorePath)objectPath);
                queryResults = this.store.executeQuery((ICMStorePath)objectPath, null, null, 0, 33280, null);
                lockManager.releaseLocks();
                if (!queryResults.next()) break block9;
                CMObjectClass objectClass = queryResults.getObjectClass();
                int tenantID = queryResults.getTenantID();
                if (objectClass.isArchivable()) {
                    repositoryConfigurationName = this.getRepositoryDataSourceName(objectSearchPath);
                    this.processArchivableClass(objectSearchPath, repositoryConfigurationName, tenantID);
                    break block9;
                }
                if (objectClass.isArchivableVersion()) {
                    repositoryConfigurationName = this.getRepositoryDataSourceName(objectSearchPath, objectClass);
                    this.processArchivableVersionClass(objectSearchPath, repositoryConfigurationName, tenantID);
                    break block9;
                }
                throw new CMException("cmArchivingUnsupportedObjectClass");
            }
            catch (CMException e) {
                throw this.createCMException(objectSearchPath, repositoryConfigurationName, e);
            }
            catch (Throwable t) {
                throw this.createCMException(objectSearchPath, repositoryConfigurationName, t);
            }
            finally {
                if (queryResults != null) {
                    queryResults.release();
                }
                lockManager.releaseLocks();
            }
        }
    }

    private void processArchivableVersionClass(String objectSearchPath, String repositoryConfigurationName, int tenantID) throws CMException, SQLException {
        ArrayList archivableClasses = this.store.getObjectClasses().getArchivableClasses();
        ContentObjectSelectionRule archivedOutputSelectionRule = this.ruleFactory.createObjectClassSelectionRule(this.ruleFactory.objectClassesListToNamesArray(archivableClasses));
        IContentFilter archivableDescendantClassesFilter = this.createDescendantsContentFilter(archivedOutputSelectionRule);
        IContentObjectSet archivableObjects = archivableDescendantClassesFilter.getObjects(objectSearchPath);
        while (archivableObjects.next()) {
            this.processArchivableClass(archivableObjects.getSearchPath(), repositoryConfigurationName, tenantID);
        }
    }

    protected IContentFilter createDescendantsContentFilter(ContentObjectSelectionRule archivedOutputSelectionRule) {
        return new DescendantsContentFilter(archivedOutputSelectionRule, (ITaskContext)this.archivalContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processArchivableClass(String objectSearchPath, String repositoryConfigurationName, int tenantID) throws CMException, SQLException {
        CMStoreXPath objectPath = new CMStoreXPath(objectSearchPath);
        CMStoreQueryResults queryResults = null;
        ICMLockManager lockManager = this.store.getLockManager();
        try {
            lockManager.requestLocks((ICMStorePath)objectPath);
            queryResults = this.store.executeQuery((ICMStorePath)objectPath, new CMProperty[]{CMProperty.FORMAT}, null, 0, 33280, null);
            if (queryResults.next()) {
                ArchiveStatus archiveStatus;
                int objectID = queryResults.getObjectID();
                String objectFormat = null;
                if (queryResults.getValue(0) != null) {
                    objectFormat = queryResults.getValue(0).toString();
                }
                if (this.isOutputFormatArchivable(objectFormat)) {
                    if (StringUtils.isNotEmpty((String)repositoryConfigurationName)) {
                        this.archiveArchivableClassObject(objectSearchPath, repositoryConfigurationName, tenantID);
                        archiveStatus = ArchiveStatus.ARCHIVED;
                        this.archivalContext.getTaskErrorReporter().reportSuccess("cmSaveToGivenRepositorySuccessMessage", this.createObjectParameters(objectSearchPath, repositoryConfigurationName));
                    } else {
                        archiveStatus = ArchiveStatus.NOREPOSITORYRULE;
                    }
                } else {
                    archiveStatus = ArchiveStatus.UNSUPPORTEDFORMAT;
                }
                this.archiveStatusUpdater.updateArchiveStatus(objectID, archiveStatus, this.store);
            }
        }
        finally {
            if (queryResults != null) {
                queryResults.release();
            }
            lockManager.releaseLocks();
        }
    }

    protected boolean isOutputFormatArchivable(String outputFormat) {
        if (this.outputFormats == null || this.outputFormats.size() == 0) {
            return true;
        }
        if (outputFormat == null) {
            return false;
        }
        Iterator<String> iterator = this.outputFormats.iterator();
        while (iterator.hasNext()) {
            if (!outputFormat.equalsIgnoreCase(iterator.next())) continue;
            return true;
        }
        return false;
    }

    private void archiveArchivableClassObject(String objectSearchPath, String repositoryConfigurationName, int tenantID) throws CMException {
        this.getRepositoryWriter(repositoryConfigurationName, tenantID).archiveArchivableClassObject(objectSearchPath);
    }

    private IExternalRepositoryWriter getRepositoryWriter(String repositoryConfigurationName, int tenantID) throws CMException, CMStoreParseException {
        IArchivalTaskActionBuilder builder = this.createArchivalTaskActionBuilder(this.archivalContext, repositoryConfigurationName);
        builder.initialize();
        IExternalRepositoryWriter repositoryWriter = this.createExternalRepositoryWriter(this.archivalContext, builder);
        repositoryWriter.initialize(this.archivedDataConfiguration, tenantID);
        return repositoryWriter;
    }

    protected IExternalRepositoryWriter createExternalRepositoryWriter(ArchivalTaskContext archivalContext, IArchivalTaskActionBuilder builder) {
        return new ExternalRepositoryWriter(archivalContext, builder);
    }

    protected IArchivalTaskActionBuilder createArchivalTaskActionBuilder(ArchivalTaskContext archivalContext, String archiveConfigurationName) {
        return new ArchivalTaskActionBuilder(archivalContext, archiveConfigurationName, this.repositoryConnectionProvider);
    }

    protected ContentObjectSelectionRuleFactory createContentObjectSelectionRuleFactory(CMStore store) {
        ContentObjectSelectionRuleFactory ruleFactory = new ContentObjectSelectionRuleFactory(store.getObjectClasses());
        return ruleFactory;
    }

    protected ArchivalTaskContext createArchivalTaskContext(IBackgroundTaskReporterHandler reporterHandler) {
        ICMLockManager lockManager = this.store.getLockManager();
        StoreWithLockManager storeWithLockManager = new StoreWithLockManager(this.store, lockManager);
        ArchivalTaskContext archivalContext = new ArchivalTaskContext();
        archivalContext.addTaskSecurityContext(new TaskSecurityContext(33280));
        archivalContext.addStoreWithLockManager((IStoreWithLockManager)storeWithLockManager);
        archivalContext.addTaskErrorReporter((ITaskErrorReporter)new BackgroundTaskErrorReporter(reporterHandler));
        archivalContext.addDataDescriptor((IDataDescriptor)new ArchiveDataDescriptor());
        return archivalContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRepositoryDataSourceName(String objectSearchPath, CMObjectClass objectClass) throws CMException {
        CMStoreXPath objectPath = new CMStoreXPath(objectSearchPath);
        ICMLockManager lockManager = this.store.getLockManager();
        try {
            lockManager.requestLocks((ICMStorePath)objectPath);
            String string = this.getRepositoryRulesHelper().getRepositoryDataSourceName((ICMStorePath)objectPath, objectClass);
            return string;
        }
        finally {
            lockManager.releaseLocks();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRepositoryDataSourceName(String objectSearchPath) throws CMException {
        CMStoreXPath objectPath = new CMStoreXPath(objectSearchPath);
        ICMLockManager lockManager = this.store.getLockManager();
        try {
            lockManager.requestLocks((ICMStorePath)objectPath);
            String string = this.getRepositoryRulesHelper().getRepositoryDataSourceName((ICMStorePath)objectPath);
            return string;
        }
        finally {
            lockManager.releaseLocks();
        }
    }

    protected IRepositoryRules getRepositoryRulesHelper() {
        return this.repositoryRulesHelper;
    }

    private CMException createCMException(String objectSearchPath, String repositoryConfigurationName, CMException cause) {
        CMException cmException = null;
        cmException = repositoryConfigurationName == null ? new CMException((Exception)((Object)cause), "cmSaveToRepositoryFailureMessage", this.createObjectParameters(objectSearchPath)) : new CMException((Exception)((Object)cause), "cmSaveToGivenRepositoryFailureMessage", this.createObjectParameters(objectSearchPath, repositoryConfigurationName));
        return cmException;
    }

    private CMException createCMException(String objectSearchPath, String repositoryConfigurationName, Throwable t) {
        CMException cmException = null;
        cmException = repositoryConfigurationName == null ? new CMException(t, "cmSaveToRepositoryFailureMessage", this.createObjectParameters(objectSearchPath)) : new CMException(t, "cmSaveToGivenRepositoryFailureMessage", this.createObjectParameters(objectSearchPath, repositoryConfigurationName));
        return cmException;
    }

    private CMException.Parm[] createObjectParameters(String objectSearchPath, String repositoryConfigurationName) {
        CMException.Parm[] parms = new CMException.Parm[]{new CMException.Parm("OBJECT", objectSearchPath), new CMException.Parm("REPOSITORY", repositoryConfigurationName)};
        return parms;
    }

    private CMException.Parm[] createObjectParameters(String objectSearchPath) {
        CMException.Parm[] parms = new CMException.Parm[]{new CMException.Parm("OBJECT", objectSearchPath)};
        return parms;
    }

    public void tearDown() {
        this.repositoryConnectionProvider.cleanConnectionCache();
    }
}

