/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.archiving;

import com.cognos.cm.backgroundTask.LogOnceReporterHandler;
import com.cognos.cm.backgroundTask.TaskLoggingSystemWrapper;
import com.cognos.cm.backgroundTaskPluginAPI.IBackgroundTaskMessage;
import com.cognos.cm.backgroundTaskPluginAPI.IBackgroundTaskReporterHandler;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cmutils.config.ConfigurationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;

public class ArchivalTaskReporterHandler
implements IBackgroundTaskReporterHandler {
    private static final String NO_DATASOURCE = "";
    protected static final String REPOSITORY_PARM = "REPOSITORY";
    private static final ArrayList<String> WRAPPER_EXCEPTION_CODES = new ArrayList<String>(Arrays.asList("cmSaveToGivenRepositoryFailureMessage", "cmSaveToRepositoryFailureMessage"));
    private Map<String, LogOnceReporterHandler> datasourceReporters;
    private String taskName;
    private Element options;

    public ArchivalTaskReporterHandler(String taskName, Element options) {
        this.taskName = taskName;
        this.options = options;
        this.datasourceReporters = new HashMap<String, LogOnceReporterHandler>();
    }

    public boolean reportActionException(Throwable throwable, IBackgroundTaskMessage backgroundTaskMessage, String objectType, String objectPath) {
        String datasourceName = this.getDatasourceName(throwable);
        LogOnceReporterHandler reporter = this.getDatasourceReporterHandler(datasourceName);
        boolean returnValue = reporter.reportActionException(throwable, backgroundTaskMessage, objectType, objectPath);
        if (datasourceName.equals(NO_DATASOURCE)) {
            reporter.reset();
        }
        return returnValue;
    }

    public boolean reportActionSuccess(IBackgroundTaskMessage backgroundTaskMessage) {
        return this.getDatasourceReporterHandler(this.getDatasourceName(backgroundTaskMessage)).reportActionSuccess(backgroundTaskMessage);
    }

    public boolean reportInformation(IBackgroundTaskMessage message) {
        return this.getDatasourceReporterHandler(this.getDatasourceName(message)).reportInformation(message);
    }

    public boolean reportTaskError(Throwable t, IBackgroundTaskMessage message) {
        String datasourceName = this.getDatasourceName(t);
        LogOnceReporterHandler reporter = this.getDatasourceReporterHandler(datasourceName);
        boolean returnValue = reporter.reportTaskError(t, message);
        if (datasourceName.equals(NO_DATASOURCE)) {
            reporter.reset();
        }
        return returnValue;
    }

    public boolean traceTaskMessage(IBackgroundTaskMessage backgroundTaskMessage) {
        return this.getDatasourceReporterHandler(this.getDatasourceName(backgroundTaskMessage)).traceTaskMessage(backgroundTaskMessage);
    }

    private LogOnceReporterHandler getDatasourceReporterHandler(String datasourceName) {
        LogOnceReporterHandler reporterHandler = this.datasourceReporters.get(datasourceName);
        if (reporterHandler == null) {
            try {
                reporterHandler = this.createDatasourceReportHandler(datasourceName);
            }
            catch (ConfigurationException e) {
                CMIndications.logThrowable((Throwable)e);
            }
            this.datasourceReporters.put(datasourceName, reporterHandler);
        }
        return reporterHandler;
    }

    protected LogOnceReporterHandler createDatasourceReportHandler(String datasourceName) throws ConfigurationException {
        return new DatasourceReporterHandler(datasourceName, this.taskName);
    }

    private String getDatasourceName(Throwable throwable) {
        String datasourceName = NO_DATASOURCE;
        if (throwable instanceof CMException) {
            CMException cmex = (CMException)throwable;
            CMException.Parm[] parms = cmex.getListExceptionParms_();
            datasourceName = this.getRepositoryParam(parms);
        }
        return datasourceName;
    }

    private String getDatasourceName(IBackgroundTaskMessage backgroundTaskMessage) {
        return this.getRepositoryParam(backgroundTaskMessage.getParms());
    }

    private String getRepositoryParam(CMException.Parm[] parms) {
        if (parms != null) {
            for (int i = 0; i < parms.length; ++i) {
                if (!parms[i].getName().equalsIgnoreCase(REPOSITORY_PARM)) continue;
                return parms[i].getValue();
            }
        }
        return NO_DATASOURCE;
    }

    public boolean reportStatus() {
        return false;
    }

    public class DatasourceReporterHandler
    extends LogOnceReporterHandler {
        private static final boolean USE_AUDITACCESS_INDICATION = true;
        private static final String DATASOURCE_OBJECTTYPE = "DATASOURCE";
        private static final String ARCHIVING_OPERATION = "Archiving";
        public static final String AUDIT_CATEGORY = "Audit.ECM";
        private String datasourceName;

        public DatasourceReporterHandler(String datasourceName, String taskName) throws ConfigurationException {
            super(taskName, ArchivalTaskReporterHandler.this.options, (List)WRAPPER_EXCEPTION_CODES, AUDIT_CATEGORY);
            this.datasourceName = datasourceName;
        }

        public DatasourceReporterHandler(String datasourceName, String taskName, TaskLoggingSystemWrapper logSys) throws ConfigurationException {
            super(taskName, ArchivalTaskReporterHandler.this.options, logSys, (List)WRAPPER_EXCEPTION_CODES, AUDIT_CATEGORY);
            this.datasourceName = datasourceName;
        }

        protected void printThrowableToAudit(Throwable throwable) {
            String[] vErrorMessages = null;
            if (throwable instanceof CMException) {
                CMException cmex = (CMException)throwable;
                vErrorMessages = new String[]{cmex.getFullMessageSys(false)};
            } else {
                vErrorMessages = new String[]{throwable.getMessage()};
            }
            CMExecutionContext.get().setIPFCategory(this.auditCategory);
            this.logSys_.audit(true, AUDIT_CATEGORY, this.getAuditMessageLevel(), ARCHIVING_OPERATION, null, DATASOURCE_OBJECTTYPE, this.datasourceName, "Failure", vErrorMessages);
        }

        protected void printSuccessToAudit(IBackgroundTaskMessage backgroundTaskMessage) {
            CMExecutionContext.get().setIPFCategory(this.auditCategory);
            this.logSys_.audit(true, AUDIT_CATEGORY, this.getAuditMessageLevel(), ARCHIVING_OPERATION, null, DATASOURCE_OBJECTTYPE, this.datasourceName, "Success", new String[]{backgroundTaskMessage.getMessage()});
            this.clearAuditFailures();
        }

        protected void printSuccessToTrace(IBackgroundTaskMessage backgroundTaskMessage) {
            super.printSuccessToTrace(backgroundTaskMessage);
            this.clearTraceFailures();
        }

        private int getAuditMessageLevel() {
            int ecmAuditLevel = this.getAuditLevel();
            if (ecmAuditLevel == 30000 || ecmAuditLevel == 20000 || ecmAuditLevel == 10000) {
                return 30000;
            }
            return 50000;
        }
    }
}

