/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.notification.observers;

import com.cognos.cm.backgroundTaskPluginAPI.ICMQueueManager;
import com.cognos.cm.constants.ArchiveStatus;
import com.cognos.cm.dbstore.ArchiveStatusUpdater;
import com.cognos.cm.indications.CMIndicationGlobals;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.notification.Notification;
import com.cognos.cm.notification.NotificationObserver;
import com.cognos.cm.notification.Subscription;
import com.cognos.cm.properties.IRepositoryRules;
import com.cognos.cm.properties.RepositoryRules;
import com.cognos.cm.queues.CMQueueManager;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreNotAvailable;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.CMStoreUnexpected;
import com.cognos.cm.store.IArchiveStatusUpdater;
import com.cognos.cm.store.path.CMStoreParseException;
import com.cognos.cm.store.path.CMStorePath;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.store.path.ICMStorePath;
import com.cognos.cm.util.ArchivingUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;

public class ArchiveOutputObserver
implements NotificationObserver {
    static final String OUTPUT_NOT_ADDED_ARCHIVING_TRIGGER_HAS_NO_VALUE = "Output not added to archive queue: Archiving Trigger has no value.";
    static final String OUTPUT_ADDED = "Output added to archive queue.";
    static final String OUTPUT_NOT_ADDED_NO_REPOSITORY_RULE = "Output not added to archive queue: No Repository Rule";
    static final String OUTPUT_ARCHIVABLE = "Output archivable";
    static final String OUTPUT_NOT_ARCHIVABLE = "Output not archivable";
    private IArchiveStatusUpdater archiveStatusUpdater;
    private boolean isRepositoryIntegrationInstalled_NeedsInitialValue = true;
    private boolean isRepositoryIntegrationInstalled;

    public void initialize(Subscription subscription) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotification(Notification notification) {
        boolean archivable = this.isArchivable(notification);
        String newOutputStoreID = notification.getStoreID();
        if (!this.isRepositoryIntegrationInstalled() || !archivable) {
            this.traceECMDebugText(OUTPUT_NOT_ARCHIVABLE, newOutputStoreID);
            return;
        }
        this.traceECMDebugText(OUTPUT_ARCHIVABLE, newOutputStoreID);
        if (this.archiveStatusUpdater == null) {
            this.archiveStatusUpdater = this.createArchiveStatusUpdater();
        }
        CMExecutionContext context = CMExecutionContext.get();
        CMExecutionContext.set((CMExecutionContext)notification.getOriginalExecutionContext());
        try {
            String newOutputSearchPath = CMStoreXPath.encodeStoreIdToPathString((String)newOutputStoreID);
            CMStoreXPath objectStorePath = new CMStoreXPath(newOutputSearchPath);
            if (!this.verifyRepositoryRules((CMStorePath)objectStorePath)) {
                this.updateItemArchiveStatus((CMStorePath)objectStorePath, ArchiveStatus.NOREPOSITORYRULE);
                this.traceECMDebugText(OUTPUT_NOT_ADDED_NO_REPOSITORY_RULE, newOutputStoreID);
                return;
            }
            if (this.hasArchivingTrigger(notification)) {
                this.putItemIntoQueue(newOutputSearchPath);
                this.traceECMDebugText(OUTPUT_ADDED, newOutputStoreID);
            } else if (this.isAdd(notification)) {
                this.updateItemArchiveStatus((CMStorePath)objectStorePath, ArchiveStatus.NOARCHIVINGTRIGGER);
                this.traceECMDebugText(OUTPUT_NOT_ADDED_ARCHIVING_TRIGGER_HAS_NO_VALUE, newOutputStoreID);
            }
        }
        catch (Throwable t) {
            CMIndications.logThrowable((Throwable)t);
        }
        finally {
            CMIndications.Audit_Access();
            CMExecutionContext.tearDown();
            CMExecutionContext.set((CMExecutionContext)context);
        }
    }

    private void traceECMDebugText(String message, String storeID) {
        if (CMIndicationGlobals.bECMDebugLogEnabled) {
            String traceMessage = message + " StoreID: " + storeID;
            CMIndications.CMTraceText((String)"Trace.CM.DBG.ECM", (int)10000, (String)traceMessage);
        }
    }

    private boolean isArchivable(Notification notification) {
        Map additionalParameters = notification.getAdditionalParameters();
        return !ArchivingUtil.isImport((Map)additionalParameters);
    }

    private boolean isRepositoryIntegrationInstalled() {
        if (this.isRepositoryIntegrationInstalled_NeedsInitialValue) {
            this.isRepositoryIntegrationInstalled = this.getRepositoryIntegrationInstallStatus();
            this.isRepositoryIntegrationInstalled_NeedsInitialValue = false;
        }
        return this.isRepositoryIntegrationInstalled;
    }

    protected boolean getRepositoryIntegrationInstallStatus() {
        ArchivingUtil archivingUtil = new ArchivingUtil();
        return archivingUtil.isRepositoryIntegrationInstalled();
    }

    private boolean hasArchivingTrigger(Notification notification) {
        Map additionalParameters = notification.getAdditionalParameters();
        return ArchivingUtil.getArchivingTriggerPropHasValue((Map)additionalParameters);
    }

    private boolean isAdd(Notification notification) {
        Map additionalParameters = notification.getAdditionalParameters();
        return ArchivingUtil.isAdd((Map)additionalParameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateItemArchiveStatus(CMStorePath objectStorePath, ArchiveStatus status) throws CMException, CMStoreNotAvailable, CMStoreUnexpected, SQLException {
        CMStoreQueryResults results = null;
        CMStore store = this.getStore();
        try {
            store.beginTransaction();
            results = store.executeQuery((ICMStorePath)objectStorePath, null, null, 0, 0, null);
            if (results.next()) {
                this.archiveStatusUpdater.updateArchiveStatus(results.getObjectID(), status, store);
                store.commitTransaction();
            }
        }
        finally {
            if (results != null) {
                results.release();
            }
            if (store.inTransaction()) {
                store.rollbackTransaction();
            }
        }
    }

    private CMStore getStore() throws CMStoreNotAvailable, CMStoreUnexpected {
        return CMExecutionContext.get().getStore();
    }

    protected IArchiveStatusUpdater createArchiveStatusUpdater() {
        return new ArchiveStatusUpdater();
    }

    private boolean verifyRepositoryRules(CMStorePath objectStorePath) throws CMStoreParseException, CMException {
        IRepositoryRules rules = this.createRepositoryRulesHelper();
        return rules.hasRepositoryRule((ICMStorePath)objectStorePath);
    }

    protected IRepositoryRules createRepositoryRulesHelper() {
        return new RepositoryRules();
    }

    private void putItemIntoQueue(String newOutputSearchPath) throws CMException {
        this.getQueueManager().put(this.getStore(), newOutputSearchPath, "archive", null);
    }

    protected ICMQueueManager getQueueManager() {
        return CMQueueManager.getManager();
    }

    public void addNotifications(ArrayList<Notification> notifications) {
        for (Notification notification : notifications) {
            this.addNotification(notification);
        }
    }

    public void enable(boolean enable) {
    }
}

