/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.client;

import com.cognos.cm.client.ClientServicePipe;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;

public abstract class AbstractSOAPPipe
implements ClientServicePipe {
    private String url;
    private InputStream in;
    private HttpServletResponse response;
    private HttpServletRequest request;
    private static Set<String> ignoreHeader = new HashSet<String>();
    private HttpClient httpClient;

    public AbstractSOAPPipe(String url, HttpServletRequest request, HttpServletResponse response, HttpClient httpClient) throws IOException {
        this.url = url;
        this.request = request;
        this.response = response;
        this.in = request.getInputStream();
        this.httpClient = httpClient;
    }

    protected void setResponseHeaders(HttpMethod method) {
        Header[] headers;
        for (Header header : headers = method.getResponseHeaders()) {
            this.response.addHeader(header.getName(), header.getValue());
        }
    }

    protected HttpMethod getHTTPMethod() {
        PostMethod post = new PostMethod(this.url);
        InputStreamRequestEntity entity = new InputStreamRequestEntity(this.in, this.request.getContentType());
        post.setRequestEntity((RequestEntity)entity);
        this.setRequestHeaderData(post);
        return post;
    }

    private void setRequestHeaderData(PostMethod post) {
        Enumeration headerNames = this.request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            if (!this.propogateHeader(headerName)) continue;
            post.setRequestHeader(headerName, this.request.getHeader(headerName));
        }
    }

    private boolean propogateHeader(String headerName) {
        return !ignoreHeader.contains(headerName.toLowerCase());
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    static {
        ignoreHeader.add("transfer-encoding");
    }
}

