/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.client;

import com.cognos.cmutils.tempcache.CMTempDataReaderWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;

public class CMTempDataReaderDualWriter
extends CMTempDataReaderWriter {
    private OutputStream outputStream;
    private OutputStreamWriter outputStreamWriter;

    public CMTempDataReaderDualWriter(InputStream inputStream, OutputStream outputStream) {
        super(inputStream);
        this.outputStream = outputStream;
    }

    public CMTempDataReaderDualWriter(Reader reader, OutputStreamWriter outputStreamWriter) {
        super(reader);
        this.outputStreamWriter = outputStreamWriter;
    }

    public void writeChunk(int numRead) throws Exception {
        super.writeChunk(numRead);
        if (this.isReader()) {
            this.outputStreamWriter.write(this.getBufferCharacters(), 0, numRead);
        } else if (this.isInputStream()) {
            this.outputStream.write(this.getBufferBytes(), 0, numRead);
        }
    }

    public void flush() throws IOException {
        super.flush();
        if (this.isReader()) {
            this.outputStreamWriter.flush();
        } else if (this.isInputStream()) {
            this.outputStream.flush();
        }
    }

    public void close() throws IOException {
        super.close();
        if (this.isReader()) {
            if (this.outputStreamWriter != null) {
                this.outputStreamWriter.close();
            }
        } else if (this.isInputStream() && this.outputStream != null) {
            this.outputStream.close();
        }
    }
}

