/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.client;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cm.client.GetDataPipe;
import com.cognos.cm.client.ResponseImpl;
import com.cognos.cm.client.TempDataCache;
import com.cognos.cm.client.TempDataCacheCMImpl;
import com.cognos.cm.client.config.DispatcherConfigHelper;
import com.cognos.cm.client.enabler.ViewerEnhancementSwitch;
import com.cognos.cmutils.http.HttpClientFactoryProvider;
import com.cognos.cmutils.http.HttpMethodFactory;
import com.cognos.cmutils.setting.Fetcher;
import com.cognos.cmutils.setting.SettingInteger;
import com.cognos.cmutils.setting.SystemPropertyFetcher;
import com.cognos.pogo.handlers.contentmanager.GzippedSearchPathExpander;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.Handler;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.transport.url2soap.InputStruct;
import com.cognos.pogo.transport.url2soap.ParameterList;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dom4j.Element;

public class GetDataHandler
implements Handler {
    private String name;
    private TempDataCache pdfTempCache;
    private Configuration config;
    private File tempDir;
    private PogoEngine engine;
    private DispatcherConfigHelper dispConfig;
    public static final String HTTP_SERVLET_REQUEST = "http_servlet_request";
    public static final String SEARCH_PATH_KEY = "search";
    public static final String MSG_CONTEXT_SERVLET_RESPONSE = "servlet.response";
    public static final String MSG_CONTEXT_PATH_INFO = "path_info";
    public static final String MSG_CONTEXT_URL_TO_SOAP_PARAM = "request.URL2SOAPParameterList";
    public static final String CONFIG_PARAM_CM_URL = "contentManager";
    public static final String PROPERTY_FILE_NAME = "getdatahandler.properties";

    public GetDataHandler() {
        this.setDispatcherConfigHelper(new DispatcherConfigHelper());
    }

    protected void setDispatcherConfigHelper(DispatcherConfigHelper helper) {
        this.dispConfig = helper;
    }

    public void allServicesStarted() {
    }

    public void compose(PogoEngine engine) throws PogoException {
        this.engine = engine;
    }

    public void configure(Configuration config) {
        this.config = config;
        this.tempDir = new File(this.getConfigValue("temp"));
        this.setupTempFileCache();
        this.dispConfig.init(this.engine);
        if (ViewerEnhancementSwitch.isEnhancementsEnabled(config, PROPERTY_FILE_NAME)) {
            this.dispConfig.enableCMViewerEnhancements();
        }
    }

    private String getConfigValue(String key) {
        ICCLConfiguration cclConfig = this.config.getICCLConfiguration();
        try {
            return cclConfig.getValue(key, false);
        }
        catch (CCLConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    private void setupTempFileCache() {
        boolean isZeroCacheSize;
        SettingInteger taskDataCacheMaxK = new SettingInteger(Integer.valueOf(1000000), new Fetcher[]{new SystemPropertyFetcher("com.cognos.cm.client.GetDataHandler.CacheSize")});
        boolean bl = isZeroCacheSize = taskDataCacheMaxK.getValue() == 0;
        if (this.pdfTempCache == null && !isZeroCacheSize) {
            this.pdfTempCache = new TempDataCacheCMImpl(this.tempDir);
        } else if (isZeroCacheSize) {
            if (this.pdfTempCache != null) {
                this.pdfTempCache.emptyCache();
            }
            this.pdfTempCache = null;
        }
    }

    public void contextualize(Element arg0) throws PogoException {
    }

    public void dispose() {
    }

    public String getName() {
        return this.name;
    }

    public void initialize() {
    }

    public void invoke(MessageContext context) throws PogoException {
        String searchPath = this.getSearchPath(context);
        if (searchPath == null) {
            throw new RuntimeException("Could not decode gd request");
        }
        if (searchPath.matches(";?storeID[(]['\"]i.{32}['\"][)]")) {
            searchPath = this.getStoreId(searchPath);
        }
        Map<String, String> reqHeaders = this.getRequestHeaders(context);
        HttpServletResponse servletRsp = (HttpServletResponse)context.getProperty(MSG_CONTEXT_SERVLET_RESPONSE);
        ResponseImpl response = new ResponseImpl(servletRsp);
        String cmURL = this.config.getValue(CONFIG_PARAM_CM_URL);
        String p2pdURL = cmURL.replaceFirst("/servlet", "");
        try {
            HttpMethodFactory httpPipe = this.getHttpPipe(p2pdURL);
            GetDataPipe dataPipe = new GetDataPipe(httpPipe, this.pdfTempCache);
            dataPipe.getData(searchPath, reqHeaders, response);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Map<String, String> getRequestHeaders(MessageContext context) {
        HttpServletRequest request = (HttpServletRequest)context.getProperty(HTTP_SERVLET_REQUEST);
        Enumeration reqHeaderNamesEnum = request.getHeaderNames();
        HashMap<String, String> reqHeaders = new HashMap<String, String>();
        while (reqHeaderNamesEnum.hasMoreElements()) {
            Object reqHeaderNameObj = reqHeaderNamesEnum.nextElement();
            String reqHeaderName = reqHeaderNameObj.toString();
            String reqHeaderVal = request.getHeader(reqHeaderName);
            reqHeaders.put(reqHeaderName, reqHeaderVal);
        }
        return reqHeaders;
    }

    private String getStoreId(String searchPath) {
        List<String> tokens = this.tokenize(searchPath, "\"'");
        String storeId = null;
        if (tokens.size() >= 2) {
            storeId = tokens.get(1);
        }
        return storeId;
    }

    private String getSearchPath(MessageContext context) {
        List<String> tokens;
        String searchPath = null;
        String pathInfo = (String)context.getProperty(MSG_CONTEXT_PATH_INFO);
        ParameterList params = (ParameterList)context.getProperty(MSG_CONTEXT_URL_TO_SOAP_PARAM);
        if (params != null) {
            ListIterator iterator = params.listIterator();
            while (iterator.hasNext() && searchPath == null) {
                InputStruct param = (InputStruct)iterator.next();
                if (!SEARCH_PATH_KEY.equals(param.getName())) continue;
                searchPath = param.getValue();
            }
        }
        if (searchPath == null && (tokens = this.tokenize(pathInfo, "/")).size() > 1) {
            searchPath = this.decodeSearchPath(tokens.get(1));
        }
        return searchPath;
    }

    private String decodeSearchPath(String str) {
        String searchPath;
        GzippedSearchPathExpander decoder = new GzippedSearchPathExpander(str);
        try {
            searchPath = decoder.getSearchPath();
        }
        catch (UnsupportedEncodingException e) {
            searchPath = null;
        }
        catch (IOException e) {
            searchPath = null;
        }
        return searchPath;
    }

    private List<String> tokenize(String pathInfo, String delims) {
        ArrayList<String> tokens = new ArrayList<String>();
        StringTokenizer toker = new StringTokenizer(pathInfo, delims);
        while (toker.hasMoreElements()) {
            tokens.add(toker.nextToken());
        }
        return tokens;
    }

    protected HttpMethodFactory getHttpPipe(String url) throws IOException {
        return HttpClientFactoryProvider.getInstance().getHttpMethodFactory(url);
    }

    public void reconfigure(Configuration arg0) {
    }

    public void resume() {
    }

    public void setName(String name) {
        this.name = name;
    }

    public void start() {
    }

    public void stop() {
    }

    public void suspend() {
    }

    public void suspend(boolean arg0) {
    }
}

