/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.client;

import com.cognos.cm.client.CMObjectsAPI;
import com.cognos.cm.client.Response;
import com.cognos.cm.client.TempDataCache;
import com.cognos.cm.client.mbean.ClientCacheCounter;
import com.cognos.cm.client.mbean.ClientCacheCounterMBean;
import com.cognos.cmutils.http.HttpMethodFactory;
import com.cognos.cmutils.io.CMStreamUtils;
import com.cognos.cmutils.tempcache.CMTempFile;
import com.cognos.pogo.monitoring.jmx.PogoMBeanServer;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class GetDataPipe {
    public static final String ETAG = "ETag";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String CONTENT_DISPOSITION = "Content-Disposition";
    public static final String CONTENT_ENCODING = "Content-Encoding";
    public static final String CONTENT_TRANSFER_ENCODING = "Content-Transfer-Encoding";
    public static final String IF_NONE_MATCH = "If-None-Match";
    public static final String CONTENT_LENGTH = "Content-Length";
    public static final String[] MANADATORY_HEADER_NAMES = new String[]{"Content-Type", "ETag", "Content-Disposition", "Content-Length"};
    public static final String[] OPTIONAL_HEADER_NAMES = new String[]{"Content-Encoding", "Content-Transfer-Encoding"};
    public static final Set<String> MANDATORY_HEADER_NAMES_SET = new HashSet<String>(Arrays.asList(MANADATORY_HEADER_NAMES));
    public static final Set<String> STORED_HEADER_NAMES_SET = GetDataPipe.getStoredHeaderNameSet();
    public static final String MBEAN_COUNTER_PACKAGE = "com.cognos.cm.client";
    public static final String MBEAN_MISS_COUNTER = "cacheMissCounter";
    public static final String MBEAN_HIT_COUNTER = "cacheHitCounter";
    public static final long CONTENT_LENGTH_DEFAULT_VAL = -1L;
    private static Logger logger = Hierarchy.getDefaultHierarchy().getLoggerFor(GetDataPipe.class.getName());
    private static ClientCacheCounterMBean cacheMissCounter = GetDataPipe.getCacheCounterMBean("cacheMissCounter");
    private static ClientCacheCounterMBean cacheHitCounter = GetDataPipe.getCacheCounterMBean("cacheHitCounter");
    private HttpMethodFactory p2pdPipe;
    private TempDataCache cache;

    public GetDataPipe(HttpMethodFactory pipe) {
        this(pipe, null);
    }

    public GetDataPipe(HttpMethodFactory pipe, TempDataCache cache) {
        this.p2pdPipe = pipe;
        this.cache = cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getData(String searchPath, Map<String, String> reqHeaders, Response response) throws IOException {
        CMTempFile tempFile = this.hasCache() ? this.cache.getCachedFile(searchPath) : null;
        HttpMethod method = null;
        try {
            String etag = this.getEtag(tempFile);
            logger.debug("getEtag(" + searchPath + ") returned: " + etag);
            method = this.executeGet(CMObjectsAPI.toUrl(searchPath, "data"), reqHeaders, etag);
            this.copyHeaders(method, response);
            switch (method.getStatusCode()) {
                case 304: {
                    this.cacheHit(tempFile, response);
                    break;
                }
                case 200: {
                    tempFile = this.cacheMiss(tempFile, response, method, searchPath);
                    break;
                }
                default: {
                    this.error(response, method);
                }
            }
            this.quietRelease(method);
            this.quietRelease(tempFile);
        }
        catch (Throwable throwable) {
            this.quietRelease(method);
            this.quietRelease(tempFile);
            throw throwable;
        }
    }

    private void quietRelease(HttpMethod method) {
        if (method != null) {
            method.releaseConnection();
        }
    }

    private void quietRelease(CMTempFile tempFile) {
        if (tempFile != null) {
            tempFile.release();
        }
    }

    private void error(Response response, HttpMethod method) throws IOException {
        InputStream is = method.getResponseBodyAsStream();
        this.copyToResponse(is, response, null);
        logger.debug("the get data operation was not successful.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CMTempFile cacheMiss(CMTempFile tempFile, Response response, HttpMethod method, String searchPath) throws IOException {
        long startTime = System.nanoTime();
        long dataLength = -1L;
        try {
            InputStream is = method.getResponseBodyAsStream();
            this.copyToResponse(is, response, searchPath);
            if (this.hasCache()) {
                if (tempFile != null) {
                    tempFile.release();
                }
                tempFile = this.cache.getCachedFile(searchPath);
                this.storeResponseHeadersInCache(tempFile, method);
            }
            dataLength = this.getContentLength(method);
            logger.debug("cache miss. Queried CM for storeId " + searchPath);
        }
        finally {
            long timeDiff = System.nanoTime() - startTime;
            cacheMissCounter.addData(timeDiff, dataLength);
        }
        return tempFile;
    }

    private void cacheHit(CMTempFile tmpFile, Response response) throws IOException {
        InputStream in = null;
        long startTime = System.nanoTime();
        long dataLength = -1L;
        try {
            for (String headerName : STORED_HEADER_NAMES_SET) {
                Object headerVal = tmpFile.getMetadata(headerName);
                if (headerVal != null) {
                    response.setHeader(headerName, headerVal.toString());
                    continue;
                }
                if (!MANDATORY_HEADER_NAMES_SET.contains(headerName)) continue;
                String errMsg = "An expected cached header '" + headerName + "' was missing.";
                throw new RuntimeException(errMsg);
            }
            dataLength = tmpFile.getLength();
            in = tmpFile.getInputStream();
            this.copyToResponse(in, response, null);
            logger.debug("cache hit.");
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        finally {
            long timeDiff = System.nanoTime() - startTime;
            cacheHitCounter.addData(timeDiff, dataLength);
            CMStreamUtils.quietClose((InputStream)in);
        }
    }

    private void copyToResponse(InputStream is, Response response, String key) throws IOException {
        OutputStream os = response.getOutputStream();
        int bufferSize = 8192;
        if (key != null && this.hasCache()) {
            this.cache.transfer(key, is, os);
        } else {
            CMStreamUtils.copyStream((InputStream)is, (OutputStream)os, (int)8192);
        }
    }

    private void storeResponseHeadersInCache(CMTempFile tmpFile, HttpMethod method) {
        if (tmpFile != null) {
            for (String headerName : STORED_HEADER_NAMES_SET) {
                Header header = method.getResponseHeader(headerName);
                if (header != null) {
                    tmpFile.setMetadata(headerName, (Object)header.getValue());
                    continue;
                }
                if (!MANDATORY_HEADER_NAMES_SET.contains(headerName)) continue;
                StringBuffer errMsg = new StringBuffer("An expected header '");
                errMsg.append(headerName);
                errMsg.append("' was missing during caching.");
                throw new RuntimeException(errMsg.toString());
            }
        }
    }

    private String getEtag(CMTempFile tempFile) {
        Object validatorObj;
        String validator = null;
        if (tempFile != null && (validatorObj = tempFile.getMetadata(ETAG)) != null) {
            validator = validatorObj.toString();
        }
        return validator;
    }

    private HttpMethod executeGet(String uri, Map<String, String> reqHeaders, String cacheValidator) {
        int httpCode;
        HttpMethod method = this.p2pdPipe.get(uri);
        for (Map.Entry<String, String> reqHeader : reqHeaders.entrySet()) {
            method.addRequestHeader(reqHeader.getKey(), reqHeader.getValue());
        }
        if (cacheValidator != null) {
            method.setRequestHeader(IF_NONE_MATCH, cacheValidator);
        } else {
            method.removeRequestHeader(IF_NONE_MATCH);
        }
        try {
            httpCode = this.p2pdPipe.execute(method);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        logger.info("request for '" + uri + "' returned: " + httpCode);
        return method;
    }

    private void copyHeaders(HttpMethod src, Response dst) {
        Header[] headers;
        for (Header header : headers = src.getResponseHeaders()) {
            dst.setHeader(header.getName(), header.getValue());
        }
    }

    private boolean hasCache() {
        return this.cache != null;
    }

    private long getContentLength(HttpMethod method) {
        Header header = method.getResponseHeader(CONTENT_LENGTH);
        String lengthStr = header == null ? null : header.getValue();
        long dataLength = lengthStr == null ? -1L : Long.parseLong(lengthStr);
        return dataLength;
    }

    private static Set<String> getStoredHeaderNameSet() {
        HashSet<String> storedHeaderNameSet = new HashSet<String>();
        storedHeaderNameSet.addAll(MANDATORY_HEADER_NAMES_SET);
        storedHeaderNameSet.addAll(Arrays.asList(OPTIONAL_HEADER_NAMES));
        return storedHeaderNameSet;
    }

    private static ClientCacheCounterMBean getCacheCounterMBean(String counterName) {
        ClientCacheCounter cacheMissCounter = null;
        try {
            ObjectName cacheMissName = new ObjectName("com.cognos.cm.client:type=" + counterName);
            cacheMissCounter = new ClientCacheCounter();
            if (!PogoMBeanServer.isNoJMX()) {
                MBeanServer mbs = PogoMBeanServer.getInstance().getProxyMBeanServer();
                mbs.registerMBean(cacheMissCounter, cacheMissName);
            }
        }
        catch (Exception e) {
            logger.error("Cannot register ClientCacheCounterMBean", (Throwable)e);
        }
        return cacheMissCounter;
    }
}

