/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.client;

import com.cognos.cm.client.AbstractSOAPPipe;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;

public class StreamingSOAPPipe
extends AbstractSOAPPipe {
    public StreamingSOAPPipe(String url, HttpServletRequest request, HttpServletResponse response, HttpClient httpClient) throws IOException {
        super(url, request, response, httpClient);
    }

    @Override
    public void start() {
        HttpMethod method = null;
        try {
            method = this.getHTTPMethod();
            ServletOutputStream os = super.getResponse().getOutputStream();
            InputStream responseStream = this.executeRequest(method);
            this.setResponseHeaders(method);
            this.writeResponse((OutputStream)os, responseStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    private void writeResponse(OutputStream os, InputStream responseStream) throws IOException {
        if (responseStream != null) {
            int bytesRead = 4096;
            byte[] bytes = new byte[bytesRead];
            while (bytesRead > 0) {
                bytesRead = responseStream.read(bytes);
                os.write(bytes, 0, bytesRead);
            }
        }
        os.flush();
    }

    private InputStream executeRequest(HttpMethod post) throws IOException, HttpException {
        int responseCode = this.getHttpClient().executeMethod(post);
        InputStream responseStream = post.getResponseBodyAsStream();
        this.getResponse().setStatus(responseCode);
        return responseStream;
    }
}

