/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.client;

import com.cognos.cm.client.CMTempDataReaderDualWriter;
import com.cognos.cm.client.TempDataCache;
import com.cognos.cmutils.config.ConfigurationException;
import com.cognos.cmutils.tempcache.CMTempDataReaderWriter;
import com.cognos.cmutils.tempcache.CMTempFile;
import com.cognos.cmutils.tempcache.CMTempFileFactory;
import com.cognos.cmutils.tempcache.CMTempFileLRUCacheBase;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class TempDataCacheCMImpl
implements TempDataCache {
    private Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor(TempDataCacheCMImpl.class.getName());
    private CMTempFileLRUCacheBase cache;

    public TempDataCacheCMImpl(File tmpDir) {
        File cmTmpDir = new File(tmpDir, "cm-client");
        cmTmpDir.mkdirs();
        CMTempFileFactory tempFileFactory = new CMTempFileFactory("GD_", cmTmpDir);
        int MAXSIZE_100MB = 0x6400000;
        int MAXLIFE_30MINS = 30;
        this.cache = new CMTempFileLRUCacheBase(tempFileFactory, 0x6400000, 30);
    }

    protected TempDataCacheCMImpl(CMTempFileLRUCacheBase cache) {
        this.cache = cache;
    }

    @Override
    public void transfer(Object key, InputStream is, OutputStream os) throws IOException {
        long nanos = System.nanoTime();
        CMTempDataReaderDualWriter dualWriter = new CMTempDataReaderDualWriter(is, os);
        try {
            this.cache.add(key, (CMTempDataReaderWriter)dualWriter, null, false);
        }
        catch (ConfigurationException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            nanos = System.nanoTime() - nanos;
        }
        this.log.info("transfered " + key.toString() + " from cache in " + (double)nanos / 1000000.0 + " milliseconds");
    }

    @Override
    public CMTempFile getCachedFile(Object key) {
        return this.cache.get(key);
    }

    @Override
    public void removeFromCache(Object key) {
        this.cache.remove(key);
    }

    @Override
    public void emptyCache() {
        this.cache.removeAll();
    }
}

