/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.client.cmapi;

import com.cognos.cm.client.cmapi.HttpCommand;
import com.cognos.cm.client.cmapi.HttpCommandImpl;
import com.cognos.cmutils.http.HttpMethodFactory;
import com.cognos.pogo.pdk.MessageContext;
import javax.mail.internet.InternetHeaders;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class HttpCommandFactory {
    public static final String X_CA_AUTHORIZATION = "X-CA-Authorization";
    private static final String CAM_PASSPORT_COOKIE = "cam_passport";
    private HttpMethodFactory httpMethodFactory;

    public HttpCommandFactory(HttpMethodFactory provider) {
        this.httpMethodFactory = provider;
    }

    @Deprecated
    public HttpCommand getCommand(Cookie camPassport, String uri) {
        HttpCommandImpl command = new HttpCommandImpl(this.httpMethodFactory, uri);
        if (camPassport != null) {
            command.setCookie(CAM_PASSPORT_COOKIE, camPassport.getValue());
        }
        return command;
    }

    public HttpCommand getCommand(MessageContext mc, String uri) {
        HttpCommandImpl command = new HttpCommandImpl(this.httpMethodFactory, uri);
        this.setCamPassportCookie(mc, command);
        this.setTrustToken(mc, command);
        return command;
    }

    private void setCamPassportCookie(MessageContext mc, HttpCommand command) {
        Cookie[] cookies;
        String auth_passport_id = (String)HttpCommandFactory.getProperty(mc, "auth.passportid");
        if (auth_passport_id != null) {
            command.setCookie(CAM_PASSPORT_COOKIE, auth_passport_id);
            return;
        }
        HttpServletRequest request = (HttpServletRequest)HttpCommandFactory.getProperty(mc, "http_servlet_request");
        Cookie[] cookieArray = cookies = request == null ? null : request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(CAM_PASSPORT_COOKIE)) continue;
                command.setCookie(CAM_PASSPORT_COOKIE, cookie.getValue());
                return;
            }
        }
    }

    private void setTrustToken(MessageContext mc, HttpCommand command) {
        String trustToken;
        InternetHeaders headers = (InternetHeaders)HttpCommandFactory.getProperty(mc, "request.headers");
        String string = trustToken = headers == null ? null : headers.getHeader(X_CA_AUTHORIZATION, null);
        if (trustToken != null) {
            command.setRequestHeader(X_CA_AUTHORIZATION, trustToken);
        }
    }

    private static <T> T getProperty(MessageContext mc, String name) {
        return (T)mc.getProperty(name);
    }
}

