/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.client.cmapi;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.cm.client.cmapi.HttpCommand;
import com.cognos.cmutils.http.HttpMethodFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import javax.servlet.http.Cookie;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.StatusLine;

public class HttpCommandImpl
implements HttpCommand {
    private final HttpMethodFactory methodFactory;
    private HttpMethod method;
    private String responseBody;
    private ArrayList<Cookie> cookies = new ArrayList();

    public HttpCommandImpl(HttpMethodFactory httpMethodFactory, String servletUri) {
        this.methodFactory = httpMethodFactory;
        this.method = httpMethodFactory.get(servletUri);
    }

    @Override
    public int execute() throws IOException, CAMCryptoException {
        try {
            this.setCookieHeader();
            this.methodFactory.execute(this.method);
            this.setResponseBody(this.method.getResponseBodyAsStream());
        }
        finally {
            this.method.releaseConnection();
        }
        return this.method.getStatusCode();
    }

    @Override
    public void setQueryString(NameValuePair[] params) {
        this.method.setQueryString(params);
    }

    @Override
    public String getURL() {
        return this.method.getPath() + "?" + this.method.getQueryString();
    }

    @Override
    public StatusLine getStatusLine() {
        return this.method.getStatusLine();
    }

    private void setCookieHeader() {
        if (this.cookies.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        String separator = "";
        for (Cookie cookie : this.cookies) {
            sb.append(separator);
            sb.append(cookie.getName()).append("=");
            String value = cookie.getValue();
            if (value.indexOf(58) != -1) {
                sb.append('\"').append(value).append('\"');
            } else {
                sb.append(value);
            }
            separator = "; ";
        }
        this.method.setRequestHeader("Cookie", sb.toString());
    }

    @Override
    public void setRequestHeader(String name, String value) {
        this.method.setRequestHeader(name, value);
    }

    @Override
    public void setCookie(String cookie, String value) {
        this.cookies.add(new Cookie(cookie, value));
    }

    private void setResponseBody(InputStream inputStream) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        StringBuilder sb = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            sb.append(line);
        }
        this.responseBody = sb.toString();
    }

    @Override
    public String getResponseBody() {
        return this.responseBody;
    }

    @Override
    public void release() {
        if (this.method != null) {
            this.method.releaseConnection();
        }
    }

    @Override
    public int getStatusCode() {
        return this.method.getStatusCode();
    }
}

