/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.client.config;

import com.cognos.cmutils.reflect.FieldAccessor;
import com.cognos.pogo.handlers.logic.ChainHandler;
import com.cognos.pogo.handlers.logic.PathinfoMappingHandler;
import com.cognos.pogo.handlers.performance.PerformanceIndicationHandler;
import com.cognos.pogo.pdk.Handler;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.transport.FormRequestProcessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class DispatcherConfigHelper {
    protected PogoEngine engine;
    protected PathinfoMappingHandler pathInfoHandler;
    protected FieldAccessor<Map<String, String>> lookupMapField;
    protected FieldAccessor<Map<String, String>> actionMapField;

    public void init(PogoEngine engine) {
        this.engine = engine;
        this.pathInfoHandler = this.getPathInfoMappingHandler();
        this.lookupMapField = new FieldAccessor(PathinfoMappingHandler.class, (Object)this.pathInfoHandler, "lookupMap");
        this.actionMapField = new FieldAccessor(FormRequestProcessor.class, "methodToSoapActionMap");
    }

    public boolean isInitialized() {
        return this.engine != null;
    }

    public void enableCMViewerEnhancements() {
        this.updateDispFormRequestProcessorMapping();
        this.updateDispPathinfoMappingHandler();
    }

    private void updateDispFormRequestProcessorMapping() {
        Map<String, String> map = (HashMap<String, String>)this.actionMapField.get();
        map = new HashMap<String, String>(map);
        String soapAction = ((String)map.get("query")).replace("contentManagerService", "cmGetData");
        map.put("query", soapAction);
        map = Collections.unmodifiableMap(map);
        this.actionMapField.set(map);
    }

    private void updateDispPathinfoMappingHandler() {
        Map map = (Map)this.lookupMapField.get();
        Map<String, String> newMap = new TreeMap<String, String>((Comparator<String>)new PathinfoMappingHandler.LengthComparator(this.pathInfoHandler));
        newMap.putAll(map);
        newMap.put("/gdi", "cmGetData");
        newMap.put("/gd", "cmGetData");
        newMap = Collections.unmodifiableMap(newMap);
        this.lookupMapField.set(newMap);
    }

    private PathinfoMappingHandler getPathInfoMappingHandler() {
        List<Handler> handlers = this.getHandlers();
        PathinfoMappingHandler pathInfoHandler = null;
        for (Handler handler : handlers) {
            if (!"PathinfoMappingHandler".equals(handler.getName())) continue;
            pathInfoHandler = (PathinfoMappingHandler)handler;
        }
        return pathInfoHandler;
    }

    protected List<Handler> getHandlers() {
        PerformanceIndicationHandler theDispatcher = (PerformanceIndicationHandler)this.engine.getHandlerPool().find("root_handler.the_dispatcher");
        ChainHandler chain = (ChainHandler)theDispatcher.getProfiledHandler();
        ArrayList handlers = chain.getChain();
        return handlers;
    }
}

