/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.client.enabler;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cm.client.enabler.Switch;
import com.cognos.pogo.pdk.Configuration;
import java.util.List;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.dom4j.Element;

public class AdvancedPropertySwitch
implements Switch {
    public static final String VALUE = "value";
    public static final String NAME = "name";
    public static final String ADVANCED_PROPERTIES = "advancedProperties";
    private Configuration config = null;
    private static final Logger logger = Hierarchy.getDefaultHierarchy().getLoggerFor(AdvancedPropertySwitch.class.getName());

    private AdvancedPropertySwitch() {
    }

    public AdvancedPropertySwitch(Configuration config) {
        this();
        this.config = config;
    }

    @Override
    public boolean isEnabled() {
        ICCLConfiguration icclConfig = this.config.getICCLConfiguration();
        boolean isEnhancementAdvancedPropEnabled = false;
        try {
            Element cmAdvancedProperties = icclConfig.getValueElement(ADVANCED_PROPERTIES, false);
            if (cmAdvancedProperties != null) {
                List advPropElems = cmAdvancedProperties.elements();
                for (Object elemObj : advPropElems) {
                    Element advPropElem = (Element)elemObj;
                    String advAttrNameVal = advPropElem.attributeValue(NAME);
                    if (!"CM.cmViewerEnhancementsEnabled".equals(advAttrNameVal)) continue;
                    String enhancementAdvancedPropVal = advPropElem.elementText(VALUE);
                    isEnhancementAdvancedPropEnabled = Boolean.parseBoolean(enhancementAdvancedPropVal);
                }
            }
        }
        catch (CCLConfigurationException e) {
            e.printStackTrace();
            logger.error("An error occured while trying to read the viewer enhancement advanced property.");
        }
        return isEnhancementAdvancedPropEnabled;
    }
}

