/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.client.mbean;

import com.cognos.cm.client.mbean.ClientCacheCounterMBean;
import com.cognos.cm.client.mbean.ClientCacheSnapshot;

public class ClientCacheCounter
implements ClientCacheCounterMBean {
    private long totalTime = 0L;
    private long maxTime = Long.MIN_VALUE;
    private long minTime = Long.MAX_VALUE;
    private long valueSquared = 0L;
    private int count = 0;
    private long dataLength = 0L;

    @Override
    public synchronized void addData(long time, long dataLength) {
        if (this.maxTime < time) {
            this.maxTime = time;
        }
        if (this.minTime > time) {
            this.minTime = time;
        }
        this.totalTime += time;
        this.valueSquared += time * time;
        ++this.count;
        this.dataLength += dataLength;
    }

    @Override
    public synchronized ClientCacheSnapshot getClientCacheSnapshot() {
        double count = this.count;
        double avg = (double)this.totalTime / count;
        double avgSqr = avg * avg;
        double stdDev = Math.sqrt((double)this.valueSquared / count - avgSqr);
        ClientCacheSnapshot cacheCount = new ClientCacheSnapshot(this.count, this.maxTime, this.minTime, this.totalTime, stdDev, this.dataLength);
        return cacheCount;
    }
}

