/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.cmrepository;

import com.cognos.cm.repositoryPluginAPI.IDataDescriptor;
import com.cognos.cm.repositoryPluginAPI.IQueryParameter;
import com.cognos.cm.repositoryPluginAPI.IQueryParameters;
import com.cognos.cm.repositoryPluginAPI.IQueryResult;
import com.cognos.cm.repositoryPluginAPI.IRepositoryDataSizeCounter;
import com.cognos.cm.repositoryPluginAPI.IRepositoryPluginContainer;
import com.cognos.cm.repositoryPluginAPI.IRepositoryTimer;
import com.cognos.cm.repositoryPluginAPI.OperationResult;
import com.cognos.cm.repositoryPluginAPI.OperationResultSuccess;
import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cm.repositoryPluginAPI.RepositoryNotAvailableException;
import com.cognos.cm.repositoryPluginFramework.RepositoryLogger;
import com.cognos.cmutils.messages.Message;
import com.cognos.cmutils.messages.Resource;
import com.ibm.cognos.cm.cmrepository.CMRepositoryErrors;
import com.ibm.cognos.cm.cmrepository.CMRepositoryFactory;
import com.ibm.cognos.cm.cmrepository.CMRepositoryObject;
import com.ibm.cognos.cm.cmrepository.CMRepositoryPluginHttpClient;
import com.ibm.cognos.cm.cmrepository.DescriptorProperties;
import com.ibm.cognos.cm.cmrepository.DescriptorPropertiesImpl;
import com.ibm.cognos.cm.cmrepository.io.DataOutput;
import com.ibm.cognos.cm.cmrepository.io.EOSTrashCollector;
import com.ibm.cognos.cm.cmrepository.io.Metadata;
import com.ibm.cognos.cm.cmrepository.path.FileSystemPath;
import com.ibm.cognos.cm.cmrepository.path.PathBuilder;
import com.ibm.cognos.cm.cmrepository.query.ContentValidator;
import com.ibm.cognos.cm.cmrepository.query.RepositoryQueryHandler;
import com.ibm.cognos.cm.cmrepository.query.RepositoryQueryHandlerFactory;
import com.ibm.cognos.cm.repositoryplugincommon.io.FileAccessUtil;
import com.ibm.cognos.cm.repositoryplugincommon.io.FileOutput;
import com.ibm.cognos.cm.repositoryplugincommon.io.RepositoryIOUtils;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.httpclient.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class CMRepository
implements ContentValidator {
    private static final Log log = LogFactory.getLog(CMRepository.class);
    private final RepositoryQueryHandlerFactory queryHandlerFactory;
    private final IRepositoryPluginContainer repositoryPluginContainer;
    private final EOSTrashCollector trashCollector;
    private final boolean isFullAccessRequiredToEOS;
    private String cmRepositoryBaseURL;
    private IDataDescriptor metadata;
    private URI cmRepositoryBaseUri;
    private CMRepositoryPluginHttpClient client;
    private IRepositoryTimer timer;
    private CMRepositoryFactory factory;
    private IRepositoryDataSizeCounter bytesCounter;
    private File repositoryLocation;

    CMRepository(String url, IRepositoryPluginContainer pluginContainer, CMRepositoryPluginHttpClient client, String repositoryLocation, boolean isFullAccessRequiredToEOS) throws RepositoryException, IOException {
        this(url, pluginContainer, client, repositoryLocation, RepositoryQueryHandlerFactory.getInstance(), isFullAccessRequiredToEOS);
    }

    CMRepository(String url, IRepositoryPluginContainer pluginContainer, CMRepositoryPluginHttpClient client, String repositoryLocation, RepositoryQueryHandlerFactory queryHandlerFactory, boolean isFullAccessRequiredToEOS) throws IOException {
        this(url, pluginContainer, client, repositoryLocation, queryHandlerFactory, EOSTrashCollector.getInstance(), isFullAccessRequiredToEOS);
    }

    CMRepository(String url, IRepositoryPluginContainer pluginContainer, CMRepositoryPluginHttpClient client, String repositoryLocation, RepositoryQueryHandlerFactory queryHandlerFactory, EOSTrashCollector trashCollector, boolean isFullAccessRequiredToEOS) throws IOException {
        this.repositoryPluginContainer = pluginContainer;
        this.queryHandlerFactory = queryHandlerFactory;
        this.trashCollector = trashCollector;
        this.isFullAccessRequiredToEOS = isFullAccessRequiredToEOS;
        this.setRepositoryBaseURL(url);
        this.setRepositoryHost();
        this.setHttpClient(client);
        this.repositoryLocation = repositoryLocation != null ? new File(repositoryLocation) : null;
        this.factory = new CMRepositoryFactory();
    }

    private void setRepositoryBaseURL(String url) {
        this.cmRepositoryBaseURL = url;
        this.queryHandlerFactory.setCmRepositoryBaseURL(url);
    }

    String getPropertyValue(Properties properties, String property, String defaultValue) {
        String value = properties.getProperty(property);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    final void setRepositoryHost() throws IOException {
        URI uri = new URI(this.getBaseURL(), false);
        this.cmRepositoryBaseUri = new URI(uri.getScheme(), uri.getAuthority(), null, null);
    }

    final String getBaseURL() {
        return this.cmRepositoryBaseURL;
    }

    private void setHttpClient(CMRepositoryPluginHttpClient client) {
        this.client = client;
        this.queryHandlerFactory.setHttpClient(client);
    }

    IQueryResult queryObjects(String queryName, IQueryParameters parameters, Properties connectionProperties) throws RepositoryException {
        String outputID = this.getOutputStoreID(parameters);
        if (outputID != null && this.isContentQuery(queryName, outputID)) {
            return this.getContent(outputID, parameters, connectionProperties);
        }
        RepositoryQueryHandler queryHandler = this.queryHandlerFactory.getQueryHandler(queryName, outputID);
        return queryHandler.queryObjects(parameters, connectionProperties);
    }

    private String getOutputStoreID(IQueryParameters parameters) {
        String storeID = null;
        IQueryParameter outputStoreIDProp = parameters.getParameter("outputObjectID");
        if (outputStoreIDProp != null && outputStoreIDProp.getValue() != null) {
            storeID = outputStoreIDProp.getValue().toString();
        }
        return storeID;
    }

    private boolean isContentQuery(String queryName, String outputID) {
        return queryName != null && queryName.endsWith("Content") && !"default".equalsIgnoreCase(outputID);
    }

    private IQueryResult getContent(String outputID, IQueryParameters parameters, Properties connectionProperties) throws RepositoryException {
        RepositoryQueryHandler contentQueryHandler = this.queryHandlerFactory.getContentQueryHandler(outputID, this);
        return contentQueryHandler.queryObjects(parameters, connectionProperties);
    }

    IRepositoryPluginContainer getPluginContainer() {
        return this.repositoryPluginContainer;
    }

    IDataDescriptor getMetadata() {
        return this.metadata;
    }

    void setTimeCounter(IRepositoryTimer timer) {
        this.timer = timer;
        this.client.setTimeCounter(timer);
    }

    URI getRepositoryBaseUri() {
        return this.cmRepositoryBaseUri;
    }

    CMRepositoryPluginHttpClient getRepositoryHTTPClient() {
        return this.client;
    }

    void test() throws RepositoryNotAvailableException {
        try {
            if (this.isFullAccessRequiredToEOS) {
                FileAccessUtil.checkFileAccessFlagsWithFault((File)this.repositoryLocation, (int)6);
            } else {
                FileAccessUtil.checkFileAccessFlagsWithFault((File)this.repositoryLocation, (int)4);
            }
        }
        catch (RepositoryException re) {
            throw this.createRepositoryNotAvailableException(re);
        }
    }

    private RepositoryNotAvailableException createRepositoryNotAvailableException(RepositoryException re) {
        Message errorMsg;
        if (this.isEOSConfigured()) {
            errorMsg = new Message((Resource.Id)CMRepositoryErrors.CRP_REP.eosLocationAccessFail);
            String userName = System.getProperty("user.name");
            Message msg = new Message((Resource.Id)CMRepositoryErrors.CRP_REP.eosUserHasInsufficientAccessRights).param("userName", userName);
            re.addDetail(msg);
        } else {
            errorMsg = new Message((Resource.Id)CMRepositoryErrors.CRP_REP.eosMissingLocationURL);
        }
        if (log.isErrorEnabled()) {
            re.addDetail(errorMsg);
            log.error((Object)re);
        }
        return new RepositoryNotAvailableException(errorMsg);
    }

    boolean isEOSConfigured() {
        return this.repositoryLocation != null && !this.repositoryLocation.getName().isEmpty();
    }

    private void startTimer() {
        if (this.timer != null) {
            this.timer.start();
        }
    }

    private void stopTimer() {
        if (this.timer != null) {
            this.timer.stop();
        }
    }

    void setDataSizeCounter(IRepositoryDataSizeCounter counter) {
        this.bytesCounter = counter;
    }

    OperationResult writeData(IDataDescriptor metadata) throws RepositoryException {
        if (metadata == null) {
            throw new RepositoryException((Resource.Id)CMRepositoryErrors.CRP_OPF.missingOptionMetadata);
        }
        try {
            DescriptorPropertiesImpl descriptorProps = new DescriptorPropertiesImpl(metadata);
            this.startTimer();
            this.writeDocument(descriptorProps);
            RepositoryLogger.logWriteSuccess((String)metadata.getProperty("documentObjectID").getStringValue());
            OperationResultSuccess operationResultSuccess = new OperationResultSuccess();
            return operationResultSuccess;
        }
        catch (Exception e) {
            Message msg = new Message((Resource.Id)CMRepositoryErrors.CRP_OPF.failedToAddRepository);
            RepositoryLogger.logFailure((Message)msg, (Throwable)e);
            if (e instanceof RepositoryException) {
                ((RepositoryException)((Object)e)).addDetail(msg);
                throw (RepositoryException)((Object)e);
            }
            RepositoryException newEx = new RepositoryException(msg, (Throwable)e);
            if (e.getMessage() != null) {
                newEx.addDetail(e.getMessage());
            }
            throw newEx;
        }
        finally {
            this.stopTimer();
        }
    }

    private void writeDocument(DescriptorProperties descriptorProps) throws RepositoryException {
        DataOutput dataOutput = this.factory.newDataOutput(this.repositoryLocation.getAbsolutePath(), descriptorProps, this.bytesCounter != null);
        dataOutput.write();
        Metadata metadataOutput = this.factory.newMetadataOutput(this.repositoryLocation.getAbsolutePath(), descriptorProps);
        metadataOutput.store();
        this.incrementBytesCounter((FileOutput)dataOutput);
        if (log.isDebugEnabled()) {
            String docObjID = descriptorProps.getObjectID();
            log.debug((Object)(docObjID + " stored to " + this.repositoryLocation));
        }
    }

    private void incrementBytesCounter(FileOutput data) {
        this.incrementBytesCounter(data.getBytesWritten());
    }

    private void incrementBytesCounter(long numberOfBytesWritten) {
        if (this.bytesCounter != null) {
            this.bytesCounter.increment(numberOfBytesWritten);
        }
    }

    CMRepositoryObject getObject(String objectID) {
        PathBuilder pathBuilder = PathBuilder.getInstance();
        FileSystemPath path = pathBuilder.getPath(objectID);
        return new CMRepositoryObject(this.repositoryLocation.getAbsolutePath(), path);
    }

    @Override
    public boolean objectExists(String objectID) throws RepositoryException {
        if (this.isFullAccessRequiredToEOS) {
            this.test();
        }
        return this.getObject(objectID).exists();
    }

    void deleteData(String objectID) throws RepositoryException {
        this.trashCollector.markForDeletion(objectID);
    }

    void copyData(String srcObjectID, String destObjectID) throws RepositoryException {
        PathBuilder pathBuilder = PathBuilder.getInstance();
        FileSystemPath srcPath = pathBuilder.getPath(srcObjectID);
        FileSystemPath destPath = pathBuilder.getPath(destObjectID);
        File srcDataFile = new File(srcPath.getDataFilename(this.repositoryLocation.getAbsolutePath()));
        File srcMetadataFile = new File(srcPath.getMetadataFilename(this.repositoryLocation.getAbsolutePath()));
        if (srcDataFile.exists() && srcMetadataFile.exists()) {
            File destDataFile = new File(destPath.getDataFilename(this.repositoryLocation.getAbsolutePath()));
            try {
                RepositoryIOUtils.copy((File)srcDataFile, (File)destDataFile);
                Metadata destMetadata = this.copyMetadata(srcMetadataFile, destPath);
                long dataLength = this.getDataLength(destMetadata);
                this.incrementBytesCounter(dataLength);
                RepositoryLogger.logWriteSuccess((String)destObjectID);
            }
            catch (IOException e) {
                try {
                    this.trashCollector.markForDeletion(destObjectID);
                }
                catch (RepositoryException dataLength) {
                    // empty catch block
                }
                RepositoryException cause = new RepositoryException(new Message((Resource.Id)CMRepositoryErrors.CRP_OPF.failedToWriteFile), (Throwable)e);
                throw new RepositoryException(new Message((Resource.Id)CMRepositoryErrors.CRP_OPF.failedToCopyData), (Throwable)cause);
            }
        }
        Message msg = new Message((Resource.Id)CMRepositoryErrors.CRP_OPF.failedToCopyDataSourceDoesNotExist);
        msg.param("objectID", srcObjectID);
        throw new RepositoryException(msg);
    }

    Metadata copyMetadata(File srcMetadataFile, FileSystemPath destPath) throws RepositoryException {
        Metadata srcMetadata = new Metadata(srcMetadataFile);
        srcMetadata.load();
        Metadata destMetadata = new Metadata(destPath.getMetadataFilename(this.repositoryLocation.getAbsolutePath()), srcMetadata);
        destMetadata.setProperty("documentObjectID", destPath.getStoreID());
        destMetadata.store();
        return destMetadata;
    }

    private long getDataLength(Metadata metadata) {
        String dataLengthProp = metadata.getProperty("dataLength");
        long dataLength = 0L;
        if (dataLengthProp != null) {
            try {
                dataLength = Long.valueOf(dataLengthProp);
            }
            catch (NumberFormatException nfe) {
                dataLength = 0L;
            }
        }
        return dataLength;
    }
}

