/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.cmrepository;

import com.cognos.cm.repository.plugin.configuration.IRepositoryConnectionConfiguration;
import com.cognos.cm.repositoryPluginAPI.IDataDescriptor;
import com.cognos.cm.repositoryPluginAPI.IGetDataResults;
import com.cognos.cm.repositoryPluginAPI.IQueryParameters;
import com.cognos.cm.repositoryPluginAPI.IQueryResult;
import com.cognos.cm.repositoryPluginAPI.IRepositoryDataSizeCounter;
import com.cognos.cm.repositoryPluginAPI.IRepositoryTimer;
import com.cognos.cm.repositoryPluginAPI.OperationResult;
import com.cognos.cm.repositoryPluginAPI.RepositoryConnection;
import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cmutils.messages.Message;
import com.cognos.cmutils.messages.Resource;
import com.ibm.cognos.cm.cmrepository.CMRepository;
import com.ibm.cognos.cm.cmrepository.CMRepositoryErrors;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class CMRepositoryConnection
implements RepositoryConnection {
    private static final String GUID_REGEX = "i[0-9A-Fa-f]{32}";
    private static final Pattern GUID_PATTERN = Pattern.compile("i[0-9A-Fa-f]{32}");
    private final Properties properties;
    private final CMRepository repository;

    public CMRepositoryConnection(CMRepository repository, Properties properties) {
        this.repository = repository;
        this.properties = properties;
    }

    public void close() {
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getUrl() {
        return this.repository.getRepositoryBaseUri().toString();
    }

    public OperationResult writeData(IDataDescriptor metadata, Properties options) throws RepositoryException {
        return this.repository.writeData(metadata);
    }

    public void setTimeCounter(IRepositoryTimer timer) {
        this.repository.setTimeCounter(timer);
    }

    public void setDataSizeCounter(IRepositoryDataSizeCounter counter) {
    }

    public IQueryResult queryObjects(String queryName, IQueryParameters parameters, Properties options) throws RepositoryException {
        return this.repository.queryObjects(queryName, parameters, this.properties);
    }

    public IRepositoryConnectionConfiguration getConnectionConfiguration() {
        return this.repository.getPluginContainer().getConnectionConfiguration();
    }

    public void clean() {
    }

    public IGetDataResults getData() throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public byte[] fetchReportAccessPolicies(String reportStoreID) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public boolean validate(String outputID) {
        if (StringUtils.isEmpty((String)outputID)) {
            return false;
        }
        if ("default".equalsIgnoreCase(outputID)) {
            return true;
        }
        return GUID_PATTERN.matcher(outputID).matches();
    }

    public void test() throws RepositoryException {
        try {
            this.repository.test();
        }
        catch (Exception e) {
            Message msg = new Message((Resource.Id)CMRepositoryErrors.CRP_OPF.failedToTestConnection);
            if (e instanceof RepositoryException) {
                ((RepositoryException)((Object)e)).addDetail(msg);
                throw (RepositoryException)((Object)e);
            }
            RepositoryException newEx = new RepositoryException(msg, (Throwable)e);
            newEx.addDetail(e.getMessage());
            throw newEx;
        }
    }

    public void deleteData(String objectID) throws RepositoryException {
        this.repository.deleteData(objectID);
    }

    public void copyData(String srcObjectID, String destObjectID) throws RepositoryException {
        this.repository.copyData(srcObjectID, destObjectID);
    }

    public boolean objectExists(String objectID) throws RepositoryException {
        return this.repository.objectExists(objectID);
    }

    public boolean doesTestPermissions() {
        return !this.repository.isEOSConfigured();
    }
}

