/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.cmrepository;

import com.cognos.cm.repositoryPluginAPI.IDataDescriptorProperty;
import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.ibm.cognos.cm.cmrepository.DescriptorProperties;
import com.ibm.cognos.cm.cmrepository.io.DataOutput;
import com.ibm.cognos.cm.cmrepository.io.Metadata;
import com.ibm.cognos.cm.cmrepository.path.PathBuilder;
import java.util.HashMap;
import java.util.Map;

public class CMRepositoryFactory {
    public Metadata newMetadataOutput(String repositoryLocation, DescriptorProperties props) throws RepositoryException {
        String filename = PathBuilder.getInstance().getMetadataFilename(repositoryLocation, props.getObjectID());
        Map<String, String> metadataMap = this.createMetadataMap(props);
        Metadata metadata = new Metadata(filename);
        metadata.addProperties(metadataMap);
        return metadata;
    }

    public DataOutput newDataOutput(String repositoryLocation, DescriptorProperties props, boolean countBytes) throws RepositoryException {
        String filename = PathBuilder.getInstance().getDataFilename(repositoryLocation, props.getObjectID());
        return new DataOutput(filename, props, countBytes);
    }

    private Map<String, String> createMetadataMap(DescriptorProperties descriptorProperties) throws RepositoryException {
        HashMap<String, String> propertiesMap = new HashMap<String, String>(descriptorProperties.getProperties().length);
        for (IDataDescriptorProperty prop : descriptorProperties.getProperties()) {
            String name = prop.getName();
            if ("data".equals(name)) {
                propertiesMap.put("dataLength", descriptorProperties.getDataLength());
                continue;
            }
            if (!(prop.getValue() instanceof String)) continue;
            propertiesMap.put(name, prop.getStringValue());
        }
        return propertiesMap;
    }
}

