/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.cmrepository;

import com.cognos.cm.repositoryPluginAPI.IRepositoryHttpClientFactory;
import com.cognos.cm.repositoryPluginAPI.IRepositoryPluginContainer;
import com.cognos.cm.repositoryPluginAPI.IRepositoryUserAgentFactory;
import com.cognos.cm.repositoryPluginAPI.RepositoryConnection;
import com.cognos.cm.repositoryPluginAPI.RepositoryConnectionProperties;
import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cm.repositoryPluginAPI.RepositoryPlugin;
import com.cognos.cm.util.service.CMRunningMode;
import com.cognos.cm.util.service.ServiceStateHelper;
import com.cognos.cmutils.messages.Message;
import com.cognos.cmutils.messages.Resource;
import com.ibm.cognos.cm.cmrepository.CMRepository;
import com.ibm.cognos.cm.cmrepository.CMRepositoryConnection;
import com.ibm.cognos.cm.cmrepository.CMRepositoryErrors;
import com.ibm.cognos.cm.cmrepository.CMRepositoryPluginHttpClient;
import com.ibm.cognos.cm.cmrepository.config.PluginConfiguration;
import com.ibm.cognos.cm.cmrepository.config.PluginConfigurationProvider;
import com.ibm.cognos.cm.cmrepository.io.EOSTrashCollector;
import com.ibm.cognos.cm.cmrepository.io.TreeBuilder;
import com.ibm.cognos.cm.cmrepository.io.TreeBuilderFactory;
import com.ibm.cognos.cm.repositoryplugincommon.httpclient.CAMHttpClientProvider;
import com.ibm.cognos.cm.repositoryplugincommon.httpclient.HttpClientProvider;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.httpclient.HttpClient;
import org.dom4j.Document;

public class CMRepositoryPlugin
implements RepositoryPlugin {
    private final HttpClientProvider httpClientProvider;
    private final TreeBuilderFactory treeBuilderFactory;
    private final PluginConfigurationProvider configurationProvider;
    private final EOSTrashCollector trashCollector;
    private final ServiceStateHelper cmServiceStateHelper;

    public CMRepositoryPlugin() {
        this((HttpClientProvider)CAMHttpClientProvider.getInstance(), TreeBuilderFactory.getInstance(), PluginConfigurationProvider.getInstance(), EOSTrashCollector.getInstance(), ServiceStateHelper.getInstance());
    }

    CMRepositoryPlugin(HttpClientProvider httpClientProvider, TreeBuilderFactory treeBuilderFactory, PluginConfigurationProvider configurationProvider, EOSTrashCollector trashCollector, ServiceStateHelper cmServiceStateHelper) {
        this.httpClientProvider = httpClientProvider;
        this.treeBuilderFactory = treeBuilderFactory;
        this.configurationProvider = configurationProvider;
        this.trashCollector = trashCollector;
        this.cmServiceStateHelper = cmServiceStateHelper;
    }

    public RepositoryConnection getConnection(String url, IRepositoryPluginContainer pluginContainer, Properties connectionProperties) throws RepositoryException {
        CMRepository cmRepository = this.getRepository(url, pluginContainer);
        return this.getConnection(connectionProperties, cmRepository);
    }

    private RepositoryConnection getConnection(Properties properties, CMRepository cmRepository) throws RepositoryException {
        CMRepositoryConnection connection = new CMRepositoryConnection(cmRepository, properties);
        String testRequired = (String)properties.get(RepositoryConnectionProperties.TEST_REPOSITORY_CONNECTION);
        if (testRequired != null && testRequired.equalsIgnoreCase("true")) {
            connection.test();
        }
        return connection;
    }

    public RepositoryConnection getConnection(IRepositoryUserAgentFactory repositoryUserAgentFactory, String url, IRepositoryPluginContainer pluginContainer, Properties connectionProperties) throws RepositoryException {
        CMRepository cmRepository = this.getRepository(url, pluginContainer, this.getRepositoryHttpClient(repositoryUserAgentFactory, url));
        return this.getConnection(connectionProperties, cmRepository);
    }

    protected CMRepository getRepository(String url, IRepositoryPluginContainer pluginContainer) throws RepositoryException {
        return this.getRepository(url, pluginContainer, this.getRepositoryHttpClient(url));
    }

    private CMRepository getRepository(String url, IRepositoryPluginContainer pluginContainer, CMRepositoryPluginHttpClient repositoryPluginHttpClient) throws RepositoryException {
        CMRepository cmRepository;
        try {
            cmRepository = this.createRepository(url, pluginContainer, repositoryPluginHttpClient);
        }
        catch (Exception ex) {
            Message msg = new Message((Resource.Id)CMRepositoryErrors.CRP_OPF.failedToInitializeRepository);
            if (ex instanceof RepositoryException) {
                ((RepositoryException)((Object)ex)).addDetail(msg);
                throw (RepositoryException)((Object)ex);
            }
            RepositoryException newEx = new RepositoryException(msg, (Throwable)ex);
            String exMessage = ex.getMessage();
            if (exMessage != null) {
                newEx.addDetail(ex.getMessage());
            }
            throw newEx;
        }
        return cmRepository;
    }

    protected CMRepository createRepository(String url, IRepositoryPluginContainer pluginContainer, CMRepositoryPluginHttpClient repositoryPluginHttpClient) throws Exception {
        String repositoryLocation = this.configurationProvider.getConfiguration().getEOSrootPath();
        return new CMRepository(url, pluginContainer, repositoryPluginHttpClient, repositoryLocation, this.isEOSAccessRequired());
    }

    private CMRepositoryPluginHttpClient getRepositoryHttpClient(String urlString) throws RepositoryException {
        URL url = this.getURL(urlString);
        HttpClient httpClient = this.httpClientProvider.create(url);
        return new CMRepositoryPluginHttpClient(httpClient);
    }

    private CMRepositoryPluginHttpClient getRepositoryHttpClient(IRepositoryUserAgentFactory repositoryUserAgentFactory, String urlString) throws RepositoryException {
        if (!(repositoryUserAgentFactory instanceof IRepositoryHttpClientFactory)) {
            throw new IllegalStateException("repositoryUserAgentFactory must be of type IRepositoryHttpClientFactory!");
        }
        IRepositoryHttpClientFactory repositoryHttpClientFactory = (IRepositoryHttpClientFactory)repositoryUserAgentFactory;
        URL url = this.getURL(urlString);
        boolean secure = url.getProtocol() != null && url.getProtocol().startsWith("https");
        return new CMRepositoryPluginHttpClient(repositoryHttpClientFactory.createHttpClient(url.getHost(), url.getPort(), secure));
    }

    private URL getURL(String urlString) throws RepositoryException {
        URL url;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            Message msg = new Message((Resource.Id)CMRepositoryErrors.CRP_REP.invalidConnectionString).param("connectionString", urlString);
            throw new RepositoryException(msg, (Throwable)e);
        }
        return url;
    }

    public void initialize(Document configurationDocument) throws RepositoryException {
        PluginConfiguration pluginConfiguration = this.configurationProvider.getConfiguration();
        if (pluginConfiguration.isEOSenabled() && this.isEOSAccessRequired()) {
            String eosRootPath = pluginConfiguration.getEOSrootPath();
            TreeBuilder treeBuilder = this.treeBuilderFactory.create(eosRootPath);
            treeBuilder.buildRepositoryTree();
            this.trashCollector.setRepositoryLocation(eosRootPath);
            this.trashCollector.start();
        }
    }

    private boolean isEOSAccessRequired() {
        boolean isEOSAccessRequired = true;
        CMRunningMode cmRunningMode = this.cmServiceStateHelper.getCMRunningMode();
        if (CMRunningMode.NOT_PRESENT.equals((Object)cmRunningMode)) {
            isEOSAccessRequired = false;
        }
        return isEOSAccessRequired;
    }

    public void terminate() {
        this.trashCollector.stop();
    }
}

