/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.cmrepository;

import com.cognos.cm.repositoryPluginAPI.HttpClientHelper;
import com.cognos.cm.repositoryPluginAPI.IRepositoryTimer;
import com.cognos.cm.repositoryPluginAPI.RepositoryConnectionException;
import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cm.repositoryPluginAPI.RepositoryUnauthorizedException;
import com.cognos.cmutils.messages.Message;
import com.cognos.cmutils.messages.Resource;
import com.ibm.cognos.cm.cmrepository.CMRepositoryErrors;
import com.ibm.cognos.cm.cmrepository.CMRepositoryPluginHttpResponseResult;
import java.io.IOException;
import java.net.ConnectException;
import java.net.UnknownHostException;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CMRepositoryPluginHttpClient {
    private static String baseLogCategory = CMRepositoryPluginHttpClient.class.getName();
    private static final Log log = LogFactory.getLog((String)baseLogCategory);
    private static final Log logHttpReq = LogFactory.getLog((String)(baseLogCategory + ".http.request"));
    private static final Log logHttpReqHeaders = LogFactory.getLog((String)(baseLogCategory + ".http.request.headers"));
    private static final Log logHttpRsp = LogFactory.getLog((String)(baseLogCategory + ".http.response"));
    private static final Log logHttpRspHeaders = LogFactory.getLog((String)(baseLogCategory + ".http.response.headers"));
    private HttpClient client;
    public static final String REQUEST_HEADER_AUTHORIZATION = "Authorization";
    public static final String REQUEST_HEADER_CONTENTTYPE = "Content-Type";
    public static final String REQUEST_HEADER_CHECKIN = "checkin";
    public static final String REQUEST_HEADER_MAJOR = "major";
    public static final String REQUEST_HEADER_BASIC = "Basic ";
    public static final String REQUEST_HEADER_RANGE = "Range";
    private long millis;
    private IRepositoryTimer timer;

    public CMRepositoryPluginHttpClient(HttpClient httpClient) {
        this.client = httpClient;
    }

    public CMRepositoryPluginHttpResponseResult executeGetMethod(String url, String passport) throws Exception {
        return this.executeGetMethod(new URI(url, false), passport);
    }

    public CMRepositoryPluginHttpResponseResult executeGetMethod(URI uri, String passport) throws Exception {
        HttpMethod method = this.createGetMethod(uri, passport);
        return this.executeMethod(method);
    }

    public CMRepositoryPluginHttpResponseResult executeGetRangeMethod(String url, String passport, String range) throws Exception {
        return this.executeGetRangeMethod(new URI(url, false), passport, range);
    }

    public CMRepositoryPluginHttpResponseResult executeGetRangeMethod(URI uri, String passport, String range) throws Exception {
        HttpMethod method = this.createGetMethod(uri, passport);
        method.setRequestHeader(REQUEST_HEADER_RANGE, range);
        return this.executeMethod(method);
    }

    public CMRepositoryPluginHttpResponseResult executeMethod(HttpMethod httpMethod) throws RepositoryException, IOException {
        this.logHTTPRequest(httpMethod);
        this.startTimer();
        try {
            this.client.executeMethod(httpMethod);
        }
        catch (ConnectException e1) {
            log.warn((Object)e1);
            Message msg = new Message((Resource.Id)CMRepositoryErrors.CRP_REP.repositoryConnectionFailed);
            msg.param("host", this.client.getHostConfiguration().getHost());
            msg.param("port", String.valueOf(this.client.getHostConfiguration().getPort()));
            throw new RepositoryConnectionException(msg);
        }
        catch (UnknownHostException e) {
            this.logHTTPResponse(httpMethod);
            log.error((Object)e);
            throw new RepositoryConnectionException(new Message((Resource.Id)CMRepositoryErrors.CRP_REP.repositoryUnknownHost).param("host", this.client.getHostConfiguration().getHost()));
        }
        catch (Exception e) {
            this.logHTTPResponse(httpMethod);
            log.error((Object)e);
            throw new RepositoryException(new Message((Resource.Id)CMRepositoryErrors.CRP_REP.failedToPerformHttpRequest).param("RootCause", e.getLocalizedMessage()));
        }
        this.stopTimer();
        this.logHTTPResponse(httpMethod);
        CMRepositoryPluginHttpResponseResult responseResult = new CMRepositoryPluginHttpResponseResult(httpMethod);
        if (log.isDebugEnabled()) {
            String host = this.client.getHostConfiguration().toString();
            log.debug((Object)(host + " " + httpMethod.getName() + " " + httpMethod.getPath() + " result: " + responseResult.getStatusCode() + " took: " + this.millis + " (ms)"));
        }
        if (responseResult.getStatusCode() == 401) {
            throw new RepositoryUnauthorizedException(new Message((Resource.Id)CMRepositoryErrors.CRP_REP.repositoryUnauthorized));
        }
        return responseResult;
    }

    private boolean isPostOrPutMethod(HttpMethod httpMethod) {
        return httpMethod instanceof EntityEnclosingMethod;
    }

    public HttpMethod createGetMethod(String uri, String passport) throws URIException {
        return this.createGetMethod(new URI(uri, false), passport);
    }

    public HttpMethod createGetMethod(URI uri, String passport) throws URIException {
        GetMethod method = this.createGetMethod();
        this.setupGetMethod(uri, passport, (HttpMethod)method);
        return method;
    }

    protected GetMethod createGetMethod() {
        return new GetMethod();
    }

    protected void setupGetMethod(URI uri, String passport, HttpMethod method) throws URIException {
        HttpClientHelper.setMethodPath((HttpClient)this.client, (HttpMethod)method, (URI)uri);
        StringBuilder buf = new StringBuilder(50);
        buf.append("cam_passport=");
        if (passport.indexOf(58) >= 0) {
            buf.append('\"').append(passport).append('\"');
        } else {
            buf.append(passport);
        }
        method.setRequestHeader("Cookie", buf.toString());
        method.setRequestHeader("Accept-Encoding", "gzip");
    }

    private void startTimer() {
        if (this.timer != null) {
            this.timer.start();
        }
        this.millis = System.currentTimeMillis();
    }

    private void stopTimer() {
        if (this.timer != null) {
            this.timer.stop();
        }
        this.millis = System.currentTimeMillis() - this.millis;
    }

    public void setTimeCounter(IRepositoryTimer timer) {
        this.timer = timer;
    }

    private void logHTTPRequest(HttpMethod method) {
        if (this.isPostOrPutMethod(method)) {
            this.logHTTPRequestEntity((EntityEnclosingMethod)method);
        }
    }

    private void logHTTPRequestEntity(EntityEnclosingMethod method) {
        RequestEntity requestEntity;
        this.logHTTPRequestHeaders((HttpMethod)method);
        if (logHttpReq.isDebugEnabled() && (requestEntity = method.getRequestEntity()) instanceof StringRequestEntity) {
            logHttpReq.debug((Object)((StringRequestEntity)requestEntity).getContent());
        }
    }

    private void logHTTPRequestHeaders(HttpMethod method) {
        if (logHttpReqHeaders.isDebugEnabled()) {
            Header[] headers = method.getRequestHeaders();
            String headersString = this.getHttpHeadersAsString(headers);
            logHttpReqHeaders.debug((Object)("request headers: " + headersString));
        }
    }

    private void logHTTPResponse(HttpMethod method) throws IOException {
        if (!this.isPostOrPutMethod(method)) {
            return;
        }
        if (logHttpRspHeaders.isDebugEnabled()) {
            Header[] headers = method.getResponseHeaders();
            String headersString = this.getHttpHeadersAsString(headers);
            logHttpRspHeaders.debug((Object)("response headers: " + headersString));
        }
        if (logHttpRsp.isDebugEnabled()) {
            logHttpRsp.debug((Object)method.getResponseBodyAsString());
        }
    }

    private String getHttpHeadersAsString(Header[] headers) {
        StringBuilder sb = new StringBuilder();
        String lineSeparator = System.getProperty("line.separator");
        sb.append(lineSeparator);
        String separator = "";
        for (Header header : headers) {
            sb.append(separator);
            sb.append(header.getName()).append(": ").append(header.getValue());
            separator = lineSeparator;
        }
        return sb.toString();
    }
}

