/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.cmrepository;

import com.cognos.cm.repositoryPluginAPI.DataObject;
import com.cognos.cm.repositoryPluginAPI.IDataDescriptor;
import com.cognos.cm.repositoryPluginAPI.IDataDescriptorProperty;
import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cmutils.messages.Message;
import com.cognos.cmutils.messages.Resource;
import com.ibm.cognos.cm.cmrepository.CMRepositoryErrors;
import com.ibm.cognos.cm.cmrepository.DescriptorProperties;
import java.io.InputStream;

public class DescriptorPropertiesImpl
implements DescriptorProperties {
    private IDataDescriptor descriptor;

    public DescriptorPropertiesImpl(IDataDescriptor metadata) {
        this.descriptor = metadata;
    }

    @Override
    public IDataDescriptorProperty[] getProperties() {
        return this.descriptor.getProperties();
    }

    @Override
    public String getObjectID() throws RepositoryException {
        String objectID = this.getStringProperty("documentObjectID");
        if (objectID == null || objectID.length() == 0) {
            Message msg = new Message((Resource.Id)CMRepositoryErrors.CRP_OPF.missingProperty).param("property", "documentObjectID");
            throw new RepositoryException(msg);
        }
        return objectID;
    }

    @Override
    public InputStream getData() throws RepositoryException {
        return this.getDataObject().getDataStream();
    }

    @Override
    public String getDataLength() throws RepositoryException {
        return Long.toString(this.getDataObject().getDataLength());
    }

    private DataObject getDataObject() throws RepositoryException {
        Object valueObject;
        IDataDescriptorProperty property = this.descriptor.getProperty("data");
        if (property == null) {
            this.throwMissingDataPropertyException();
        }
        if ((valueObject = property.getValue()) == null || !(valueObject instanceof DataObject)) {
            this.throwMissingDataPropertyException();
        }
        return (DataObject)valueObject;
    }

    private void throwMissingDataPropertyException() throws RepositoryException {
        Message msg = new Message((Resource.Id)CMRepositoryErrors.CRP_OPF.missingProperty).param("property", "data");
        throw new RepositoryException(msg);
    }

    private String getStringProperty(String name) throws RepositoryException {
        return this.getProperty(name).getStringValue();
    }

    private IDataDescriptorProperty getProperty(String name) throws RepositoryException {
        IDataDescriptorProperty property = this.descriptor.getProperty(name);
        if (property == null) {
            Message msg = new Message((Resource.Id)CMRepositoryErrors.CRP_OPF.missingProperty).param("property", name);
            throw new RepositoryException(msg);
        }
        return property;
    }
}

