/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.cmrepository.config;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cmutils.messages.Message;
import com.cognos.cmutils.messages.Resource;
import com.cognos.cmutils.url.FileURIUtils;
import com.ibm.cognos.cm.cmrepository.CMRepositoryErrors;
import com.ibm.cognos.cm.cmrepository.config.PluginConfiguration;

abstract class CCLConfigBasePluginConfiguration
implements PluginConfiguration {
    static final String FILE_SCHEME = "file";
    static final String FILESTORE_URI_PARAMETER_NAME = "fileStoreURI";
    private final ICCLConfiguration icclConfig;
    private boolean isEOSenabled = false;
    private String eosRootPath;

    CCLConfigBasePluginConfiguration(ICCLConfiguration icclConfig) {
        this.icclConfig = icclConfig;
    }

    void processConfig() throws RepositoryException {
        this.processCCLConfig(this.icclConfig);
        this.setEosPathFromURI(this.getEosURI());
    }

    abstract void processCCLConfig(ICCLConfiguration var1) throws RepositoryException;

    abstract String getEosURI();

    private void setEosPathFromURI(String EosURI) throws RepositoryException {
        try {
            this.eosRootPath = FileURIUtils.getPathFromURI((String)EosURI);
            this.isEOSenabled = null != this.eosRootPath;
        }
        catch (RuntimeException e) {
            throw new RepositoryException(new Message((Resource.Id)CMRepositoryErrors.CRP_REP.eosInavalidLocationURL).param(FILESTORE_URI_PARAMETER_NAME, EosURI), (Throwable)e);
        }
    }

    @Override
    public boolean isEOSenabled() {
        return this.isEOSenabled;
    }

    @Override
    public String getEOSrootPath() {
        return this.eosRootPath;
    }
}

