/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.cmrepository.config;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cmutils.messages.Message;
import com.cognos.cmutils.messages.Resource;
import com.cognos.cmutils.system.SystemUtils;
import com.ibm.cognos.cm.cmrepository.CMRepositoryErrors;
import com.ibm.cognos.cm.cmrepository.config.CCLConfigBasePluginConfiguration;
import java.util.List;
import org.dom4j.Element;
import org.dom4j.Namespace;

class CCLConfigElementPluginConfiguration
extends CCLConfigBasePluginConfiguration {
    private static final String UNIX_URI_PARAMETER_NAME = "unixURI";
    private static final String WIN_URI_PARAMETER_NAME = "winURI";
    private static final String FILESTORE_URI_PARAMETER_NAME = "fileStoreURI";
    private static final String CM_CONFIG_ELEMENT = "CM";
    private static final String CONFIG_SCHEMA = "http://developer.cognos.com/schemas/crconfig/1/";
    private static final String VALUE = "value";
    private static final String NAME = "name";
    private static final String PARAMETER = "parameter";
    private static final String INSTANCES = "instances";
    private static final String INSTANCE = "instance";
    private static final String NSPREFIX = "{nsPrefix}";
    private static final String FILESTORE_URI_XPATH_SEARCH = "{nsPrefix}instances/{nsPrefix}instance[1]/{nsPrefix}instances/{nsPrefix}instance[1]/{nsPrefix}parameter[@name='fileStoreURI']";
    private String eosURI;

    CCLConfigElementPluginConfiguration(ICCLConfiguration cclConfig) throws RepositoryException {
        super(cclConfig);
    }

    @Override
    void processCCLConfig(ICCLConfiguration cclConfig) throws RepositoryException {
        String configNameSpacePrefix;
        String fileStoreXpath;
        Element fileStoreNode;
        Element cmConfigElement = this.getCMconfigurationElement(cclConfig);
        if (cmConfigElement != null && (fileStoreNode = (Element)cmConfigElement.selectSingleNode(fileStoreXpath = FILESTORE_URI_XPATH_SEARCH.replace(NSPREFIX, configNameSpacePrefix = this.getConfigNameSpacePrefix(cmConfigElement)))) != null) {
            this.extractRootPath(fileStoreNode);
        }
    }

    private Element getCMconfigurationElement(ICCLConfiguration cclConfig) throws RepositoryException {
        try {
            return cclConfig.getValueElement(CM_CONFIG_ELEMENT, false);
        }
        catch (CCLConfigurationException e) {
            throw new RepositoryException(new Message((Resource.Id)CMRepositoryErrors.CRP_REP.eosFailedToLoadConfiguration), (Throwable)e);
        }
    }

    private String getConfigNameSpacePrefix(Element cmConfigElement) {
        Namespace configNameSpace = cmConfigElement.getNamespaceForURI(CONFIG_SCHEMA);
        return configNameSpace.getPrefix() != null ? configNameSpace.getPrefix() + ":" : "";
    }

    private void extractRootPath(Element storeURIelement) throws RepositoryException {
        String uriParameterName = this.getOSDependentURIParameterName();
        List items = storeURIelement.element(VALUE).elements("item");
        for (Element el : items) {
            if (!uriParameterName.equals(el.attributeValue(NAME))) continue;
            String eosURI = el.getStringValue().trim();
            if (eosURI.isEmpty()) break;
            this.eosURI = eosURI;
            break;
        }
        this.checkEosRootPath();
    }

    private void checkEosRootPath() throws RepositoryException {
        if (this.eosURI == null) {
            throw new RepositoryException(new Message((Resource.Id)CMRepositoryErrors.CRP_REP.eosMissingLocationURL));
        }
    }

    private String getOSDependentURIParameterName() {
        if (SystemUtils.isRunningWindows()) {
            return WIN_URI_PARAMETER_NAME;
        }
        return UNIX_URI_PARAMETER_NAME;
    }

    @Override
    String getEosURI() {
        return this.eosURI;
    }
}

