/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.cmrepository.config;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cmutils.messages.Message;
import com.cognos.cmutils.messages.Resource;
import com.cognos.cmutils.system.SystemUtils;
import com.ibm.cognos.cm.cmrepository.CMRepositoryErrors;
import com.ibm.cognos.cm.cmrepository.config.CCLConfigBasePluginConfiguration;

class CCLRuntimePluginConfiguration
extends CCLConfigBasePluginConfiguration {
    static final String UNIX_URI_PARAMETER = "unixRepositoryURI";
    static final String WINDOWS_URI_PARAMETER = "windowsRepositoryURI";
    private String eosURI;

    CCLRuntimePluginConfiguration(ICCLConfiguration cclConfig) throws RepositoryException {
        super(cclConfig);
    }

    @Override
    void processCCLConfig(ICCLConfiguration cclConfig) throws RepositoryException {
        try {
            String windowsURI = cclConfig.getValue(WINDOWS_URI_PARAMETER, false);
            String unixURI = cclConfig.getValue(UNIX_URI_PARAMETER, false);
            this.processURIs(windowsURI, unixURI);
        }
        catch (CCLConfigurationException e) {
            throw new RepositoryException(new Message((Resource.Id)CMRepositoryErrors.CRP_REP.eosFailedToLoadConfiguration), (Throwable)e);
        }
    }

    private void processURIs(String windowsURI, String unixURI) {
        this.eosURI = SystemUtils.isRunningWindows() ? windowsURI : unixURI;
    }

    @Override
    String getEosURI() {
        return this.eosURI;
    }
}

