/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.cmrepository.io;

import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cmutils.messages.Message;
import com.cognos.cmutils.messages.Resource;
import com.ibm.cognos.cm.cmrepository.CMRepositoryErrors;
import com.ibm.cognos.cm.cmrepository.DescriptorProperties;
import com.ibm.cognos.cm.repositoryplugincommon.io.FileOutputBase;
import com.ibm.cognos.cm.repositoryplugincommon.io.RepositoryIOUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataOutput
extends FileOutputBase {
    private static final Log log = LogFactory.getLog(DataOutput.class);
    private InputStream inputStream;

    public DataOutput(String filename, DescriptorProperties props, boolean countBytes) throws RepositoryException {
        super(filename, countBytes);
        this.inputStream = props.getData();
    }

    public void write() throws RepositoryException {
        if (this.inputStream == null) {
            return;
        }
        File file = new File(this.filename);
        try {
            this.outputStream = this.createFileOutputStream(file);
            this.write(this.outputStream);
            this.logFileWritten(file);
        }
        catch (Exception e) {
            Message msg = new Message((Resource.Id)CMRepositoryErrors.CRP_OPF.failedToWriteFile);
            throw new RepositoryException(msg, (Throwable)e);
        }
        finally {
            try {
                this.inputStream.close();
                this.inputStream = null;
                if (this.outputStream != null) {
                    this.outputStream.close();
                    this.outputStream = null;
                }
            }
            catch (IOException e) {
                this.logFailedtoCloseStream(file);
            }
        }
    }

    private void write(OutputStream outputStream) throws Exception {
        if (this.fileHeader != null) {
            outputStream.write(this.fileHeader.getBytes("UTF-8"));
        }
        if (this.inputStream instanceof FileInputStream && outputStream instanceof FileOutputStream) {
            FileInputStream fis = (FileInputStream)this.inputStream;
            FileOutputStream fos = (FileOutputStream)outputStream;
            RepositoryIOUtils.copy((FileChannel)fis.getChannel(), (FileChannel)fos.getChannel());
        } else {
            IOUtils.copy((InputStream)this.inputStream, (OutputStream)outputStream);
        }
    }

    protected OutputStream compress(OutputStream os) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected Log getLog() {
        return log;
    }

    InputStream getInputStream() {
        return this.inputStream;
    }
}

