/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.cmrepository.io;

import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cm.repositoryPluginFramework.RepositoryLogger;
import com.cognos.cmutils.messages.Message;
import com.cognos.cmutils.messages.Resource;
import com.ibm.cognos.cm.cmrepository.CMRepositoryErrors;
import com.ibm.cognos.cm.cmrepository.path.FileSystemPath;
import com.ibm.cognos.cm.cmrepository.path.PathBuilder;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;

public class EOSTrashCollector
implements Runnable {
    private static final EOSTrashCollector INSTANCE = new EOSTrashCollector(PathBuilder.getInstance());
    static final String DELETE_SUFFIX = ".delete";
    private static final FilenameFilter DELETE_FILE_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(EOSTrashCollector.DELETE_SUFFIX);
        }
    };
    private final PathBuilder pathBuilder;
    private String repositoryLocation;
    private boolean isCollectorRunning = false;
    private Thread collectorThread;
    private File trashFolder;

    EOSTrashCollector(PathBuilder pathBuilder) {
        this.pathBuilder = pathBuilder;
    }

    public synchronized void setRepositoryLocation(String repositoryLocation) {
        if (repositoryLocation == null) {
            throw new IllegalArgumentException();
        }
        this.repositoryLocation = repositoryLocation;
        this.trashFolder = new File(this.pathBuilder.getTrashDirectoryPath(repositoryLocation));
    }

    public synchronized void collectTrash() {
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.isCollectorRunning = true;
        while (this.isCollectorRunning) {
            try {
                this.emptyTrash();
            }
            catch (Throwable t) {
                RepositoryLogger.logFailure((Message)new Message((Resource.Id)CMRepositoryErrors.CRP_OPF.failedToEmptyEOSTrash), (Throwable)t);
            }
            EOSTrashCollector eOSTrashCollector = this;
            synchronized (eOSTrashCollector) {
                try {
                    this.notifyAll();
                    this.wait();
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }
    }

    private void emptyTrash() {
        File trashFolder = new File(this.pathBuilder.getTrashDirectoryPath(this.repositoryLocation));
        if (trashFolder.exists() && trashFolder.isDirectory()) {
            File[] objectsMarkedForDeletion = trashFolder.listFiles(DELETE_FILE_FILTER);
            do {
                for (File marker : objectsMarkedForDeletion) {
                    this.deleteEOSObject(marker);
                }
            } while ((objectsMarkedForDeletion = trashFolder.listFiles(DELETE_FILE_FILTER)).length > 0);
        } else {
            throw new RuntimeException("Invalid trash folder - Check the system configuration");
        }
    }

    private void deleteEOSObject(File marker) {
        String storeID = this.getStoreID(marker);
        try {
            FileSystemPath objectPath = this.pathBuilder.getPath(storeID);
            File objectData = new File(objectPath.getDataFilename(this.repositoryLocation));
            File objectMetadata = new File(objectPath.getMetadataFilename(this.repositoryLocation));
            objectData.delete();
            objectMetadata.delete();
            marker.delete();
            RepositoryLogger.logDeleteSuccess((String)storeID);
        }
        catch (SecurityException e) {
            Message msg = this.createDeleteExceptionMessage(storeID);
            RepositoryLogger.logFailure((Message)msg, (Throwable)e);
        }
    }

    private String getStoreID(File marker) {
        String storeID = marker.getName();
        storeID = storeID.substring(0, storeID.length() - DELETE_SUFFIX.length());
        return storeID;
    }

    public synchronized void stop() {
        this.isCollectorRunning = false;
        this.collectorThread.interrupt();
        this.collectorThread = null;
    }

    public synchronized void start() {
        if (this.repositoryLocation == null) {
            throw new IllegalStateException("A repository location must be set before starting the collector");
        }
        if (this.collectorThread == null) {
            this.collectorThread = new Thread((Runnable)this, this.getClass().getSimpleName());
            this.collectorThread.setDaemon(true);
            this.collectorThread.start();
        }
    }

    public synchronized void markForDeletion(String storeID) throws RepositoryException {
        if (this.isValidTrashFolder()) {
            try {
                File deleteMarker = new File(this.trashFolder, storeID + DELETE_SUFFIX);
                deleteMarker.createNewFile();
                this.notifyAll();
            }
            catch (IOException e) {
                Message msg = this.createDeleteExceptionMessage(storeID);
                RepositoryLogger.logFailure((Message)msg, (Throwable)e);
                throw new RepositoryException(msg, (Throwable)e);
            }
        } else {
            Message msg = this.createDeleteExceptionMessage(storeID);
            throw new RepositoryException(msg);
        }
    }

    private boolean isValidTrashFolder() {
        return this.trashFolder != null && this.trashFolder.exists() && this.trashFolder.isDirectory();
    }

    private Message createDeleteExceptionMessage(String objectID) {
        return new Message((Resource.Id)CMRepositoryErrors.CRP_OPF.failedToDelete).param("objectID", objectID);
    }

    public static EOSTrashCollector getInstance() {
        return INSTANCE;
    }
}

