/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.cmrepository.io;

import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cmutils.messages.Message;
import com.cognos.cmutils.messages.Resource;
import com.ibm.cognos.cm.repositoryplugincommon.RepositoryPluginCommonErrors;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;

public class Metadata {
    private final Properties properties;
    private File propertiesFile;

    public Metadata(String filename) {
        this(new File(filename));
    }

    public Metadata(String filename, Metadata metadata) {
        this(new File(filename), metadata);
    }

    public Metadata(File file, Metadata metadata) {
        this(file);
        this.properties.putAll((Map<?, ?>)metadata.properties);
    }

    public Metadata(File file) {
        this.propertiesFile = file;
        this.properties = new Properties();
    }

    public void load() throws RepositoryException {
        FileInputStream is = null;
        try {
            is = new FileInputStream(this.propertiesFile);
            this.properties.load(is);
        }
        catch (Exception e) {
            try {
                Message msg = new Message((Resource.Id)RepositoryPluginCommonErrors.CPG_OPF.failedToReadAndParseFile);
                msg.addDetail(e.getMessage());
                throw new RepositoryException(msg, (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
    }

    public void store() throws RepositoryException {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(this.propertiesFile, false);
            this.properties.store(os, null);
        }
        catch (IOException e) {
            try {
                Message msg = new Message((Resource.Id)RepositoryPluginCommonErrors.CPG_OPF.failedToWriteFile).param("fileName", this.propertiesFile.getAbsolutePath());
                msg.addDetail(e.getMessage());
                throw new RepositoryException(msg, (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(os);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)os);
    }

    public void addProperties(Map<String, String> properties) {
        this.properties.putAll(properties);
    }

    public String getProperty(String propertyName) {
        return this.properties.getProperty(propertyName);
    }

    public String setProperty(String name, String value) {
        return (String)this.properties.setProperty(name, value);
    }

    public boolean containsProperty(String name) {
        return this.properties.containsKey(name);
    }

    public Collection<String> getPropertyNames() {
        ArrayList<String> propertyNames = new ArrayList<String>(this.size());
        for (Object key : this.properties.keySet()) {
            propertyNames.add((String)key);
        }
        return propertyNames;
    }

    public int size() {
        return this.properties.size();
    }
}

