/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.cmrepository.io;

import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cmutils.messages.Message;
import com.cognos.cmutils.messages.Resource;
import com.ibm.cognos.cm.cmrepository.CMRepositoryErrors;
import com.ibm.cognos.cm.cmrepository.path.FileSystemPath;
import com.ibm.cognos.cm.cmrepository.path.PathBuilder;
import com.ibm.cognos.cm.repositoryplugincommon.io.FileAccessUtil;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

public class TreeBuilder {
    private final String baseLocation;
    private final PathBuilder pathBuilder;

    TreeBuilder(String baseLocation) {
        this(baseLocation, PathBuilder.getInstance());
    }

    TreeBuilder(String baseLocation, PathBuilder pathBuilder) {
        this.baseLocation = baseLocation;
        this.pathBuilder = pathBuilder;
    }

    public void buildRepositoryTree() throws RepositoryException {
        this.checkBaseLocation();
        this.createDataDirectoryTree();
        this.createTrashDirectory();
    }

    private void checkBaseLocation() throws RepositoryException {
        File baseDirectory = new File(this.baseLocation);
        try {
            FileAccessUtil.checkFileAccessFlagsWithFault((File)baseDirectory, (int)2);
        }
        catch (RepositoryException re) {
            String userName = System.getProperty("user.name");
            Message msg = new Message((Resource.Id)CMRepositoryErrors.CRP_REP.eosUserHasInsufficientAccessRights).param("userName", userName);
            re.addDetail(msg);
            re.addDetail(new Message((Resource.Id)CMRepositoryErrors.CRP_REP.eosLocationAccessFail));
            throw re;
        }
    }

    private void createDataDirectoryTree() throws RepositoryException {
        Integer idx = 0;
        while (idx < 4096) {
            String path = this.getDirectoryPath(idx);
            File directory = new File(this.baseLocation + "/" + path);
            this.createDirectory(directory);
            Integer n = idx;
            Integer n2 = idx = Integer.valueOf(idx + 1);
        }
    }

    private String getDirectoryPath(Integer index) {
        String storeID = String.format("i%0" + FileSystemPath.DEPTH_FACTOR + "X", index);
        return this.pathBuilder.getPath(storeID).getFolderPath();
    }

    private void createTrashDirectory() throws RepositoryException {
        String trashPath = this.pathBuilder.getTrashDirectoryPath(this.baseLocation);
        File directory = new File(trashPath);
        this.createDirectory(directory);
    }

    private void createDirectory(File directory) throws RepositoryException {
        if (!directory.exists()) {
            try {
                FileUtils.forceMkdir((File)directory);
            }
            catch (IOException e) {
                throw new RepositoryException(new Message((Resource.Id)CMRepositoryErrors.CRP_REP.eosLocationAccessFail), (Throwable)e);
            }
        }
    }
}

