/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.cmrepository.path;

import com.ibm.cognos.cm.cmrepository.path.FileSystemPath;
import java.io.File;

public class EosPath
implements FileSystemPath {
    private String folderPath;
    private final String storeID;

    EosPath(String storeID, int depthFactor) {
        this.storeID = storeID.charAt(0) + storeID.substring(1).toUpperCase();
        this.createFolderPath(depthFactor);
    }

    private void createFolderPath(int depthFactor) {
        StringBuilder pathBuffer = new StringBuilder();
        for (int idx = 1; idx <= depthFactor; ++idx) {
            pathBuffer.append(this.storeID.charAt(idx));
            if (idx % 2 != 0 || idx == depthFactor) continue;
            pathBuffer.append("/");
        }
        this.folderPath = pathBuffer.toString();
    }

    @Override
    public String getFolderPath() {
        return this.folderPath;
    }

    @Override
    public String getMetadataFilename(String repositoryLocation) {
        return this.getFilename(repositoryLocation, ".meta");
    }

    @Override
    public String getDataFilename(String repositoryLocation) {
        return this.getFilename(repositoryLocation, ".data");
    }

    private String getFilename(String repositoryLocation, String suffix) {
        StringBuilder sb = new StringBuilder(repositoryLocation);
        sb.append(File.separatorChar);
        sb.append(this.getFolderPath());
        sb.append(File.separatorChar);
        sb.append(this.storeID).append(suffix);
        return sb.toString();
    }

    @Override
    public String getStoreID() {
        return this.storeID;
    }
}

