/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.cmrepository.query;

import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cm.repositoryPluginFramework.RepositoryPluginErrors;
import com.cognos.cmutils.messages.Resource;
import com.ibm.cognos.cm.cmrepository.CMRepositoryPluginHttpClient;
import com.ibm.cognos.cm.cmrepository.query.BaseRepositoryQueryHandler;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Properties;

abstract class BaseRepositoryContentQueryHandler
extends BaseRepositoryQueryHandler {
    BaseRepositoryContentQueryHandler(String cmRepositoryBaseURL, CMRepositoryPluginHttpClient httpClient) {
        super(cmRepositoryBaseURL, httpClient);
    }

    String getOutputFileObjectID(String outputObjectID, String outputFilename, Properties connectionProperties) throws RepositoryException {
        String resourceURI = this.buildOutputFileResourceURI(outputObjectID, outputFilename);
        String outputFileObjectID = this.getObjectID(resourceURI, connectionProperties);
        if (outputFileObjectID == null) {
            throw new RepositoryException((Resource.Id)RepositoryPluginErrors.REP_API.repositoryError);
        }
        return outputFileObjectID;
    }

    private String buildOutputFileResourceURI(String outputObjectID, String outputFilename) throws RepositoryException {
        String resourceURI;
        try {
            resourceURI = outputObjectID + "/children?name=" + URLEncoder.encode(outputFilename, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RepositoryException((Resource.Id)RepositoryPluginErrors.REP_API.repositoryError, (Throwable)e);
        }
        return resourceURI;
    }

    private String getObjectID(String resourceURI, Properties connectionProperties) throws RepositoryException {
        String outputFileObjectID = null;
        JSONArray jsonArray = this.executeCMRestQuery(resourceURI, connectionProperties);
        if (!jsonArray.isEmpty()) {
            JSONObject jsonObj = (JSONObject)jsonArray.get(0);
            outputFileObjectID = (String)jsonObj.get((Object)"storeID");
        }
        return outputFileObjectID;
    }
}

