/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.cmrepository.query;

import com.cognos.cm.repositoryPluginAPI.IQueryParameter;
import com.cognos.cm.repositoryPluginAPI.IQueryParameters;
import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cm.repositoryPluginAPI.RepositoryNotAvailableException;
import com.cognos.cm.repositoryPluginFramework.RepositoryLogger;
import com.cognos.cm.repositoryPluginFramework.RepositoryPluginErrors;
import com.cognos.cmutils.messages.Message;
import com.cognos.cmutils.messages.Resource;
import com.ibm.cognos.cm.cmrepository.CMRepositoryErrors;
import com.ibm.cognos.cm.cmrepository.CMRepositoryPluginHttpClient;
import com.ibm.cognos.cm.cmrepository.CMRepositoryPluginHttpResponseResult;
import com.ibm.cognos.cm.cmrepository.query.RepositoryQueryHandler;
import com.ibm.json.java.JSONArray;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

abstract class BaseRepositoryQueryHandler
implements RepositoryQueryHandler {
    private static final String PASSTHROUGH_HEADER_PREFIX = "http.";
    private static final Log log = LogFactory.getLog(RepositoryQueryHandler.class);
    private final String cmRepositoryBaseURL;
    private final CMRepositoryPluginHttpClient httpClient;

    BaseRepositoryQueryHandler(String cmRepositoryBaseURL, CMRepositoryPluginHttpClient httpClient) {
        this.cmRepositoryBaseURL = cmRepositoryBaseURL;
        this.httpClient = httpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JSONArray executeCMRestQuery(String restURI, Properties connectionProperties) throws RepositoryException {
        CMRepositoryPluginHttpResponseResult responseResult = null;
        JSONArray jsonArray = null;
        try {
            String url = this.getCMRepositoryBaseURL() + restURI;
            responseResult = this.executeHTTPRequest(url, null, connectionProperties);
            jsonArray = JSONArray.parse((InputStream)responseResult.getResponseBodyAsStream());
        }
        catch (Exception e) {
            this.handleException(e, (Resource.Id)RepositoryPluginErrors.REP_API.repositoryError);
        }
        finally {
            if (responseResult != null) {
                responseResult.release();
            }
        }
        return jsonArray;
    }

    CMRepositoryPluginHttpResponseResult executeHTTPRequest(String url, IQueryParameters parameters, Properties connectionProperties) throws IOException, RepositoryException {
        String passport = connectionProperties.getProperty("password");
        HttpMethod getMethod = this.httpClient.createGetMethod(url, passport);
        this.setReuqestHeadersFromConnectionProperties(getMethod, connectionProperties);
        this.setOptionalHeaders(parameters, getMethod);
        CMRepositoryPluginHttpResponseResult result = this.httpClient.executeMethod(getMethod);
        this.checkStatusCode(result);
        return result;
    }

    private void setReuqestHeadersFromConnectionProperties(HttpMethod method, Properties props) {
        for (Map.Entry<Object, Object> prop : props.entrySet()) {
            String propName = (String)prop.getKey();
            if (!propName.startsWith(PASSTHROUGH_HEADER_PREFIX)) continue;
            method.setRequestHeader(propName.substring(PASSTHROUGH_HEADER_PREFIX.length()), (String)prop.getValue());
        }
    }

    private void setOptionalHeaders(IQueryParameters parameters, HttpMethod getMethod) {
        if (parameters != null) {
            this.mapParamToHttpHeader(getMethod, parameters, "byteRange", "Range");
        }
    }

    private void mapParamToHttpHeader(HttpMethod getMethod, IQueryParameters parameters, String paramName, String httpHeader) {
        IQueryParameter param = parameters.getParameter(paramName);
        if (param != null) {
            getMethod.setRequestHeader(httpHeader, param.getValue().toString());
        }
    }

    void handleException(Exception e, Resource.Id resourceId) throws RepositoryException {
        Message msg = new Message(resourceId);
        if (e instanceof RepositoryException) {
            ((RepositoryException)((Object)e)).addDetail(msg);
            throw (RepositoryException)((Object)e);
        }
        RepositoryException newEx = new RepositoryException(msg, (Throwable)e);
        newEx.addDetail(e.getMessage());
        throw newEx;
    }

    void checkStatusCode(CMRepositoryPluginHttpResponseResult response) throws RepositoryException {
        if (response == null) {
            throw new RepositoryNotAvailableException(new Message((Resource.Id)CMRepositoryErrors.CRP_REP.noResponseToHttpRequest));
        }
        int code = response.getStatusCode();
        if (code != 200 && code != 204) {
            String msg = "CM repository error: " + code + ")";
            if (log.isErrorEnabled()) {
                log.error((Object)msg);
            }
            RepositoryLogger.logFailure((String)msg);
            throw new RepositoryException(new Message((Resource.Id)CMRepositoryErrors.CRP_REP.failedToPerformHttpRequest).param("RootCause", response.getStatusLine()));
        }
    }

    String getCMRepositoryBaseURL() {
        return this.cmRepositoryBaseURL;
    }
}

