/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.cmrepository.query;

import com.cognos.cm.repositoryPluginAPI.DataDescriptorProperty;
import com.cognos.cm.repositoryPluginAPI.IDataDescriptor;
import com.cognos.cm.repositoryPluginAPI.IDataDescriptorProperty;
import com.cognos.cm.repositoryPluginAPI.IQueryParameter;
import com.cognos.cm.repositoryPluginAPI.IQueryParameters;
import com.cognos.cm.repositoryPluginAPI.IQueryResult;
import com.cognos.cm.repositoryPluginAPI.IQueryResultObjects;
import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cm.repositoryPluginFramework.DataDescriptor;
import com.cognos.cm.repositoryPluginFramework.EmptyQueryResult;
import com.cognos.cm.repositoryPluginFramework.QueryResultObjects;
import com.ibm.cognos.cm.cmrepository.CMQueryResultWithHttpResponse;
import com.ibm.cognos.cm.cmrepository.CMRepositoryErrors;
import com.ibm.cognos.cm.cmrepository.CMRepositoryPluginHttpClient;
import com.ibm.cognos.cm.cmrepository.CMRepositoryPluginHttpResponseResult;
import com.ibm.cognos.cm.cmrepository.query.BaseRepositoryContentQueryHandler;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

class CMContentQueryHandler
extends BaseRepositoryContentQueryHandler {
    CMContentQueryHandler(String cmRepositoryBaseURL, CMRepositoryPluginHttpClient httpClient) {
        super(cmRepositoryBaseURL, httpClient);
    }

    @Override
    public IQueryResult queryObjects(IQueryParameters parameters, Properties connectionProperties) throws RepositoryException {
        IQueryResult result = EmptyQueryResult.INSTANCE;
        CMRepositoryPluginHttpResponseResult httpResponse = null;
        try {
            String outputID = this.getOutputObjectID(parameters);
            if (outputID != null) {
                IQueryParameter qp = parameters.getParameter("outputFileName");
                if (qp != null) {
                    String filename = (String)qp.getValue();
                    outputID = this.getOutputFileObjectID(outputID, filename, connectionProperties);
                }
                String url = this.getCMRepositoryBaseURL() + outputID + "/data";
                httpResponse = this.executeHTTPRequest(url, parameters, connectionProperties);
                result = this.buildQueryResponse(httpResponse);
            }
        }
        catch (Exception e) {
            if (httpResponse != null) {
                httpResponse.release();
            }
            this.handleException(e, CMRepositoryErrors.CRP_OPF.failedToQueryContent);
        }
        return result;
    }

    private String getOutputObjectID(IQueryParameters parameters) {
        IQueryParameter queryParameter = parameters.getParameter("outputObjectID");
        String outputObjectID = null;
        if (queryParameter != null) {
            outputObjectID = (String)queryParameter.getValue();
        }
        return outputObjectID;
    }

    protected IQueryResult buildQueryResponse(CMRepositoryPluginHttpResponseResult responseResult) throws IOException {
        ArrayList<IDataDescriptor> dataDescriptorList = new ArrayList<IDataDescriptor>();
        this.addContentQueryResultObject(dataDescriptorList, responseResult);
        QueryResultObjects objects = new QueryResultObjects(dataDescriptorList);
        CMQueryResultWithHttpResponse result = new CMQueryResultWithHttpResponse(responseResult, (IQueryResultObjects)objects, !dataDescriptorList.isEmpty());
        return result;
    }

    private void addContentQueryResultObject(List<IDataDescriptor> dataDescriptorArray, CMRepositoryPluginHttpResponseResult responseResult) throws IOException {
        InputStream contentStream = responseResult.getResponseBodyAsStream();
        Map<String, String> headers = responseResult.getResponseHeaders();
        DataDescriptor queryResultObject = new DataDescriptor();
        queryResultObject.addProperty((IDataDescriptorProperty)new DataDescriptorProperty("contentStream", (Object)contentStream));
        queryResultObject.addProperty((IDataDescriptorProperty)new DataDescriptorProperty("headers", headers));
        dataDescriptorArray.add((IDataDescriptor)queryResultObject);
    }
}

