/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.cmrepository.query;

import com.cognos.cm.repositoryPluginAPI.IQueryParameter;
import com.cognos.cm.repositoryPluginAPI.IQueryParameters;
import com.cognos.cm.repositoryPluginAPI.IQueryResult;
import com.cognos.cm.repositoryPluginAPI.IQueryResultObjects;
import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cm.repositoryPluginFramework.DataDescriptor;
import com.cognos.cm.repositoryPluginFramework.EmptyQueryResult;
import com.cognos.cm.repositoryPluginFramework.QueryResult;
import com.cognos.cm.repositoryPluginFramework.QueryResultObjects;
import com.ibm.cognos.cm.cmrepository.CMRepositoryErrors;
import com.ibm.cognos.cm.cmrepository.CMRepositoryPluginHttpClient;
import com.ibm.cognos.cm.cmrepository.query.BaseRepositoryQueryHandler;
import com.ibm.cognos.cm.repositoryplugincommon.XMLGregorianCalendarProvider;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.lang.StringUtils;

abstract class ChildrenQueryHandler
extends BaseRepositoryQueryHandler {
    private final String resourceSuffix;
    private final String resourceIDParameterName;

    ChildrenQueryHandler(String cmRepositoryBaseURL, CMRepositoryPluginHttpClient httpClient, String resourceSuffix, String resourceIDParameterName) {
        super(cmRepositoryBaseURL, httpClient);
        this.resourceSuffix = resourceSuffix;
        this.resourceIDParameterName = resourceIDParameterName;
    }

    @Override
    public IQueryResult queryObjects(IQueryParameters parameters, Properties connectionProperties) throws RepositoryException {
        IQueryResult result = EmptyQueryResult.INSTANCE;
        try {
            String resourceID = (String)parameters.getParameter(this.resourceIDParameterName).getValue();
            StringBuilder resourceURI = new StringBuilder(resourceID);
            resourceURI.append("/").append(this.resourceSuffix);
            this.appendRestQueryParameters(parameters, resourceURI);
            result = this.executeQuery(connectionProperties, resourceID, resourceURI.toString());
        }
        catch (Exception e) {
            this.handleException(e, CMRepositoryErrors.CRP_OPF.failedToQuery);
        }
        return result;
    }

    abstract Collection<NameValuePair> getAdditionalRestQueryParameters(IQueryParameters var1);

    abstract DataDescriptor buildDescriptor(String var1, JSONObject var2);

    private void appendRestQueryParameters(IQueryParameters parameters, StringBuilder resourceURI) {
        ArrayList<NameValuePair> restQueryParameters = new ArrayList<NameValuePair>(6);
        restQueryParameters.addAll(this.getAdditionalRestQueryParameters(parameters));
        restQueryParameters.addAll(this.getPaginationParameters(parameters));
        resourceURI.append("?");
        for (NameValuePair param : restQueryParameters) {
            this.appendParameter(resourceURI, param);
        }
    }

    private void appendParameter(StringBuilder resourceURI, NameValuePair param) {
        if (StringUtils.isNotBlank((String)param.getValue())) {
            resourceURI.append(param.getName()).append('=').append(param.getValue()).append('&');
        }
    }

    private List<NameValuePair> getPaginationParameters(IQueryParameters parameters) {
        String skipItems = this.getParameterStringValue(parameters, "skipItems");
        NameValuePair skip = new NameValuePair("skipObjects", skipItems);
        String maxCount = this.getParameterStringValue(parameters, "maxCount");
        NameValuePair max = new NameValuePair("maxObjects", maxCount);
        return Arrays.asList(skip, max);
    }

    private IQueryResult executeQuery(Properties connectionProperties, String resourceID, String resourceURI) throws RepositoryException {
        JSONArray jsonResults = this.executeCMRestQuery(resourceURI, connectionProperties);
        IQueryResult result = jsonResults.isEmpty() ? EmptyQueryResult.INSTANCE : this.buildQueryResult(resourceID, jsonResults);
        return result;
    }

    protected String getParameterStringValue(IQueryParameters parameters, String paramName) {
        IQueryParameter param = parameters.getParameter(paramName);
        String value = "";
        if (param != null && param.getValue() != null) {
            value = String.valueOf(param.getValue());
        }
        return value;
    }

    private IQueryResult buildQueryResult(String resourceID, JSONArray jsonResults) {
        ArrayList<DataDescriptor> dataDescritorList = new ArrayList<DataDescriptor>();
        for (Object item : jsonResults) {
            if (!(item instanceof JSONObject)) continue;
            JSONObject resultItem = (JSONObject)item;
            DataDescriptor descriptor = this.buildDescriptor(resourceID, resultItem);
            dataDescritorList.add(descriptor);
        }
        QueryResultObjects queryResultObjects = new QueryResultObjects(dataDescritorList);
        QueryResult result = new QueryResult((IQueryResultObjects)queryResultObjects, true);
        return result;
    }

    protected Calendar getCalendarFromTimeStamp(String timeStamp) {
        try {
            XMLGregorianCalendar calendar = XMLGregorianCalendarProvider.parse((String)timeStamp);
            return calendar.toGregorianCalendar();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid time stamp", e);
        }
    }
}

