/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.cmrepository.query;

import com.cognos.cm.repositoryPluginAPI.DataDescriptorProperty;
import com.cognos.cm.repositoryPluginAPI.IDataDescriptorProperty;
import com.cognos.cm.repositoryPluginAPI.IQueryParameter;
import com.cognos.cm.repositoryPluginAPI.IQueryParameters;
import com.cognos.cm.repositoryPluginAPI.IQueryResult;
import com.cognos.cm.repositoryPluginAPI.IQueryResultObjects;
import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cm.repositoryPluginFramework.DataDescriptor;
import com.cognos.cm.repositoryPluginFramework.QueryResult;
import com.cognos.cm.repositoryPluginFramework.QueryResultObjects;
import com.cognos.cmutils.messages.Message;
import com.cognos.cmutils.messages.Resource;
import com.ibm.cognos.cm.cmrepository.CMRepositoryPluginHttpClient;
import com.ibm.cognos.cm.cmrepository.io.Metadata;
import com.ibm.cognos.cm.cmrepository.path.FileSystemPath;
import com.ibm.cognos.cm.cmrepository.path.PathBuilder;
import com.ibm.cognos.cm.cmrepository.query.BaseRepositoryContentQueryHandler;
import com.ibm.cognos.cm.repositoryplugincommon.RepositoryPluginCommonErrors;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class EOSContentQueryHandler
extends BaseRepositoryContentQueryHandler {
    static final String GZIP_ENCODING = "gzip";
    static final String FILE_SUCCESSFULLY_READ = "File successfully read: ";
    private static final Log log = LogFactory.getLog(EOSContentQueryHandler.class);
    private final String eosRootPath;

    EOSContentQueryHandler(String eosRootPath, String cmRepositoryBaseURL, CMRepositoryPluginHttpClient httpClient) {
        super(cmRepositoryBaseURL, httpClient);
        this.eosRootPath = eosRootPath;
    }

    @Override
    public IQueryResult queryObjects(IQueryParameters parameters, Properties connectionProperties) throws RepositoryException {
        String outputID = (String)parameters.getParameter("outputObjectID").getValue();
        IQueryParameter qp = parameters.getParameter("outputFileName");
        if (qp != null) {
            String filename = (String)qp.getValue();
            outputID = this.getOutputFileObjectID(outputID, filename, connectionProperties);
        }
        DataDescriptor dataDescriptor = this.getDataDescriptor(outputID);
        return this.buildQueryResult(dataDescriptor);
    }

    private QueryResult buildQueryResult(DataDescriptor dataDescriptor) {
        ArrayList<DataDescriptor> dataDescriptorList = new ArrayList<DataDescriptor>();
        dataDescriptorList.add(dataDescriptor);
        return new QueryResult((IQueryResultObjects)new QueryResultObjects(dataDescriptorList), true);
    }

    private DataDescriptor getDataDescriptor(String storeID) throws RepositoryException {
        try {
            FileSystemPath dataPath = PathBuilder.getInstance().getPath(storeID);
            Metadata metadata = this.loadMetadata(dataPath);
            Map<String, IDataDescriptorProperty> propertyDescriptors = this.getPropertyDescriptors(metadata, dataPath);
            return new DataDescriptor(propertyDescriptors);
        }
        catch (RepositoryException e) {
            if (e.getCause() instanceof FileNotFoundException) {
                return this.getDataDescriptorWithNullContentStream(storeID);
            }
            throw e;
        }
    }

    private DataDescriptor getDataDescriptorWithNullContentStream(String storeID) {
        HashMap<String, IDataDescriptorProperty> propertyDescriptors = new HashMap<String, IDataDescriptorProperty>();
        this.addProperty(propertyDescriptors, "contentStream", null);
        this.addProperty(propertyDescriptors, "objectID", storeID);
        return new DataDescriptor(propertyDescriptors);
    }

    private Metadata loadMetadata(FileSystemPath dataPath) throws RepositoryException {
        File metaDataFile = new File(dataPath.getMetadataFilename(this.eosRootPath));
        Metadata metadata = new Metadata(metaDataFile);
        metadata.load();
        return metadata;
    }

    private Map<String, IDataDescriptorProperty> getPropertyDescriptors(Metadata metadata, FileSystemPath dataPath) throws RepositoryException {
        File dataFile = new File(dataPath.getDataFilename(this.eosRootPath));
        InputStream dataStream = this.getDataInputStream(dataFile);
        HashMap<String, IDataDescriptorProperty> dataProperties = new HashMap<String, IDataDescriptorProperty>(3 + metadata.size());
        this.addProperty(dataProperties, "contentStream", dataStream);
        this.addProperty(dataProperties, "objectID", dataPath.getStoreID());
        HashMap<String, String> headers = new HashMap<String, String>();
        String contentType = metadata.getProperty("contentType");
        if (contentType != null) {
            headers.put("Content-Type", contentType);
            headers.put("Content-Disposition", metadata.getProperty("contentDisposition"));
            if (Boolean.valueOf(metadata.getProperty("compressed")).booleanValue()) {
                headers.put("Content-Encoding", GZIP_ENCODING);
            }
        }
        this.addProperty(dataProperties, "headers", headers);
        this.addMetadata(dataProperties, metadata);
        return dataProperties;
    }

    private void addMetadata(Map<String, IDataDescriptorProperty> dataProperties, Metadata metadata) {
        for (String propName : metadata.getPropertyNames()) {
            this.addProperty(dataProperties, propName, metadata.getProperty(propName));
        }
    }

    private void addProperty(Map<String, IDataDescriptorProperty> dataProperties, String propertyName, Object o) {
        dataProperties.put(propertyName, (IDataDescriptorProperty)new DataDescriptorProperty(propertyName, o));
    }

    InputStream getDataInputStream(File dataFile) throws RepositoryException {
        try {
            FileInputStream is = new FileInputStream(dataFile);
            this.logSuccessfulRead(dataFile);
            return is;
        }
        catch (FileNotFoundException e) {
            if (!dataFile.exists()) {
                return null;
            }
            Message msg = new Message((Resource.Id)RepositoryPluginCommonErrors.CPG_OPF.failedToReadAndParseFile);
            throw new RepositoryException(msg, (Throwable)e);
        }
        catch (SecurityException e) {
            Message msg = new Message((Resource.Id)RepositoryPluginCommonErrors.CPG_OPF.failedToReadAndParseFile);
            throw new RepositoryException(msg, (Throwable)e);
        }
    }

    private void logSuccessfulRead(File f) {
        if (log.isDebugEnabled()) {
            log.debug((Object)(FILE_SUCCESSFULLY_READ + f.getAbsolutePath()));
        }
    }
}

