/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.cmrepository.query;

import com.cognos.cm.repositoryPluginAPI.IQueryParameter;
import com.cognos.cm.repositoryPluginAPI.IQueryParameters;
import com.cognos.cm.repositoryPluginAPI.IQueryResult;
import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cm.repositoryPluginFramework.EmptyQueryResult;
import com.ibm.cognos.cm.cmrepository.CMRepositoryErrors;
import com.ibm.cognos.cm.cmrepository.CMRepositoryPluginHttpClient;
import com.ibm.cognos.cm.cmrepository.CMRepositoryPluginHttpResponseResult;
import com.ibm.cognos.cm.cmrepository.query.CMContentQueryHandler;
import java.util.Properties;

class ObjectContentQueryHandler
extends CMContentQueryHandler {
    ObjectContentQueryHandler(String cmRepositoryBaseURL, CMRepositoryPluginHttpClient httpClient) {
        super(cmRepositoryBaseURL, httpClient);
    }

    @Override
    public IQueryResult queryObjects(IQueryParameters parameters, Properties connectionProperties) throws RepositoryException {
        IQueryResult result = EmptyQueryResult.INSTANCE;
        CMRepositoryPluginHttpResponseResult responseResult = null;
        try {
            String objectID = this.getObjectID(parameters);
            if (objectID != null) {
                String url = this.getCMRepositoryBaseURL() + objectID + "/_content";
                responseResult = this.executeHTTPRequest(url, parameters, connectionProperties);
                result = this.buildQueryResponse(responseResult);
            }
        }
        catch (Exception e) {
            if (responseResult != null) {
                responseResult.release();
            }
            this.handleException(e, CMRepositoryErrors.CRP_OPF.failedToQueryContent);
        }
        return result;
    }

    private String getObjectID(IQueryParameters parameters) {
        IQueryParameter queryParameter = parameters.getParameter("objectID");
        String outputObjectID = null;
        if (queryParameter != null) {
            outputObjectID = (String)queryParameter.getValue();
        }
        return outputObjectID;
    }
}

