/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cm.cmrepository.query;

import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.ibm.cognos.cm.cmrepository.CMRepositoryPluginHttpClient;
import com.ibm.cognos.cm.cmrepository.config.PluginConfiguration;
import com.ibm.cognos.cm.cmrepository.config.PluginConfigurationProvider;
import com.ibm.cognos.cm.cmrepository.query.BaseRepositoryContentQueryHandler;
import com.ibm.cognos.cm.cmrepository.query.CMContentQueryHandler;
import com.ibm.cognos.cm.cmrepository.query.ContentValidator;
import com.ibm.cognos.cm.cmrepository.query.DefaultOutputQueryHandler;
import com.ibm.cognos.cm.cmrepository.query.EOSContentQueryHandler;
import com.ibm.cognos.cm.cmrepository.query.NoOpQueryHandler;
import com.ibm.cognos.cm.cmrepository.query.ObjectContentQueryHandler;
import com.ibm.cognos.cm.cmrepository.query.OutputGraphicListQueryHandler;
import com.ibm.cognos.cm.cmrepository.query.ReportVersionsQueryHandler;
import com.ibm.cognos.cm.cmrepository.query.RepositoryQueryHandler;
import com.ibm.cognos.cm.cmrepository.query.VersionOutputsQueryHandler;

public class RepositoryQueryHandlerFactory {
    public static final String DEFAULT_OUTPUT = "default";
    private String cmRepositoryBaseURL;
    private CMRepositoryPluginHttpClient httpClient;
    private final PluginConfiguration configuration;

    RepositoryQueryHandlerFactory() throws RepositoryException {
        this(PluginConfigurationProvider.getInstance().getConfiguration());
    }

    RepositoryQueryHandlerFactory(PluginConfiguration configuration) {
        this.configuration = configuration;
    }

    public RepositoryQueryHandler getContentQueryHandler(String objectID, ContentValidator contentValidator) throws RepositoryException {
        BaseRepositoryContentQueryHandler handler = this.configuration.isEOSenabled() && contentValidator.objectExists(objectID) ? new EOSContentQueryHandler(this.configuration.getEOSrootPath(), this.cmRepositoryBaseURL, this.httpClient) : new CMContentQueryHandler(this.cmRepositoryBaseURL, this.httpClient);
        return handler;
    }

    public RepositoryQueryHandler getQueryHandler(String queryName, String outputID) {
        RepositoryQueryHandler queryHandler = "getReportVersionsBetweenTime".equals(queryName) ? new ReportVersionsQueryHandler(this.cmRepositoryBaseURL, this.httpClient) : ("getVersionOutputs".equals(queryName) ? new VersionOutputsQueryHandler(this.cmRepositoryBaseURL, this.httpClient) : ("getOutputContent".equals(queryName) && DEFAULT_OUTPUT.equalsIgnoreCase(outputID) ? new DefaultOutputQueryHandler(this.cmRepositoryBaseURL, this.httpClient) : ("getOutputFileList".equals(queryName) ? new OutputGraphicListQueryHandler(this.cmRepositoryBaseURL, this.httpClient) : ("getObjectContent".equals(queryName) ? new ObjectContentQueryHandler(this.cmRepositoryBaseURL, this.httpClient) : NoOpQueryHandler.getInstance()))));
        return queryHandler;
    }

    public void setCmRepositoryBaseURL(String cmRepositoryBaseURL) {
        this.cmRepositoryBaseURL = cmRepositoryBaseURL;
    }

    public void setHttpClient(CMRepositoryPluginHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public static RepositoryQueryHandlerFactory getInstance() throws RepositoryException {
        return new RepositoryQueryHandlerFactory();
    }
}

